/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.internal.zzi5;
import com.aspose.words.zzVXx;
import com.aspose.words.zzXGB;
import com.aspose.words.zzXL8;
import com.aspose.words.zzXUu;
import com.aspose.words.zzXhk;
import com.aspose.words.zzYVG;
import com.aspose.words.zzYkw;
import com.aspose.words.zzZod;
import com.aspose.words.zzga;
import com.aspose.words.zzl1;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzZod zzWVb;

    ChartSeriesCollection(zzZod dmlChart) {
        this.zzWVb = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWVb.zzbx().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWVb.zzbx().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzWVb.zzbx().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzWVb.zzbx().clear();
        this.zzW0c(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWGp(seriesName, values);
        chartSeries.zzPU().zzXfK(ChartSeriesCollection.zzW5w(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWGp(seriesName, yValues);
        chartSeries.zzPU().zzXfK(ChartSeriesCollection.zzXfK(xValues));
        return chartSeries;
    }

    private ChartSeries zzWGp(String string, zzi5[] zzi5Array, double[] dArray) {
        if (zzi5Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzi5Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzi5Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWGp(string, dArray);
        chartSeries.zzPU().zzXfK(ChartSeriesCollection.zzWGp(zzi5Array));
        if (!this.zzWVb.zzZth()) {
            this.zzW0c(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzWGp(seriesName, zzi5.zzWGp(dates), values);
    }

    private void zzW0c(boolean bl) {
        zzXUu zzXUu2 = zzZ23.zzWGp((Object)this.zzWVb, zzXUu.class);
        if (zzXUu2 != null && zzXUu2.zzpB().zzZwk()) {
            zzXUu2.zzpB().zzZI3().zzWS4(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzWVb.zzZF0() != 15) {
            this.zzWVb.zzVTF(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzWGp(seriesName, yValues);
        chartSeries.zzWb().zzJi().zzWS4(3, this.zzWVb.zzKN());
        chartSeries.zzPU().zzXfK(ChartSeriesCollection.zzXfK(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzYh3().zzXfK(ChartSeriesCollection.zzXfK(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzWGp(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzWVb);
        chartSeries.setName(string);
        this.zzZU6(chartSeries);
        chartSeries.zzXTg(this.zzWVb.zzbx().size());
        ChartSeries chartSeries2 = chartSeries;
        chartSeries2.zzWxz(chartSeries2.getIndex());
        chartSeries.zzYYW().zzXfK(ChartSeriesCollection.zzXfK(dArray));
        chartSeries.zzW8A().zzXfK(chartSeries.zzYYW().zzW72());
        this.zzWVb.zzZsu(chartSeries);
        return chartSeries;
    }

    private void zzZU6(ChartSeries chartSeries) {
        chartSeries.zzWb().zzJi().zzWS4(5, new zzYkw());
        switch (this.zzWVb.zzZF0()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzWGp(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzWGp(chartSeries, 5);
                ChartSeriesCollection.zzZ6K(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzWGp(chartSeries, 1);
                ChartSeriesCollection.zzZ6K(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzSB(chartSeries);
            }
        }
    }

    private static void zzSB(ChartSeries chartSeries) {
        zzYkw zzYkw2 = new zzYkw();
        zzYkw2.zz2z(new zzXhk());
        zzl1 zzl12 = new zzl1();
        zzl12.zzWdz(1);
        zzYkw2.zznM().zz2z(new zzYVG(zzl12));
        zzYkw2.zznM().zzzU(19050.0);
        chartSeries.zzWb().zzJi().zzWS4(5, zzYkw2);
    }

    private static void zzZ6K(ChartSeries chartSeries) {
        zzYkw zzYkw2 = new zzYkw();
        zzYkw2.zz2z(new zzXhk());
        zzYkw2.zznM().zz2z(new zzXGB());
        zzYkw2.zznM().setEndCap(0);
        zzYkw2.zznM().zzzU(19050.0);
        chartSeries.zzWb().zzJi().zzWS4(5, zzYkw2);
    }

    private static void zzWGp(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzXFY().zzWS4(0, n);
        chartSeries.zzWb().zzJi().zzWS4(4, chartMarker);
    }

    private static zzXL8 zzXfK(double[] dArray) {
        int n = 0;
        zzXL8 zzXL82 = new zzXL8(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzXL82.zzZ6K(new zzga(n, d, "General"));
            }
            ++n;
        }
        zzXL82.zzwN(dArray.length);
        zzXL82.zzZrb();
        return zzXL82;
    }

    private static zzXL8 zzWGp(zzi5[] zzi5Array) {
        int n = 0;
        zzXL8 zzXL82 = new zzXL8(2, false);
        zzi5[] zzi5Array2 = zzi5Array;
        int n2 = zzi5Array.length;
        for (int i = 0; i < n2; ++i) {
            zzi5 zzi52 = zzi5Array2[i];
            zzXL82.zzZ6K(new zzga(n++, zzi52.zzW0v(), "m/d/yyyy"));
        }
        zzXL82.zzwN(zzi5Array.length);
        zzXL82.zzZrb();
        return zzXL82;
    }

    private static zzXL8 zzW5w(String[] stringArray) {
        int n = 0;
        zzXL8 zzXL82 = new zzXL8(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzXL82.zzZ6K(new zzVXx(n++, string));
        }
        zzXL82.zzwN(stringArray.length);
        zzXL82.zzZrb();
        return zzXL82;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWVb.zzbx().size();
    }
}

