/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.zzJR;
import com.aspose.words.zzWW9;
import com.aspose.words.zzWiN;
import com.aspose.words.zzY78;
import com.aspose.words.zzYbi;
import com.aspose.words.zzYei;
import com.aspose.words.zzZD0;
import com.aspose.words.zzZE2;
import com.aspose.words.zzZcd;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzWiN,
Iterable<T> {
    private Node zzYff;
    private Node zzWC0;
    private Node zzVYI;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() throws Exception {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zz1() {
        return this.zzXKy() != null;
    }

    final boolean zzXtP() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzZUb() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzZD0) {
                return true;
            }
            CompositeNode compositeNode = zzZ23.zzWGp((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzZUb()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzYff;
    }

    public Node getLastChild() {
        return this.zzWC0;
    }

    final Node zzXKy() {
        return zzYei.zzVTF(this.getFirstChild(), false);
    }

    final Node zzAy() {
        return zzYei.zzZU6(this.getLastChild(), false);
    }

    final CompositeNode zzYiR() {
        return (CompositeNode)zzYei.zzVTF(this.getFirstChild(), true);
    }

    final CompositeNode zzYbK() {
        return (CompositeNode)zzYei.zzZU6(this.getLastChild(), true);
    }

    final Node zzUx() {
        Node node;
        for (node = this.getFirstChild(); node != null && zzYei.zzWnx(node); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzXj6() {
        Node node;
        for (node = this.getLastChild(); node != null && zzYei.zzWnx(node); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzWGp(boolean bl, zzZcd zzZcd2) {
        CompositeNode compositeNode = (CompositeNode)super.zzWGp(bl, zzZcd2);
        ((CompositeNode)super.zzWGp(bl, zzZcd2)).zzWC0 = null;
        compositeNode.zzYff = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWCX(node.zzWGp(true, zzZcd2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWXR(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzWXR(StringBuilder stringBuilder) {
        this.zzMu(stringBuilder);
        zzZ23.zz2z(stringBuilder, this.zzZlk());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zz2z(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYei.zzWKu(nodeType);
            Node node2 = node = bl ? this.zzXKy() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zz0x() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzJR.zzZuG(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzJR.zzXfK(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzY78(this);
    }

    public Node appendChild(Node newChild) throws Exception {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) throws Exception {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) throws Exception {
        return this.zzWGp(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) throws Exception {
        return this.zzWGp(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzWGp(oldChild, this, null, 1);
        if (documentBase.zzXue() && zzYbi.zzWPy(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzWGp(nodeChangingArgs);
        }
        Node node = this.zzYlm(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zz2z(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzWW9.zzWnx(this.getFirstChild(), null);
    }

    public void removeSmartTags() throws Exception {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWCX(Node node) {
        node.getParentNode();
        if (this.zzWC0 == null) {
            node.zzY88(null);
            node.zzXsU(null);
            this.zzYff = node;
        } else {
            node.zzY88(this.zzWC0);
            node.zzXsU(null);
            this.zzWC0.zzXsU(node);
        }
        this.zzWC0 = node;
        node.zzW0c(this);
        return node;
    }

    final void zzWGp(Node node, Node node2, Node node3) throws Exception {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zz2z(Node node, Node node2, Node node3) throws Exception {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zz2z(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzYei.zzWnx(node2)) continue;
            if (zzYei.zzZUE(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZlk().length();
    }

    String zzZlk() {
        return "";
    }

    final String zzXfD() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzMu(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzMu(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzWXR(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzWGp(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zz2z(visitor));
    }

    abstract int zzWGp(DocumentVisitor var1) throws Exception;

    abstract int zz2z(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzZU6(Node var1);

    final Node zzWGp(Node node, Node node2, boolean bl) throws Exception {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzya(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzZU6(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzZE2(documentBase);
            try {
                compositeNode.removeChild(node);
            }
            finally {
                ((zzZE2)object).dispose();
            }
        }
        if ((object = documentBase.zzWGp(node, null, this, 0)) != null) {
            documentBase.zzWGp((NodeChangingArgs)object);
        }
        if (this.zzWC0 == null) {
            node.zzY88(null);
            node.zzXsU(null);
            this.zzYff = node;
            this.zzWC0 = node;
        } else if (bl) {
            if (node2 != null) {
                this.zz2z(node, node2);
            } else {
                this.zzZuG(node, this.zzYff);
            }
        } else if (node2 != null) {
            this.zzZuG(node, node2);
        } else {
            this.zz2z(node, this.zzWC0);
        }
        node.zzW0c(this);
        if (object != null) {
            documentBase.zz2z((NodeChangingArgs)object);
        }
        if (documentBase.zzXue()) {
            zzYbi.zzWGp(node, compositeNode, node3);
        }
        return node;
    }

    private void zz2z(Node node, Node node2) {
        Node node3 = node2.zzXLq();
        node.zzY88(node2);
        node.zzXsU(node3);
        node2.zzXsU(node);
        if (node3 == null) {
            this.zzWC0 = node;
            return;
        }
        node3.zzY88(node);
    }

    private void zzZuG(Node node, Node node2) {
        Node node3 = node2.zzXcB();
        node.zzY88(node3);
        node.zzXsU(node2);
        node2.zzY88(node);
        if (node3 == null) {
            this.zzYff = node;
            return;
        }
        node3.zzXsU(node);
    }

    private Node zzYlm(Node node) {
        if (node == this.zzYff) {
            if (this.zzYff == this.zzWC0) {
                this.zzYff = null;
                this.zzWC0 = null;
            } else {
                this.zzYff = node.zzXLq();
                this.zzYff.zzY88(null);
            }
        } else {
            Node node2 = node.zzXcB();
            Node node3 = node.zzXLq();
            node2.zzXsU(node3);
            if (node3 == null) {
                this.zzWC0 = node2;
            } else {
                node3.zzY88(node2);
            }
        }
        node.zzXsU(null);
        node.zzY88(null);
        node.zzW0c(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzVYI = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzVYI;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

