/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.zzWiN;
import com.aspose.words.zzY78;
import com.aspose.words.zzYbZ;
import com.aspose.words.zzZVp;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzWiN,
Iterable<T> {
    private Node zzVYI;
    private CompositeNode zzYC4;
    private DocumentBase zzWEd;
    private boolean zzXgh;
    private int zzWJL;
    private int zzXBy;
    private Node zzeM;
    private int zzZow;
    private zzYbZ zzZNa;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzZVp(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZVp(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzYbZ matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzYC4 = container;
        this.zzWEd = container.getDocument();
        this.zzZNa = matcher;
        this.zzXgh = isDeep;
        this.zzXv3();
    }

    public Node get(int index) {
        try {
            this.zzgi();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzXBy == index) {
                return this.zzeM;
            }
            int n = index - this.zzXBy;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzYYL(nodeCollection.zzeM, n);
            if (node != null) {
                this.zzXBy = index;
                this.zzeM = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) throws Exception {
        if (this.zzXgh) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzYC4.appendChild(node);
    }

    public void insert(int index, Node node) throws Exception {
        if (this.zzXgh) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzYC4.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzyd();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzY78(this);
    }

    final <TNode extends Node> zzY78<TNode> zzt1() {
        return new zzY78(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzyd() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZ23.zzWGp(arrayList, node);
        }
        return arrayList;
    }

    private Node zzYYL(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzWCX(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzzp(curNode, true);
    }

    private Node zzzp(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzVYI = node;
        do {
            node2 = this.zzVYI;
            Node node3 = this.zzXgh ? this.zzWGp(true, this.zzVYI) : (this.zzVYI = this.zzZNa.zzZlX() ? this.zzZuG(true, this.zzVYI) : this.zz2z(true, this.zzVYI));
        } while (this.zzVYI != null && !this.zzZNa.zzMu(this.zzVYI));
        return node2;
    }

    private Node zzWCX(Node node, boolean bl) throws Exception {
        while ((this.zzXgh ? this.zzWGp(bl, node) : (node = this.zzZNa.zzZlX() ? this.zzZuG(bl, node) : this.zz2z(bl, node))) != null && !this.zzZNa.zzMu(node)) {
        }
        return node;
    }

    private Node zzWGp(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzYC4);
        }
        return node.previousPreOrder(this.zzYC4);
    }

    private Node zz2z(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzYC4) {
                return this.zzYC4.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzYC4) {
            return this.zzYC4.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzZuG(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzYC4 ? this.zzYC4.zzXKy() : node.zz0x();
        } else {
            Node node3 = node2 = node == this.zzYC4 ? this.zzYC4.zzAy() : node.zzTy();
        }
        if (node2 == this.zzYC4.getNextSibling() || node2 == this.zzYC4.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzgi() {
        if (this.zzWJL != this.zzXb2()) {
            this.zzXv3();
        }
    }

    private void zzXv3() {
        this.zzWJL = this.zzXb2();
        this.zzXBy = -1;
        this.zzeM = this.zzYC4;
        this.zzZow = -1;
    }

    private int zzXb2() {
        if (this.zzWEd != null) {
            return this.zzWEd.zzeC();
        }
        return 0;
    }

    public int getCount() {
        this.zzgi();
        if (this.zzZow == -1) {
            this.zzZow = zzY78.zzWGp(this);
        }
        return this.zzZow;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzVYI;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzYC4;
    }
}

