/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzXiQ;
import com.aspose.words.internal.zzZcq;

public abstract class SaveOptions {
    private boolean zzXof;
    private boolean zzVQY = true;
    private boolean zzXZM = false;
    private boolean zzYeV = true;
    private boolean zzYR6;
    private String zzWAp;
    private boolean zzYwZ;
    private boolean zzZnB = false;
    private boolean zz1v = true;
    private int zzWaZ = 1;
    private int zzXR4 = 0;
    private String zzDX = "";
    private boolean zzZKE = true;
    private boolean zz7r = true;
    private boolean zzXfC;
    private boolean zzXGJ;
    private int zzYil = 0;
    private boolean zzXOO = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzWVd() {
        return false;
    }

    boolean zzZdc() {
        return true;
    }

    final boolean zzX8J() {
        return this.zzYeV;
    }

    public String getTempFolder() {
        return this.zzWAp;
    }

    public void setTempFolder(String value) {
        this.zzWAp = value;
    }

    public boolean getPrettyFormat() {
        return this.zzYR6;
    }

    public void setPrettyFormat(boolean value) {
        this.zzYR6 = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYwZ;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYwZ = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzZnB;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzZnB = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zz1v;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zz1v = value;
    }

    public int getDmlRenderingMode() {
        return this.zzWaZ;
    }

    public void setDmlRenderingMode(int value) {
        this.zzWaZ = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzXR4;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzXR4 = value;
    }

    public String getDefaultTemplate() {
        return this.zzDX;
    }

    public void setDefaultTemplate(String value) {
        this.zzDX = value;
    }

    public boolean getUpdateFields() {
        return this.zzZKE;
    }

    public void setUpdateFields(boolean value) {
        this.zzZKE = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzXfC;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzXfC = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzXGJ;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzXGJ = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXZM;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXZM = value;
    }

    final boolean zzSY() {
        return this.zz7r;
    }

    final boolean zz2j() {
        return this.zzXOO;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzVYi(zzZcq.zzZ5Y(zzXiQ.zz9E(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzYil;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzYil = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzXof;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzXof = value;
    }

    final boolean zzCW() {
        return this.zzVQY;
    }
}

