/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzY6t;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zz2z;
import com.aspose.words.net.System.Data.zzVTF;
import com.aspose.words.net.System.Data.zzZkD;
import com.aspose.words.net.System.Data.zzZuG;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzYfj;
    private final DataColumnCollection zzY2K;
    private final ConstraintCollection zzVZh;
    private final zzVTF zzYEK;
    private ResultSet zzVWK;
    private String zzY7M;
    private DataSet zzX7k;
    private String zzYM2;
    private UniqueConstraint zzX8G;
    private boolean zzWzr;
    private final List<DataTableEventListener> zzYqY;
    private final Set<DataRow> zzsg;

    public DataTable() {
        this.zzYfj = new DataRowCollection(this);
        this.zzY2K = new DataColumnCollection(this);
        this.zzVZh = new ConstraintCollection(this);
        this.zzYEK = new zzVTF(this);
        this.zzYM2 = "";
        this.zzWzr = true;
        this.zzYqY = new ArrayList<DataTableEventListener>();
        this.zzsg = new HashSet<DataRow>();
    }

    public DataTable(String tableName) {
        this.zzYfj = new DataRowCollection(this);
        this.zzY2K = new DataColumnCollection(this);
        this.zzVZh = new ConstraintCollection(this);
        this.zzYEK = new zzVTF(this);
        this.zzYM2 = "";
        this.zzWzr = true;
        this.zzYqY = new ArrayList<DataTableEventListener>();
        this.zzsg = new HashSet<DataRow>();
        this.zzY7M = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zz2z.zzWGp(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzYfj = new DataRowCollection(this);
        this.zzY2K = new DataColumnCollection(this);
        this.zzVZh = new ConstraintCollection(this);
        this.zzYEK = new zzVTF(this);
        this.zzYM2 = "";
        this.zzWzr = true;
        this.zzYqY = new ArrayList<DataTableEventListener>();
        this.zzsg = new HashSet<DataRow>();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzVWK = resultSet;
        this.zzY7M = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzVWK != null) {
            if (this.zzVWK.getStatement() != null) {
                this.zzVWK.getStatement().getConnection().close();
            }
            this.zzVWK = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzY7M;
    }

    public void setTableName(String tableName) {
        this.zzY7M = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzY2K.getCount();
    }

    public String getColumnName(int index) {
        return this.zzY2K.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzVWK;
    }

    public DataSet getDataSet() {
        return this.zzX7k;
    }

    final void zzXfK(DataSet dataSet) {
        this.zzX7k = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzX7k.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzX7k.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzYfj;
    }

    public DataColumnCollection getColumns() {
        return this.zzY2K;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzVZh;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzX8G == null) {
            return new DataColumn[0];
        }
        return this.zzX8G.getColumns();
    }

    final void zzVTF(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzX8G != null) {
                this.zzX8G.zzWJA(false);
                this.getConstraints().remove(this.zzX8G);
                this.zzX8G = null;
            }
            return;
        }
        if (this.zzX8G != null && DataColumn.areColumnSetsTheSame(value, this.zzX8G.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzWGp(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzX8G != null) {
            this.zzX8G.zzWJA(false);
            this.getConstraints().remove(this.zzX8G);
            this.zzX8G = null;
        }
        UniqueConstraint.zzWGp(this.getConstraints(), uniqueConstraint);
        this.zzX8G = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzYM2;
    }

    public void setNamespace(String namespace) {
        this.zzYM2 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzWzr;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzWzr = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzsg.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zz2z.zzWGp(this.getResultSet(), this);
            zz2z.zz2z(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzY6t.zzXfK(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zz2z.zzZuG(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzYqY.contains(listener)) {
            this.zzYqY.add(listener);
        }
    }

    public void removeEventListener(zzZuG listener) {
        if (this.zzYqY.contains(listener)) {
            this.zzYqY.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzYqY.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzsg.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYqY) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzsg.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYqY) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzsg.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYqY) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYqY) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYqY) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzZkD zzWGp(zz2z[] zz2zArray) {
        DataColumn[] dataColumnArray = new DataColumn[zz2zArray.length];
        for (int i = 0; i < zz2zArray.length; ++i) {
            dataColumnArray[i] = zz2zArray[i].zzZu7();
        }
        DataTable dataTable = this;
        zzZkD zzZkD2 = dataTable.zzYEK.zzXfK(dataColumnArray);
        if (zzZkD2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzZkD2;
    }

    final zzVTF zzZBQ() {
        return this.zzYEK;
    }

    final Set<DataRow> zzXgt() {
        return this.zzsg;
    }
}

