/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.zzE6;
import com.aspose.words.zzWJS;
import com.aspose.words.zzWUW;
import com.aspose.words.zzWwN;
import com.aspose.words.zzYF7;
import com.aspose.words.zzYFS;
import com.aspose.words.zzYgf;
import com.aspose.words.zzZJV;
import com.aspose.words.zzp;
import com.aspose.words.zzzC;

public class Cell
extends CompositeNode<Node>
implements zzE6,
zzp {
    private zzWJS zzXkC;
    private CellFormat zzWaM;
    private ParagraphCollection zzYhz;
    private TableCollection zzYp7;

    public Cell(DocumentBase doc) {
        this(doc, new zzWJS());
    }

    Cell(DocumentBase doc, zzWJS cellPr) {
        super(doc);
        this.zzXkC = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzY1H() {
        return (Cell)this.zzfO();
    }

    public Row getParentRow() {
        return (Row)this.zzZFr();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzWYh() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzXou(this, true);
        }
        return -1;
    }

    final int zzZ0v() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzZ0v();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzWaM == null) {
            this.zzWaM = new CellFormat(this);
        }
        return this.zzWaM;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzYhz == null) {
            this.zzYhz = new ParagraphCollection(this);
        }
        return this.zzYhz;
    }

    public TableCollection getTables() {
        if (this.zzYp7 == null) {
            this.zzYp7 = new TableCollection(this);
        }
        return this.zzYp7;
    }

    final zzWJS zzr7() {
        return this.zzXkC;
    }

    final void zzWuo(zzWJS zzWJS2) {
        this.zzXkC = zzWJS2;
    }

    @Override
    final Node zzWuo(boolean bl, zzZJV zzZJV2) {
        zzWJS zzWJS2;
        Cell cell = (Cell)super.zzWuo(bl, zzZJV2);
        zzWJS zzWJS3 = this.zzXkC;
        cell.zzXkC = zzWJS2 = (zzWJS)zzWJS3.zzWqN();
        cell.zzWaM = null;
        cell.zzYhz = null;
        cell.zzYp7 = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWuo(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzXou(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzWwN.zzYte(this);
    }

    @Override
    final boolean zzZQl(Node node) {
        return zzYFS.zzW6E(node);
    }

    final int zzWSh() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzfO();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXkC.zzZK2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzXkC.zzZK2(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzWUW zzWUW2 = zzZ0T.zzWuo(object, zzWUW.class);
        if (zzWUW2 != null && zzWUW2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZU5(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzWJS.zzXRb(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzXkC.zzX8D(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXkC.clear();
    }

    private Object zzZU5(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzZ0T.zzWuo((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzWuo(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzzC getInsertRevision() {
        Cell cell = this;
        return cell.zzXkC.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzzC value) {
        Cloneable cloneable = this;
        zzzC zzzC2 = value;
        cloneable = cloneable.zzXkC;
        ((zzYgf)cloneable).zzX8D(14, zzzC2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzzC getDeleteRevision() {
        Cell cell = this;
        return cell.zzXkC.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzzC value) {
        Cloneable cloneable = this;
        zzzC zzzC2 = value;
        cloneable = cloneable.zzXkC;
        ((zzYgf)cloneable).zzX8D(12, zzzC2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYF7 getMoveFromRevision() {
        Cell cell = this;
        return cell.zzXkC.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzYF7 value) {
        Cloneable cloneable = this;
        zzYF7 zzYF72 = value;
        cloneable = cloneable.zzXkC;
        ((zzYgf)cloneable).zzX8D(13, zzYF72);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYF7 getMoveToRevision() {
        Cell cell = this;
        return cell.zzXkC.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzYF7 value) {
        Cloneable cloneable = this;
        zzYF7 zzYF72 = value;
        cloneable = cloneable.zzXkC;
        ((zzYgf)cloneable).zzX8D(15, zzYF72);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzXkC.remove(13);
        cell = this;
        cell.zzXkC.remove(15);
    }

    final zzWJS zzWOQ(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzWJS zzWJS2 = new zzWJS();
        this.zzWuo(3120, zzWJS2);
        this.zzWuo(3140, zzWJS2);
        this.zzWuo(3110, zzWJS2);
        this.zzWuo(3130, zzWJS2);
        this.zzWuo(3090, zzWJS2);
        this.zzWuo(3100, zzWJS2);
        this.zzWuo(3070, zzWJS2);
        this.zzWuo(3080, zzWJS2);
        if (bl && (tableStyle = zzZ0T.zzWuo((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzXou(this, zzWJS2);
        }
        this.zzXkC.zzXou((zzYgf)zzWJS2);
        return zzWJS2;
    }

    private void zzWuo(int n, zzWJS zzWJS2) {
        zzWJS2.zzX8D(n, this.fetchInheritedCellAttr(n));
    }
}

