/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.internal.zzur;
import com.aspose.words.zzWYL;
import com.aspose.words.zzXPz;
import com.aspose.words.zzY3r;
import com.aspose.words.zzYAn;
import com.aspose.words.zzYPq;
import com.aspose.words.zzYiQ;
import com.aspose.words.zzYlj;
import com.aspose.words.zzYvz;
import com.aspose.words.zzh9;
import com.aspose.words.zzlR;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzYAn zzWbG;

    ChartSeriesCollection(zzYAn dmlChart) {
        this.zzWbG = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWbG.zzWQJ().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWbG.zzWQJ().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzWbG.zzWQJ().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzWbG.zzWQJ().clear();
        this.zzW5S(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWuo(seriesName, values);
        chartSeries.zz6T().zzYnz(ChartSeriesCollection.zzXPe(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWuo(seriesName, yValues);
        chartSeries.zz6T().zzYnz(ChartSeriesCollection.zzYnz(xValues));
        return chartSeries;
    }

    private ChartSeries zzWuo(String string, zzur[] zzurArray, double[] dArray) {
        if (zzurArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzurArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzurArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWuo(string, dArray);
        chartSeries.zz6T().zzYnz(ChartSeriesCollection.zzWuo(zzurArray));
        if (!this.zzWbG.zzW4A()) {
            this.zzW5S(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzWuo(seriesName, zzur.zzWuo(dates), values);
    }

    private void zzW5S(boolean bl) {
        zzYiQ zzYiQ2 = zzZ0T.zzWuo((Object)this.zzWbG, zzYiQ.class);
        if (zzYiQ2 != null && zzYiQ2.zzWzt().zzZVM()) {
            zzYiQ2.zzWzt().zzX2R().zzZvM(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzWbG.zzZpk() != 15) {
            this.zzWbG.zzW9K(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzWuo(seriesName, yValues);
        chartSeries.zzXKx().zzXKK().zzZvM(3, this.zzWbG.zzZjW());
        chartSeries.zz6T().zzYnz(ChartSeriesCollection.zzYnz(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzWDI().zzYnz(ChartSeriesCollection.zzYnz(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzWuo(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzWbG);
        chartSeries.setName(string);
        this.zzZQl(chartSeries);
        chartSeries.zzW2b(this.zzWbG.zzZoQ().zzDm() + 1);
        chartSeries.zzZoM(this.zzWbG.zzZoQ().zzXnK() + 1);
        chartSeries.zzY7l().zzYnz(ChartSeriesCollection.zzYnz(dArray));
        chartSeries.zzYCP().zzYnz(chartSeries.zzY7l().zzZgO());
        this.zzWbG.zzX6R().zzXwK();
        this.zzWbG.zzWTv(chartSeries);
        return chartSeries;
    }

    private void zzZQl(ChartSeries chartSeries) {
        chartSeries.zzXKx().zzXKK().zzZvM(5, new zzlR());
        switch (this.zzWbG.zzZpk()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzWuo(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzWuo(chartSeries, 5);
                ChartSeriesCollection.zzYzG(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzWuo(chartSeries, 1);
                ChartSeriesCollection.zzYzG(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzXNO(chartSeries);
            }
        }
    }

    private static void zzXNO(ChartSeries chartSeries) {
        zzlR zzlR2 = new zzlR();
        zzlR2.setOutline(new zzYlj());
        zzXPz zzXPz2 = new zzXPz();
        zzXPz2.zzIw(1);
        zzlR2.getOutline().setFill(new zzWYL(zzXPz2));
        zzlR2.getOutline().zzYgO(19050.0);
        chartSeries.zzXKx().zzXKK().zzZvM(5, zzlR2);
    }

    private static void zzYzG(ChartSeries chartSeries) {
        zzlR zzlR2 = new zzlR();
        zzlR2.setOutline(new zzYlj());
        zzlR2.getOutline().setFill(new zzYvz());
        zzlR2.getOutline().setEndCap(0);
        zzlR2.getOutline().zzYgO(19050.0);
        chartSeries.zzXKx().zzXKK().zzZvM(5, zzlR2);
    }

    private static void zzWuo(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzI4());
        chartMarker.zzYWI().zzZvM(0, n);
        chartSeries.zzXKx().zzXKK().zzZvM(4, chartMarker);
    }

    private static zzY3r zzYnz(double[] dArray) {
        int n = 0;
        zzY3r zzY3r2 = new zzY3r(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzY3r2.zzYzG(new zzYPq(n, d, "General"));
            }
            ++n;
        }
        zzY3r2.zzVG(dArray.length);
        zzY3r2.zzWdp();
        return zzY3r2;
    }

    private static zzY3r zzWuo(zzur[] zzurArray) {
        int n = 0;
        zzY3r zzY3r2 = new zzY3r(2, false);
        zzur[] zzurArray2 = zzurArray;
        int n2 = zzurArray.length;
        for (int i = 0; i < n2; ++i) {
            zzur zzur2 = zzurArray2[i];
            zzY3r2.zzYzG(new zzYPq(n++, zzur2.zzYFj(), "m/d/yyyy"));
        }
        zzY3r2.zzVG(zzurArray.length);
        zzY3r2.zzWdp();
        return zzY3r2;
    }

    private static zzY3r zzXPe(String[] stringArray) {
        int n = 0;
        zzY3r zzY3r2 = new zzY3r(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzY3r2.zzYzG(new zzh9(n++, string));
        }
        zzY3r2.zzVG(stringArray.length);
        zzY3r2.zzWdp();
        return zzY3r2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWbG.zzWQJ().size();
    }
}

