/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.zzVOB;
import com.aspose.words.zzVQ4;
import com.aspose.words.zzXLk;
import com.aspose.words.zzXNV;
import com.aspose.words.zzXhQ;
import com.aspose.words.zzYFS;
import com.aspose.words.zzZJV;
import com.aspose.words.zzZMQ;
import com.aspose.words.zzd9;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzXLk,
Iterable<T> {
    private Node zzrw;
    private Node zzWlT;
    private Node zzXnM;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzka() {
        return this.zzY1s() != null;
    }

    final boolean zzZ9U() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzVQH() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzVQ4) {
                return true;
            }
            CompositeNode compositeNode = zzZ0T.zzWuo((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzVQH()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzrw;
    }

    public Node getLastChild() {
        return this.zzWlT;
    }

    final Node zzY1s() {
        return zzYFS.zzW9K(this.getFirstChild(), false);
    }

    final Node zzW7V() {
        return zzYFS.zzZQl(this.getLastChild(), false);
    }

    final CompositeNode zzyq() {
        return (CompositeNode)zzYFS.zzW9K(this.getFirstChild(), true);
    }

    final CompositeNode zzZoS() {
        return (CompositeNode)zzYFS.zzZQl(this.getLastChild(), true);
    }

    final Node zzXev() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYFS.zzVRC((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzXel() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYFS.zzVRC((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzWuo(boolean bl, zzZJV zzZJV2) {
        CompositeNode compositeNode = (CompositeNode)super.zzWuo(bl, zzZJV2);
        ((CompositeNode)super.zzWuo(bl, zzZJV2)).zzWlT = null;
        compositeNode.zzrw = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWBx(node.zzWuo(true, zzZJV2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYzK(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzYzK(StringBuilder stringBuilder) {
        this.zzXPe(stringBuilder);
        zzZ0T.zzXou(stringBuilder, this.zzWko());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzXou(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYFS.zzW57(nodeType);
            Node node2 = node = bl ? this.zzY1s() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzXtg() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZMQ.zzWg7(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZMQ.zzYnz(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXNV(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzWuo(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzWuo(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzWuo(oldChild, this, null, 1);
        if (documentBase.zzZBf() && zzXhQ.zzY7i(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzWuo(nodeChangingArgs);
        }
        Node node = this.zzWP(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzXou(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzVOB.zzW6E(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWBx(Node node) {
        node.getParentNode();
        if (this.zzWlT == null) {
            node.zzmR(null);
            node.zzX7B(null);
            this.zzrw = node;
        } else {
            node.zzmR(this.zzWlT);
            node.zzX7B(null);
            this.zzWlT.zzX7B(node);
        }
        this.zzWlT = node;
        node.zzWy2(this);
        return node;
    }

    final void zzWuo(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzXou(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzXou(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYFS.zzVRC(node3.getNodeType())) continue;
            if (zzYFS.zzY0J(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzWko().length();
    }

    String zzWko() {
        return "";
    }

    final String zzaA() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXPe(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzXPe(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzYzK(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzWuo(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzXou(visitor));
    }

    abstract int zzWuo(DocumentVisitor var1) throws Exception;

    abstract int zzXou(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzZQl(Node var1);

    final Node zzWuo(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZNW(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzZQl(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzd9(documentBase);
            try {
                compositeNode.removeChild(node);
            }
            finally {
                ((zzd9)object).dispose();
            }
        }
        if ((object = documentBase.zzWuo(node, null, this, 0)) != null) {
            documentBase.zzWuo((NodeChangingArgs)object);
        }
        if (this.zzWlT == null) {
            node.zzmR(null);
            node.zzX7B(null);
            this.zzrw = node;
            this.zzWlT = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzXou(node, node2);
            } else {
                this.zzWg7(node, this.zzrw);
            }
        } else if (node2 != null) {
            this.zzWg7(node, node2);
        } else {
            this.zzXou(node, this.zzWlT);
        }
        node.zzWy2(this);
        if (object != null) {
            documentBase.zzXou((NodeChangingArgs)object);
        }
        if (documentBase.zzZBf()) {
            zzXhQ.zzWuo(node, compositeNode, node3);
        }
        return node;
    }

    private void zzXou(Node node, Node node2) {
        Node node3 = node2.zzXE1();
        node.zzmR(node2);
        node.zzX7B(node3);
        node2.zzX7B(node);
        if (node3 == null) {
            this.zzWlT = node;
            return;
        }
        node3.zzmR(node);
    }

    private void zzWg7(Node node, Node node2) {
        Node node3 = node2.zzZ52();
        node.zzmR(node3);
        node.zzX7B(node2);
        node2.zzmR(node);
        if (node3 == null) {
            this.zzrw = node;
            return;
        }
        node3.zzX7B(node);
    }

    private Node zzWP(Node node) {
        if (node == this.zzrw) {
            if (this.zzrw == this.zzWlT) {
                this.zzrw = null;
                this.zzWlT = null;
            } else {
                this.zzrw = node.zzXE1();
                this.zzrw.zzmR(null);
            }
        } else {
            Node node2 = node.zzZ52();
            Node node3 = node.zzXE1();
            node2.zzX7B(node3);
            if (node3 == null) {
                this.zzWlT = node2;
            } else {
                node3.zzmR(node2);
            }
        }
        node.zzX7B(null);
        node.zzmR(null);
        node.zzWy2(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzXnM = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzXnM;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

