/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWuq;
import com.aspose.words.internal.zzXha;
import com.aspose.words.internal.zzXjN;
import com.aspose.words.internal.zzY7O;
import com.aspose.words.internal.zzYh4;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.internal.zzZGt;
import com.aspose.words.zzWta;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzZU0;
    private zzWta zzWYt;

    Watermark(Document doc, zzWta watermarkProvider) {
        this.zzZU0 = doc;
        this.zzWYt = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzXNX(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzWuo(text, textWatermarkOptions, this.zzZU0);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZ0T.zzXou((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzZU0, 75);
        shape.getImageData().setImage(image);
        this.zzWuo(shape, options, this.zzZU0);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZ0T.zzXou((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzZU0, 75);
        shape.getImageData().setImage(imagePath);
        this.zzWuo(shape, options, this.zzZU0);
    }

    public final int getType() {
        Shape shape = this.zzWYt.get();
        if (shape == null) {
            return 2;
        }
        shape.zzFQ();
        if (shape.zzXHg()) {
            return 0;
        }
        if (shape.zzdg()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzWYt.add(shape);
    }

    public final void remove() {
        this.zzWYt.remove();
    }

    private static void zzXNX(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzY7O.zzZbD(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZ0T.zzWuo(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzWuo(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzXou(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzY0J(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzXou(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzVPQ() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzXv9()) / d2) > (double)(f = pageSetup.zzj9())) {
            d = (double)f / d3;
        }
        shape.zzX8I(zzZGt.zzWg7(d2 * d, 2, zzXha.zzVSz));
        shape.zzZ48(zzZGt.zzWg7(d3 * d, 2, zzXha.zzVSz));
    }

    private Shape zzWuo(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzWuo(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzY0J(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzWuo(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZH5() ? 1.0f : textWatermarkOptions.getFontSize();
        zzXjN zzXjN2 = document.zzKo().zzWg7(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzXjN2.zzXhS(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZH5()) {
            l = Watermark.zzWuo(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzX8I(zzZGt.zzWg7(Float.intBitsToFloat(n), 2, zzXha.zzVSz));
        shape.zzZ48(zzZGt.zzWg7(zzYh4.zzY3y(l), 2, zzXha.zzVSz));
    }

    private static long zzWuo(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzXv9();
        float f2 = pageSetup.zzj9();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYh4.zzY3y(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYh4.zzYte(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYh4.zzY3y(l) >= Float.intBitsToFloat(n)) {
            return zzYh4.zzYte(f2 / f3, f2);
        }
        float f6 = f;
        return zzYh4.zzYte(f6, f6 * f3);
    }

    private static void zzY0J(Shape shape, String string) {
        shape.setName(zzWuq.zzXou("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

