/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zz1K;
import com.aspose.words.internal.zz8I;
import com.aspose.words.internal.zz99;
import com.aspose.words.internal.zzWKn;
import com.aspose.words.internal.zzXD7;
import com.aspose.words.internal.zzXuh;
import com.aspose.words.internal.zzYEm;
import com.aspose.words.internal.zzZcc;
import com.aspose.words.internal.zzZvP;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzVRG
extends CertPathBuilderSpi {
    private final zzZcc zzXct;
    private zzXuh zzWL1;

    zzVRG(zzZcc zzZcc2) {
        this.zzXct = zzZcc2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzXD7 pkixParams;
        if (params instanceof zzXD7) {
            pkixParams = (zzXD7)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzXD7.zzWuo((PKIXBuilderParameters)params).zzu2();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzXD7.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zz1K zz1K2 = pkixParams.zzWGy().zzXDV();
        try {
            collection = zz99.zzWuo(zz1K2, pkixParams.zzWGy().zzYLk());
            collection.addAll(zz99.zzWuo(zz1K2, pkixParams.zzWGy().zzY4w()));
        }
        catch (zzXuh zzXuh2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzXuh2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzWuo(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzWL1 != null) {
            throw new CertPathBuilderException(this.zzWL1.getMessage(), this.zzWL1.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzWuo(X509Certificate x509Certificate, zzXD7 zzXD72, List list) throws CertPathBuilderException {
        zzYEm zzYEm2;
        zz8I zz8I2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzXD72.zzXVw().contains(x509Certificate)) {
            return null;
        }
        if (zzXD72.zzWDN() != -1 && list.size() - 1 > zzXD72.zzWDN()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zz8I2 = new zz8I(this.zzXct);
            zzYEm2 = new zzYEm(this.zzXct);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zz99.zzWuo(x509Certificate, zzXD72.zzWGy().zzXnY(), zzXD72.zzWGy().zzWlA()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zz8I2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzXuh("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzYEm2.engineValidate(certPath, zzXD72);
                }
                catch (Exception exception) {
                    throw new zzXuh("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzWKn> arrayList = new ArrayList<zzWKn>();
            arrayList.addAll(zzXD72.zzWGy().zzYLk());
            try {
                arrayList.addAll(zz99.zzWuo(x509Certificate.getExtensionValue(zzZvP.zzXjR.getId()), zzXD72.zzWGy().zzX8G()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzXuh("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zz99.zzWuo(x509Certificate, zzXD72.zzWGy().zzY4w(), arrayList));
            }
            catch (zzXuh zzXuh2) {
                throw new zzXuh("Cannot find issuer certificate for certificate in certification path.", zzXuh2);
            }
            if (hashSet.isEmpty()) {
                throw new zzXuh("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzWuo(x509Certificate2, zzXD72, list);
            }
        }
        catch (zzXuh zzXuh3) {
            this.zzWL1 = zzXuh3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

