/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWuq;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzX6x = new ArrayList();
    private final Map<String, DataColumn> zzZnN = new HashMap<String, DataColumn>();
    private DataTable zzXCX;

    DataColumnCollection(DataTable table) {
        this.zzXCX = table;
    }

    public void add(DataColumn column) {
        if (zzWuq.zzWSg(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzZNB(column.getColumnName());
        if (this.zzZnN.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzYnz(this.zzXCX);
        column.setOrdinal(this.zzX6x.size());
        this.zzX6x.add(column);
        this.zzZnN.put(string, column);
        this.zzXCX.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzXCX);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzXCX);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzWuq.zzWSg(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzZNB(columnName);
        DataColumn dataColumn = this.zzZnN.get(string);
        if (dataColumn != null) {
            int n = this.zzX6x.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzX6x.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzX6x.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzX6x.remove(n);
            this.zzZnN.remove(DataColumnCollection.zzZNB(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzXCX.getRows()) {
                dataRow.remove(n);
            }
            this.zzXCX.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzX6x.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzX6x.iterator();
    }

    public void clear() {
        this.zzZnN.clear();
        this.zzX6x.clear();
    }

    final DataColumn[] zzZRN() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzX6x);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzWuo(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzX6x.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzX6x.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzZNB(string);
            String string3 = DataColumnCollection.zzZNB(dataColumn.getColumnName());
            this.zzZnN.remove(string3);
            this.zzZnN.put(string2, dataColumn);
            return;
        }
    }

    private static String zzZNB(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

