/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.internal.zzZhn;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVZb;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzVZb zzK6;

    BorderCollection(zzVZb parent) {
        this.zzK6 = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzZbv.zzY0F(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzXqN().equals(brColl.zzXqN()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzK6.getPossibleBorderKeys().zzZp8(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzK6.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzK6, borderKey);
            this.zzK6.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzK6.getPossibleBorderKeys().zzXh5().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzK6.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzK6.getPossibleBorderKeys().zzXh5().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW4b(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzK6.getPossibleBorderKeys().zzXh5().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW4b(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzXqN().zzZhm();
    }

    public final void setColor(Color value) throws Exception {
        this.zzVOt(zzZhn.zzZqK(value));
    }

    private zzZhn zzXqN() throws Exception {
        return this.get(0).zzXqN();
    }

    private void zzVOt(zzZhn zzZhn2) throws Exception {
        Iterator iterator = this.zzK6.getPossibleBorderKeys().zzXh5().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW4b(n)) continue;
            this.getByBorderType(n).zzVOt(zzZhn2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzK6.getPossibleBorderKeys().zzXh5().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW4b(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzK6.getPossibleBorderKeys().zzXh5().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW4b(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzZp8(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzW4b(int n) {
        return n != 6 && n != 7;
    }

    static final class zzZp8
    implements Iterator<Border> {
        private BorderCollection zzYm8;
        private int zzWeI;

        zzZp8(BorderCollection borderCollection) {
            this.zzYm8 = borderCollection;
            this.zzWeI = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzWeI >= this.zzYm8.getCount() - 1) {
                return false;
            }
            ++this.zzWeI;
            return true;
        }

        private Border zzWCJ() {
            try {
                return this.zzYm8.get(this.zzWeI);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzWCJ();
        }
    }
}

