/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.zzEm;
import com.aspose.words.zzWaw;
import com.aspose.words.zzWkN;
import com.aspose.words.zzWsF;
import com.aspose.words.zzXw6;
import com.aspose.words.zzYdK;
import com.aspose.words.zzZ9y;
import com.aspose.words.zzZEt;
import com.aspose.words.zzZxO;
import com.aspose.words.zzxN;

public class Cell
extends CompositeNode<Node>
implements zzWaw,
zzYdK {
    private zzZxO zzX0e;
    private CellFormat zzW6j;
    private ParagraphCollection zzW1N;
    private TableCollection zzYYH;

    public Cell(DocumentBase doc) {
        this(doc, new zzZxO());
    }

    Cell(DocumentBase doc, zzZxO cellPr) {
        super(doc);
        this.zzX0e = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzZoJ() {
        return (Cell)this.zzX0d();
    }

    public Row getParentRow() {
        return (Row)this.zzZGL();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zz7i() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzZqK(this, true);
        }
        return -1;
    }

    final int zzVSv() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzVSv();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzW6j == null) {
            this.zzW6j = new CellFormat(this);
        }
        return this.zzW6j;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzW1N == null) {
            this.zzW1N = new ParagraphCollection(this);
        }
        return this.zzW1N;
    }

    public TableCollection getTables() {
        if (this.zzYYH == null) {
            this.zzYYH = new TableCollection(this);
        }
        return this.zzYYH;
    }

    final zzZxO zzVZP() {
        return this.zzX0e;
    }

    final void zzZp8(zzZxO zzZxO2) {
        this.zzX0e = zzZxO2;
    }

    @Override
    final Node zzZp8(boolean bl, zzZ9y zzZ9y2) {
        zzZxO zzZxO2;
        Cell cell = (Cell)super.zzZp8(bl, zzZ9y2);
        zzZxO zzZxO3 = this.zzX0e;
        cell.zzX0e = zzZxO2 = (zzZxO)zzZxO3.zzYcB();
        cell.zzW6j = null;
        cell.zzW1N = null;
        cell.zzYYH = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZp8(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzZqK(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzXw6.zzrn(this);
    }

    @Override
    final boolean zzZhC(Node node) {
        return zzxN.zzYuO(node);
    }

    final int zzZlA() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzX0d();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzX0e.zzYkE(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzX0e.zzYkE(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzEm zzEm2 = zzZbv.zzZp8(object, zzEm.class);
        if (zzEm2 != null && zzEm2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzX2v(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzZxO.zzYAb(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzX0e.zzWjD(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzX0e.clear();
    }

    private Object zzX2v(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzZbv.zzZp8((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzZp8(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWkN getInsertRevision() {
        Cell cell = this;
        return cell.zzX0e.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzWkN value) {
        zzWaw zzWaw2 = this;
        zzWkN zzWkN2 = value;
        zzWaw2 = zzWaw2.zzX0e;
        ((zzWsF)((Object)zzWaw2)).zzWjD(14, zzWkN2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWkN getDeleteRevision() {
        Cell cell = this;
        return cell.zzX0e.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzWkN value) {
        zzWaw zzWaw2 = this;
        zzWkN zzWkN2 = value;
        zzWaw2 = zzWaw2.zzX0e;
        ((zzWsF)((Object)zzWaw2)).zzWjD(12, zzWkN2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZEt getMoveFromRevision() {
        Cell cell = this;
        return cell.zzX0e.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzZEt value) {
        zzWaw zzWaw2 = this;
        zzZEt zzZEt2 = value;
        zzWaw2 = zzWaw2.zzX0e;
        ((zzWsF)((Object)zzWaw2)).zzWjD(13, zzZEt2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZEt getMoveToRevision() {
        Cell cell = this;
        return cell.zzX0e.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzZEt value) {
        zzWaw zzWaw2 = this;
        zzZEt zzZEt2 = value;
        zzWaw2 = zzWaw2.zzX0e;
        ((zzWsF)((Object)zzWaw2)).zzWjD(15, zzZEt2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzX0e.remove(13);
        cell = this;
        cell.zzX0e.remove(15);
    }

    final zzZxO zzWAh(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzZxO zzZxO2 = new zzZxO();
        this.zzZp8(3120, zzZxO2);
        this.zzZp8(3140, zzZxO2);
        this.zzZp8(3110, zzZxO2);
        this.zzZp8(3130, zzZxO2);
        this.zzZp8(3090, zzZxO2);
        this.zzZp8(3100, zzZxO2);
        this.zzZp8(3070, zzZxO2);
        this.zzZp8(3080, zzZxO2);
        if (bl && (tableStyle = zzZbv.zzZp8((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzZqK(this, zzZxO2);
        }
        this.zzX0e.zzZqK((zzWsF)zzZxO2);
        return zzZxO2;
    }

    private void zzZp8(int n, zzZxO zzZxO2) {
        zzZxO2.zzWjD(n, this.fetchInheritedCellAttr(n));
    }
}

