/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzZRE;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.zz14;
import com.aspose.words.zzSe;
import com.aspose.words.zzWsJ;
import com.aspose.words.zzXVN;
import com.aspose.words.zzXYj;
import com.aspose.words.zzXwh;
import com.aspose.words.zzXy2;
import com.aspose.words.zzYuN;
import com.aspose.words.zzYv2;
import com.aspose.words.zzZy3;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzXy2 zzq3;

    ChartSeriesCollection(zzXy2 dmlChart) {
        this.zzq3 = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzq3.zzXRq().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzq3.zzXRq().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzq3.zzXRq().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzq3.zzXRq().clear();
        this.zzYpP(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZp8(seriesName, values);
        chartSeries.zzk3().zzWKk(ChartSeriesCollection.zzY0F(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZp8(seriesName, yValues);
        chartSeries.zzk3().zzWKk(ChartSeriesCollection.zzWKk(xValues));
        return chartSeries;
    }

    private ChartSeries zzZp8(String string, zzZRE[] zzZREArray, double[] dArray) {
        if (zzZREArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzZREArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzZREArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZp8(string, dArray);
        chartSeries.zzk3().zzWKk(ChartSeriesCollection.zzZp8(zzZREArray));
        if (!this.zzq3.zzT7()) {
            this.zzYpP(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzZp8(seriesName, zzZRE.zzZp8(dates), values);
    }

    private void zzYpP(boolean bl) {
        zzSe zzSe2 = zzZbv.zzZp8((Object)this.zzq3, zzSe.class);
        if (zzSe2 != null && zzSe2.zzWj6().zzxo()) {
            zzSe2.zzWj6().zzY46().zzXvz(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzq3.zzXMR() != 15) {
            this.zzq3.zzVR4(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzZp8(seriesName, yValues);
        chartSeries.zzZs7().zzWv0().zzXvz(3, this.zzq3.zzyo());
        chartSeries.zzk3().zzWKk(ChartSeriesCollection.zzWKk(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzW4K().zzWKk(ChartSeriesCollection.zzWKk(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzZp8(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzq3);
        chartSeries.setName(string);
        this.zzZhC(chartSeries);
        chartSeries.zzYpX(this.zzq3.zzX4F().zzVOS() + 1);
        chartSeries.zzZt1(this.zzq3.zzX4F().zzWD6() + 1);
        chartSeries.zz5R().zzWKk(ChartSeriesCollection.zzWKk(dArray));
        chartSeries.zzgI().zzWKk(chartSeries.zz5R().zznY());
        this.zzq3.zzWkv().zzZps();
        this.zzq3.zzWM1(chartSeries);
        return chartSeries;
    }

    private void zzZhC(ChartSeries chartSeries) {
        chartSeries.zzZs7().zzWv0().zzXvz(5, new zzXVN());
        switch (this.zzq3.zzXMR()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZp8(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzZp8(chartSeries, 5);
                ChartSeriesCollection.zzGU(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzZp8(chartSeries, 1);
                ChartSeriesCollection.zzGU(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzZo9(chartSeries);
            }
        }
    }

    private static void zzZo9(ChartSeries chartSeries) {
        zzXVN zzXVN2 = new zzXVN();
        zzXVN2.setOutline(new zzWsJ());
        zzYv2 zzYv22 = new zzYv2();
        zzYv22.zzYUI(1);
        zzXVN2.getOutline().setFill(new zzZy3(zzYv22));
        zzXVN2.getOutline().zzZg7(19050.0);
        chartSeries.zzZs7().zzWv0().zzXvz(5, zzXVN2);
    }

    private static void zzGU(ChartSeries chartSeries) {
        zzXVN zzXVN2 = new zzXVN();
        zzXVN2.setOutline(new zzWsJ());
        zzXVN2.getOutline().setFill(new zzYuN());
        zzXVN2.getOutline().setEndCap(0);
        zzXVN2.getOutline().zzZg7(19050.0);
        chartSeries.zzZs7().zzWv0().zzXvz(5, zzXVN2);
    }

    private static void zzZp8(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzYb7());
        chartMarker.zzZy9().zzXvz(0, n);
        chartSeries.zzZs7().zzWv0().zzXvz(4, chartMarker);
    }

    private static zzXwh zzWKk(double[] dArray) {
        int n = 0;
        zzXwh zzXwh2 = new zzXwh(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzXwh2.zzGU(new zz14(n, d, "General"));
            }
            ++n;
        }
        zzXwh2.zzY9n(dArray.length);
        zzXwh2.zzXXT();
        return zzXwh2;
    }

    private static zzXwh zzZp8(zzZRE[] zzZREArray) {
        int n = 0;
        zzXwh zzXwh2 = new zzXwh(2, false);
        zzZRE[] zzZREArray2 = zzZREArray;
        int n2 = zzZREArray.length;
        for (int i = 0; i < n2; ++i) {
            zzZRE zzZRE2 = zzZREArray2[i];
            zzXwh2.zzGU(new zz14(n++, zzZRE2.zzYGZ(), "m/d/yyyy"));
        }
        zzXwh2.zzY9n(zzZREArray.length);
        zzXwh2.zzXXT();
        return zzXwh2;
    }

    private static zzXwh zzY0F(String[] stringArray) {
        int n = 0;
        zzXwh zzXwh2 = new zzXwh(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzXwh2.zzGU(new zzXYj(n++, string));
        }
        zzXwh2.zzY9n(stringArray.length);
        zzXwh2.zzXXT();
        return zzXwh2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzq3.zzXRq().size();
    }
}

