/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.zzGS;
import com.aspose.words.zzW9O;
import com.aspose.words.zzWCl;
import com.aspose.words.zzXUj;
import com.aspose.words.zzXWG;
import com.aspose.words.zzZ1l;
import com.aspose.words.zzZ9y;
import com.aspose.words.zzxN;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzW9O,
Iterable<T> {
    private Node zzXvv;
    private Node zzWJX;
    private Node zzYzn;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzWRT() {
        return this.zz0x() != null;
    }

    final boolean zzXtw() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzZR7() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzGS) {
                return true;
            }
            CompositeNode compositeNode = zzZbv.zzZp8((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzZR7()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzXvv;
    }

    public Node getLastChild() {
        return this.zzWJX;
    }

    final Node zz0x() {
        return zzxN.zzVR4(this.getFirstChild(), false);
    }

    final Node zzWhJ() {
        return zzxN.zzZhC(this.getLastChild(), false);
    }

    final CompositeNode zzWce() {
        return (CompositeNode)zzxN.zzVR4(this.getFirstChild(), true);
    }

    final CompositeNode zzWtC() {
        return (CompositeNode)zzxN.zzZhC(this.getLastChild(), true);
    }

    final Node zzUK() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzxN.zzVZq((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzXRB() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzxN.zzVZq((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZp8(boolean bl, zzZ9y zzZ9y2) {
        CompositeNode compositeNode = (CompositeNode)super.zzZp8(bl, zzZ9y2);
        ((CompositeNode)super.zzZp8(bl, zzZ9y2)).zzWJX = null;
        compositeNode.zzXvv = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzzl(node.zzZp8(true, zzZ9y2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYzS(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzYzS(StringBuilder stringBuilder) {
        this.zzY0F(stringBuilder);
        zzZbv.zzZqK(stringBuilder, this.zzX94());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzZqK(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzxN.zzXZ(nodeType);
            Node node2 = node = bl ? this.zz0x() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzW7Z() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZ1l.zzWxF(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZ1l.zzWKk(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXWG(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzZp8(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzZp8(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzZp8(oldChild, this, null, 1);
        if (documentBase.zzYxM() && zzxN.zzWhE(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzZp8(nodeChangingArgs);
        }
        Node node = this.zzWEV(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzZqK(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzWCl.zzzz(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzzl(Node node) {
        node.getParentNode();
        if (this.zzWJX == null) {
            node.zzW0d(null);
            node.zzW(null);
            this.zzXvv = node;
        } else {
            node.zzW0d(this.zzWJX);
            node.zzW(null);
            this.zzWJX.zzW(node);
        }
        this.zzWJX = node;
        node.zzWLP(this);
        return node;
    }

    final void zzZp8(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzZqK(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzZqK(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzxN.zzVZq(node3.getNodeType())) continue;
            if (zzxN.zzY98(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzX94().length();
    }

    String zzX94() {
        return "";
    }

    final String zzW8B() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzY0F(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzY0F(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzYzS(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzZp8(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzZqK(visitor));
    }

    abstract int zzZp8(DocumentVisitor var1) throws Exception;

    abstract int zzZqK(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzZhC(Node var1);

    final Node zzZp8(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZoF(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzZhC(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzXUj(documentBase);
            try {
                compositeNode.removeChild(node);
            }
            finally {
                ((zzXUj)object).dispose();
            }
        }
        if ((object = documentBase.zzZp8(node, null, this, 0)) != null) {
            documentBase.zzZp8((NodeChangingArgs)object);
        }
        if (this.zzWJX == null) {
            node.zzW0d(null);
            node.zzW(null);
            this.zzXvv = node;
            this.zzWJX = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzZqK(node, node2);
            } else {
                this.zzWxF(node, this.zzXvv);
            }
        } else if (node2 != null) {
            this.zzWxF(node, node2);
        } else {
            this.zzZqK(node, this.zzWJX);
        }
        node.zzWLP(this);
        if (object != null) {
            documentBase.zzZqK((NodeChangingArgs)object);
        }
        if (documentBase.zzYxM()) {
            zzxN.zzZp8(node, compositeNode, node3);
        }
        return node;
    }

    private void zzZqK(Node node, Node node2) {
        Node node3 = node2.zzSm();
        node.zzW0d(node2);
        node.zzW(node3);
        node2.zzW(node);
        if (node3 == null) {
            this.zzWJX = node;
            return;
        }
        node3.zzW0d(node);
    }

    private void zzWxF(Node node, Node node2) {
        Node node3 = node2.zzW44();
        node.zzW0d(node3);
        node.zzW(node2);
        node2.zzW0d(node);
        if (node3 == null) {
            this.zzXvv = node;
            return;
        }
        node3.zzW(node);
    }

    private Node zzWEV(Node node) {
        if (node == this.zzXvv) {
            if (this.zzXvv == this.zzWJX) {
                this.zzXvv = null;
                this.zzWJX = null;
            } else {
                this.zzXvv = node.zzSm();
                this.zzXvv.zzW0d(null);
            }
        } else {
            Node node2 = node.zzW44();
            Node node3 = node.zzSm();
            node2.zzW(node3);
            if (node3 == null) {
                this.zzWJX = node2;
            } else {
                node3.zzW0d(node2);
            }
        }
        node.zzW(null);
        node.zzW0d(null);
        node.zzWLP(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzYzn = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYzn;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

