/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz6T;
import com.aspose.words.internal.zzWXY;
import com.aspose.words.internal.zzX3d;
import com.aspose.words.internal.zzXG5;
import com.aspose.words.internal.zzXNq;
import com.aspose.words.internal.zzXSJ;
import com.aspose.words.internal.zzXUN;
import com.aspose.words.internal.zzXXs;
import com.aspose.words.internal.zzXtP;
import com.aspose.words.internal.zzYpy;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.internal.zzZuH;
import com.aspose.words.zzWM7;
import com.aspose.words.zzWNc;
import com.aspose.words.zzWqN;
import com.aspose.words.zzX8G;
import com.aspose.words.zzXDx;
import com.aspose.words.zzXFn;
import com.aspose.words.zzXoP;
import com.aspose.words.zzYAg;
import com.aspose.words.zzYHx;
import com.aspose.words.zzYp5;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzZp8(zzXtP zzXtP2, zzXtP zzXtP3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZbv.zzZqK((Object)zzXtP2, "srcStream");
        zzZbv.zzZqK((Object)zzXtP3, "dstStream");
        zzZbv.zzZqK((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzZqK(zzXtP2, zzXtP3, certificateHolder, signOptions);
        zzXtP3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzZp8(zzXtP.zzZqK(srcStream), (zzXtP)zzXtP.zzWxF(dstStream), certHolder, signOptions);
    }

    private static void zzZqK(zzXtP zzXtP2, zzXtP zzXtP3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzWxF(digitalSignature);
        }
        if (zzXDx.zzZWK(zzXtP2)) {
            DigitalSignatureUtil.zzZp8(zzXtP2, zzXtP3, digitalSignature, true);
            return;
        }
        zzXDx zzXDx2 = new zzXDx();
        zzXtP zzXtP4 = zzXtP2;
        zzXDx zzXDx3 = zzXDx2;
        FileFormatInfo fileFormatInfo = zzXDx2.zzZqK(zzXtP4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYpy zzYpy2 = new zzYpy(zzXtP2);
                int n = fileFormatInfo.zzYox() == 1 ? 1 : 2;
                zzXFn.zzZp8(zzYpy2, digitalSignature, n);
                zzXtP3.zzY39(0L);
                zzYpy2.zzYzS(zzXtP3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzZp8(fileFormatInfo.zzCr(), zzXtP3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzZp8(zzXtP2, zzXtP3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzZp8(zzXtP2, zzXtP3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZbv.zzZp8(srcFileName, "srcFileName");
        zzZbv.zzZp8(dstFileName, "dstFileName");
        try (zzX3d zzX3d2 = zzZbv.zzZqK(srcFileName, 3, 1);){
            try (zzX3d zzX3d3 = zzZbv.zzZqK(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzZp8((zzXtP)zzX3d2, (zzXtP)zzX3d3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzXSJ zzXSJ2 = zzXtP.zzWxF(dstStream);
        zzXtP zzXtP2 = zzXtP.zzZqK(srcStream);
        DigitalSignatureUtil.zzZp8(zzXtP2, (zzXtP)zzXSJ2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzX3d zzX3d2 = zzZbv.zzZqK(srcFileName, 3, 1);){
            try (zzX3d zzX3d3 = zzZbv.zzZqK(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWKk(zzX3d2, zzX3d3);
            }
            return;
        }
    }

    private static void zzWKk(zzXtP zzXtP2, zzXtP zzXtP3) throws Exception {
        zzXDx zzXDx2 = new zzXDx();
        zzXtP zzXtP4 = zzXtP2;
        zzXDx zzXDx3 = zzXDx2;
        FileFormatInfo fileFormatInfo = zzXDx2.zzZqK(zzXtP4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYpy zzYpy2 = new zzYpy(zzXtP2);
                zzYpy2.zz5q().zzW53("_xmlsignatures");
                zzYpy2.zz5q().zzW53("_signatures");
                zzXtP3.zzzz(0L);
                zzYpy2.zzYzS(zzXtP3);
                zzXtP zzXtP5 = zzXtP3;
                zzXtP5.zzY39(zzXtP5.zzWWK());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzWXY zzWXY2 = new zzWXY(zzXtP2);
                zzXNq zzXNq2 = zzWXY2.zzZp8(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXNq2 != null) {
                    for (zz6T zz6T2 : zzXNq2.zzZ87()) {
                        String string = zzXNq2.zzZp8(zz6T2);
                        zzWXY2.zz9n().remove(string);
                    }
                    zzWXY2.zz9n().remove(zzXNq2.getName());
                    zz6T zz6T3 = zzWXY2.zzZ87().zzZg7("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzWXY2.zzZ87().remove(zz6T3.getId());
                    zzWXY2.zzfL();
                }
                zzXtP3.zzzz(0L);
                zzWXY2.zzYzS(zzXtP3);
                zzXtP zzXtP6 = zzXtP3;
                zzXtP6.zzY39(zzXtP6.zzWWK());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzWKk(zzXtP.zzZqK(srcStream), zzXtP.zzWxF(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzX3d zzX3d2 = zzZbv.zzZqK(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYmh(zzX3d2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYmh(zzXtP zzXtP2) throws Exception {
        if (zzXDx.zzZWK(zzXtP2)) {
            return DigitalSignatureUtil.zzWhT(zzXtP2);
        }
        zzXDx zzXDx2 = new zzXDx();
        zzXtP zzXtP3 = zzXtP2;
        zzXDx zzXDx3 = zzXDx2;
        FileFormatInfo fileFormatInfo = zzXDx2.zzZqK(zzXtP3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzXtP2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYmh(zzXtP.zzZqK(stream));
    }

    static zzXUN zzZp8(zzYpy zzYpy2, String string) throws Exception {
        zzYAg zzYAg2 = new zzYAg(zzYpy2);
        if (zzYAg2.zzXA()) {
            zzXUN zzXUN2 = zzYAg2.zzWYE(string);
            return zzXUN2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzXKQ(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzXG5.zzZqK("Unexpected digest algorithm: {0}.", n));
    }

    static String zzWM2(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzXKQ(n);
    }

    private static void zzZp8(zzXtP zzXtP2, zzXtP zzXtP3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzWXY zzWXY2 = new zzWXY(zzXtP2);
        zzX8G zzX8G2 = bl ? new zzYHx(zzWXY2) : new zzWM7(zzWXY2);
        zzX8G2.zzZqK(digitalSignature);
        zzXtP3.zzY39(0L);
        zzWXY2.zzYzS(zzXtP3);
    }

    private static void zzZp8(zzXtP zzXtP2, zzXtP zzXtP3, DigitalSignature digitalSignature) throws Exception {
        zzYp5 zzYp52 = new zzYp5(zzXtP2);
        zzXoP zzXoP2 = new zzXoP(zzYp52);
        zzXoP2.zzZqK(digitalSignature);
        zzXtP3.zzY39(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzXtP zzXtP4 = zzXtP3;
        zzYp5 zzYp53 = zzYp52;
        zzYp53.zzZp8(zzXtP4, string, null);
    }

    private static void zzZp8(zzYpy zzYpy2, zzXtP zzXtP2, DigitalSignature digitalSignature, String string) throws Exception {
        zzXUN zzXUN2 = DigitalSignatureUtil.zzZp8(zzYpy2, string);
        zzXUN zzXUN3 = new zzXUN();
        DigitalSignatureUtil.zzZp8((zzXtP)zzXUN2, (zzXtP)zzXUN3, digitalSignature, false);
        zzYpy zzYpy3 = zzYAg.zzWxF(zzXUN3, string);
        zzYpy3.zzYzS(zzXtP2);
    }

    private static DigitalSignatureCollection zzWhT(zzXtP zzXtP2) throws Exception {
        zzXtP2.zzzz(0L);
        zzWXY zzWXY2 = new zzWXY(zzXtP2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXNq zzXNq2 = zzWXY2.zzZp8(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXNq2 != null) {
            for (zz6T zz6T2 : zzXNq2.zzZ87()) {
                String string = zzXNq2.zzZp8(zz6T2);
                zzXNq zzXNq3 = zzWXY2.zzWET(string);
                zzXNq zzXNq4 = zzWXY2.zzZp8(zzXNq3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzZuH zzZuH2 = zzXXs.zzVY4(zzXNq4.zzYZY().zzWnM());
                zzWqN.zzZp8(zzXNq3.zzWYE(), zzZuH2, new zzWNc(zzWXY2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

