/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz7e;
import com.aspose.words.internal.zz9p;
import com.aspose.words.internal.zzVTz;
import com.aspose.words.internal.zzWPe;
import com.aspose.words.internal.zzWf0;
import com.aspose.words.internal.zzXFZ;
import com.aspose.words.internal.zzXG5;
import com.aspose.words.internal.zzXH6;
import com.aspose.words.internal.zzXRs;
import com.aspose.words.internal.zzXUN;
import com.aspose.words.internal.zzXUY;
import com.aspose.words.internal.zzXbg;
import com.aspose.words.internal.zzXtP;
import com.aspose.words.internal.zzYOm;
import com.aspose.words.internal.zzYPO;
import com.aspose.words.internal.zzYQw;
import com.aspose.words.internal.zzYVG;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.zz3x;
import com.aspose.words.zz6U;
import com.aspose.words.zzSH;
import com.aspose.words.zzVVj;
import com.aspose.words.zzVYr;
import com.aspose.words.zzW2r;
import com.aspose.words.zzWVd;
import com.aspose.words.zzWXR;
import com.aspose.words.zzWZ5;
import com.aspose.words.zzWaG;
import com.aspose.words.zzWaw;
import com.aspose.words.zzWfs;
import com.aspose.words.zzWsF;
import com.aspose.words.zzWu5;
import com.aspose.words.zzXAk;
import com.aspose.words.zzXLK;
import com.aspose.words.zzXMR;
import com.aspose.words.zzXMp;
import com.aspose.words.zzXUj;
import com.aspose.words.zzXmz;
import com.aspose.words.zzXnr;
import com.aspose.words.zzXox;
import com.aspose.words.zzXpt;
import com.aspose.words.zzXw6;
import com.aspose.words.zzY4e;
import com.aspose.words.zzY7o;
import com.aspose.words.zzYB5;
import com.aspose.words.zzYIq;
import com.aspose.words.zzYOo;
import com.aspose.words.zzYVT;
import com.aspose.words.zzYdK;
import com.aspose.words.zzYda;
import com.aspose.words.zzYhJ;
import com.aspose.words.zzYiG;
import com.aspose.words.zzYmP;
import com.aspose.words.zzYtM;
import com.aspose.words.zzYwg;
import com.aspose.words.zzZiA;
import com.aspose.words.zzZic;
import com.aspose.words.zzZme;
import com.aspose.words.zzZxO;
import com.aspose.words.zzaZ;
import com.aspose.words.zzxN;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzSH,
zzWaw,
zzXMp {
    private Document zzZ1n;
    private Node zzYHq;
    private Node zzYZi;
    private zz3x zzZl9;
    private Font zzYRE;
    private zzXRs<zz3x> zzZvf;
    private zzXRs<zzVVj> zzcD;
    private zzXRs<zzZp8> zzZOF;
    private zzXox zzXx2 = zzXox.zzYNU();
    private zzZxO zzX0e = new zzZxO();
    private RowFormat zzYid;
    private CellFormat zzW6j;
    private zzXRs<zzXMR> zzWM0;
    private int zzWRe = 0;
    private int zzW0e = -1;
    private int zzYHX;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzWjD(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzWjD(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzWjD(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZp8(documentBuilder.getCurrentSection(), zzXw6.zzWEf(headerFooterType), 0, 0);
    }

    private void zzWjD(int n, int n2, int n3, int n4) {
        this.zzZ1n.ensureMinimum();
        Section section = (Section)this.zzZ1n.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzZp8(section, 1, n3, n4);
    }

    private void zzZp8(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzXw6.zzEQ(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZ1n, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZ1n));
            }
        }
        this.zzZp8(story, n2, n3);
    }

    private void zzZp8(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZp8(paragraph2, n3);
    }

    final void zzWxF(Paragraph paragraph, int n) {
        this.zzZp8(paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzQn().zzXK8() ? zz6U.zzZhC(this.zzZ1n, fieldName) : zz6U.zzZo9(this.zzQn(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZp8(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZp8(field, isAfter, false);
    }

    private boolean zzZp8(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzaZ zzaZ2 = field.getFormat().zzYtE();
        Inline inline = zzaZ2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZp8(inline.zz4S(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzWu5.zzZp8(this.zzZ1n, bookmarkName) : zzWu5.zzZqK(this.zzZ1n, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzY63() == 6) {
            this.zzZqK((Paragraph)node.zzZGL(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzxN.zzWJa(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzZqK(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZp8(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzWYQ(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzZp8(cell, characterIndex);
    }

    private void zzZqK(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzY63() == 6) {
            this.zzYmh(node);
        } else {
            Node node2 = node;
            if (zzxN.zzVZq(node2.getNodeType())) {
                Paragraph paragraph = zzxN.zzWJa(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzYmh(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzY63() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzYmh(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzYHX = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzXeX();
            return;
        }
        if (!this.zzZu7()) {
            this.zzXeX();
        }
    }

    private boolean zzZu7() {
        Node node = this.zzQn();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzQn(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZp8(inline.zz4S(), true);
            return true;
        }
        return false;
    }

    private void zzXeX() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZp8(documentBuilder.getCurrentParagraph().zzYpi(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzWYQ(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzWOg() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzQn().zzZoF(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzX0d();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzZp8(paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzY7o(text, false);
    }

    public void writeln(String text) {
        this.zzY7o(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzWGw();
        Paragraph paragraph = this.getCurrentParagraph();
        zzXUj zzXUj2 = new zzXUj(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZ1n, this.zzZmP(), this.zzs0());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzZqK(this.zzQn(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzXUj2.dispose();
        }
        if (this.getDocument().zzYxM()) {
            zzxN.zzWxF((zzYdK)paragraph, this.getDocument().zzY88());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzaQ() {
        zz3x zz3x2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzWGw();
        Node node = this.zzQn();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzZic(false);
        } else {
            run2 = run = (Run)node.zzYwl(21);
        }
        if (run2 == null && zzZbv.zzY0F(node, paragraph.zzVWe())) {
            run = paragraph.zzVWe();
        }
        if (run != null) {
            cloneable = run.zz4S();
            zz3x2 = (zz3x)((zzWsF)cloneable).zzYcB();
        } else {
            cloneable = paragraph.zzYpi();
            zz3x2 = (zz3x)((zzWsF)cloneable).zzYcB();
        }
        zz3x zz3x3 = zz3x2;
        Paragraph paragraph2 = new Paragraph(this.zzZ1n, this.zzZmP(), zz3x3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzXUj zzXUj2 = new zzXUj(this.zzZ1n);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzZqK(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzXUj2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXpt.zzZhC(this);
    }

    public void insertBreak(int breakType) {
        this.zzWJa(breakType, true);
    }

    final void zzWJa(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzZ2J(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzWCY(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zz1A())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzZ2J(bl)) {
                        this.zzWCY(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzZ2J(bl)) {
                        this.zzyr(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzZ2J(bl)) {
                        this.zzyr(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzZ2J(bl)) {
                        this.zzyr(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzZ2J(bl)) {
                        this.zzyr(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzZ2J(bl)) {
                        this.zzyr(4);
                    }
                    return;
                }
                case 8: {
                    this.zzWCY(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzXFZ.zzWaY(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzXG5.zzZqK("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzWGw();
        return zzxN.zzZp8(fieldType, updateField, this.zzs0(), this.zzQn(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzWGw();
        return zzxN.zzZp8(fieldCode, this.zzs0(), this.zzQn(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzWGw();
        return zzxN.zzZp8(fieldCode, fieldValue, this.zzs0(), this.zzQn(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZbv.zzZqK((Object)displayText, "displayText");
        zzZbv.zzZqK((Object)urlOrBookmark, "hrefOrBookmark");
        zzYIq zzYIq2 = this.zzZqK(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzYIq2.zzZqK(documentBuilder.zzVP8(88, true));
        return zzxN.zzZp8(zzYIq2.getStart(), zzYIq2.getSeparator(), zzYIq2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzWMs(70);
        if (zzXFZ.zzWaY(name)) {
            this.startBookmark(name);
        }
        this.zzZjb(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzZi4(70);
        String string = zzXFZ.zzWaY(fieldValue) ? fieldValue : FormField.zzWKl;
        Run run = new Run(this.zzZ1n, string, this.zzs0());
        this.insertNode(run);
        Node node = this.zzVP8(70, true);
        if (zzXFZ.zzWaY(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzZd2(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzZqK((Paragraph)node.zzZGL(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzWMs(71);
        if (zzXFZ.zzWaY(name)) {
            this.startBookmark(name);
        }
        this.zzZjb(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzVP8(71, false);
        if (zzXFZ.zzWaY(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZd2(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzWMs(83);
        if (zzXFZ.zzWaY(name)) {
            this.startBookmark(name);
        }
        this.zzZjb(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzVP8(83, false);
        if (zzXFZ.zzWaY(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZd2(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzZ1n, footnoteType, !zzXFZ.zzWaY(referenceMark), referenceMark, this.zzs0());
        Style style = this.getDocument().getStyles().zzWyk(zzxN.zzWXY(footnoteType));
        footnote.zz4S().set(50, style.zzX85());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZ1n);
        Style style2 = this.getDocument().getStyles().zzWyk(zzxN.zzZAX(footnoteType));
        paragraph.zzZkH().set(1000, style2.zzX85());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZ1n, '\u0002', new zz3x()) : new Run(this.zzZ1n, footnote.getReferenceMark(), new zz3x());
        inline.zz4S().set(50, style.zzX85());
        paragraph.appendChild(inline);
        if (zzXFZ.zzWaY(footnoteText)) {
            Node node = this.zzQn();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYmh(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzXAC(zzXtP zzXtP2) throws Exception {
        return this.zzZp8(zzXtP2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzXAC(zzXtP.zzZqK(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZp8(zzXtP zzXtP2, double d, double d2) throws Exception {
        return this.zzZp8(zzXtP2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZp8(zzXtP.zzZqK(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzXUN zzXUN2 = new zzXUN();){
            zzYOm.zzZp8(image, zzXUN2);
            Shape shape = this.zzZp8(zzXUN2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZbv.zzZp8(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzYPO.zzXvF(fileName);
        try {
            Shape shape = this.zzZp8((zzXtP)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzXtP)object).close();
            }
        }
    }

    private Shape zzZp8(zzXtP zzXtP2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzXtP2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZbv.zzZhC(zzXtP2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZp8(zzXtP.zzZqK(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZp8(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzZp8(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzXbg.zzYmh(object)) {
            object4 = new zzYOm((byte[])object);
            bl2 = true;
            ((zzYQw)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzZ1n.getCompatibilityOptions().getMswVersion() > 12 || this.zzZ1n.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzZ1n, 0);
            object3 = new zzXAk();
            ((zzWZ5)object3).zzZp8(zzZiA.zziS("rect"));
            ((zzXAk)object3).zzZp8(new zzZic());
            ((zzXAk)object3).zzZTB().zzXuV().zzWKk(this.zzZ1n);
            object2 = new zzYVT();
            ((zzWaG)object2).zzZqK(new zzVYr(this.zzZ1n.zzZXh(), ""));
            ((zzWaG)object2).zzZp8(new zzXnr());
            ((zzWXR)object3).zzZp8((zzWaG)object2);
            shape.zzWZW(75);
            shape.zzXvE((zzWXR)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzZ1n, 75);
        }
        if (zzXbg.zzY2D(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzZp8((byte[])object, new zzZme(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzZme(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzXbg.zzXXC((byte[])object2));
                this.zzZp8((zzXAk)shape.zzJ0(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXAk)shape.zzJ0()).zzZTB().zzXuV().zzZwa((byte[])object);
            object3 = zzXbg.zzZbv(object);
            object4 = new zzZme(((zzWPe)object3).getWidthPoints(), ((zzWPe)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzZp8(this.zzs0());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzXbg.zzmt(object)) {
            d5 = DocumentBuilder.zzZp8(shape, object);
        }
        shape.zzZp8(d3, d4, (zzZme)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzZp8(Shape shape, byte[] byArray) throws Exception {
        int n = zzXbg.zzZyd(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzxN.zzWGa(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzxN.zzXNi(n);
        return d;
    }

    private void zzZp8(zzXAk zzXAk2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXAk2.zzZTB().zzXuV().getExtensions();
        try (zzXUN zzXUN2 = new zzXUN(byArray);){
            object = zzxN.zzZp8(zzXUN2, this.zzZ1n);
            ((zzYda)object).zzYuO(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzYda)object).zzZXD();
            byArray2 = ((zzYda)object).zzWUN(true);
        }
        zzXAk2.zzZTB().zzXuV().setExtensions(new zzVTz<zzYOo>());
        object = zzYOo.zzZp8(byArray2, this.zzZ1n);
        zzXAk2.zzZTB().zzXuV().getExtensions().zzY98(((zzYOo)object).getUri(), (zzYOo)object);
    }

    private Shape zzZp8(zzXtP zzXtP2, String string, boolean bl, zzXtP zzXtP3) throws Exception {
        zzYwg zzYwg2 = zzYwg.zzYdH(string);
        Shape shape = this.zzZp8(zzXtP3, bl, zzYwg2, null);
        zzYiG zzYiG2 = zzYB5.zzZp8(zzXtP2, string, bl);
        return DocumentBuilder.zzZp8(null, false, shape, zzYwg2.zzQa, zzYiG2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZp8(zzXtP.zzZqK(stream), progId, asIcon, zzXtP.zzZqK(presentation));
    }

    private Shape zzZp8(String string, boolean bl, boolean bl2, zzXtP zzXtP2) throws Exception {
        zzYwg zzYwg2 = zzYwg.zzXhq(zz7e.zzZym(string));
        return this.zzZp8(string, bl, bl2, zzXtP2, zzYwg2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZp8(fileName, isLinked, asIcon, zzXtP.zzZqK(presentation));
    }

    private Shape zzZp8(String string, String string2, boolean bl, boolean bl2, zzXtP zzXtP2) throws Exception {
        zzYwg zzYwg2 = zzYwg.zzYdH(string2);
        return this.zzZp8(string, bl, bl2, zzXtP2, zzYwg2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZp8(fileName, progId, isLinked, asIcon, zzXtP.zzZqK(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYwg zzYwg2 = zzYwg.zzXhq(zz7e.zzZym(fileName));
        return this.zzZp8(fileName, isLinked, iconFile, iconCaption, zzYwg2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYwg zzYwg2 = zzYwg.zzYdH(progId);
        return this.zzZp8(fileName, isLinked, iconFile, iconCaption, zzYwg2);
    }

    private Shape zzZp8(zzXtP zzXtP2, String string, String string2, String string3) throws Exception {
        zzYwg zzYwg2 = zzYwg.zzYdH(string);
        Shape shape = this.zzZp8(string2, string3, zzYwg2);
        zzYiG zzYiG2 = zzYB5.zzZp8(zzXtP2, string, true);
        return DocumentBuilder.zzZp8(null, false, shape, zzYwg2.zzQa, zzYiG2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzZp8(zzXtP.zzZqK(stream), progId, iconFile, iconCaption);
    }

    final Shape zzZp8(zzW2r zzW2r2, zzXtP zzXtP2) throws Exception {
        Shape shape = this.zzZPt(zzXtP2);
        shape.zzWZW(201);
        shape.getOleFormat().zzZqK(zzW2r2.zzXwk());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzWGw();
        if (this.zzlK()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzYai(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzXLK zzXLK2 = zzxN.zzZp8(html, options, this);
        zzXLK2.zzZIG();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzWGw();
        return zzxN.zzZp8(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzWGw();
        return zzxN.zzZp8(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzWVd zzWVd2 = new zzWVd();
        return zzWVd2.zzZp8(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWfs(this).zzZp8(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWfs(this).zzZp8(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZ1n, 75);
        shape.zzZp8(this.zzs0());
        shape.zz3u(true);
        shape.getSignatureLine().zzZp8(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzpq(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZJM(this.zzZ1n);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzlK() {
        boolean bl = false;
        if (this.zzQn().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzQn().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzYai(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzWGw();
        if (this.zzWOg() == null) {
            this.startTable();
        }
        if (this.zzWOg().zzWv1() == 1) {
            this.zzWOg().zzZ20();
        }
        if (this.zzWOg().zzWv1() == 3) {
            this.zzWOg().zzWIi();
        }
        return this.zzWOg().zzvO();
    }

    public Table startTable() {
        this.zzWM0.push(new zzXMR(this));
        return this.zzWOg().startTable();
    }

    public Table endTable() {
        if (this.zzWOg() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzWOg().endTable();
        this.zzWM0.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzWOg() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzWOg().endRow();
        if (this.zzYRE != null && this.zzYRE.getHidden()) {
            row.zzXAp().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZ1n, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZ1n, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzVZa();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZ1n, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzZlA();
        bookmarkStart.zzZ7L(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzVZa();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzZlA();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZ1n, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzbx(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZ1n);
        this.zzW0e = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzW0e == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZ1n, this.zzW0e);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZ1n, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZbv.zzZqK((Object)importFormatOptions, "ImportFormatOptions");
        this.zzWGw();
        return zzXmz.zzZp8(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzZ1n;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZ1n) {
            return;
        }
        this.zzZ1n = value;
        this.zzYmh(null);
        this.zzZl9 = new zz3x();
        this.zzZvf = null;
        this.zzcD = null;
        this.zzYRE = null;
        this.zzWM0 = new zzXRs();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzYRE == null) {
            DocumentBuilder documentBuilder = this;
            this.zzYRE = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzYRE;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzYid == null) {
            this.zzYid = new RowFormat(this);
        }
        return this.zzYid;
    }

    public CellFormat getCellFormat() {
        if (this.zzW6j == null) {
            this.zzW6j = new CellFormat(this);
        }
        return this.zzW6j;
    }

    final void zzmt(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zz3x zz3x2 = this.getCurrentParagraph().zzYpi();
        this.zzWmO().push(new zzZp8(this.zzs0(), (zz3x)zz3x2.zzYcB()));
    }

    public void popFont() {
        zzXRs<zzZp8> zzXRs2 = this.zzWmO();
        if (zzXRs2.size() > 0) {
            zzZp8 zzZp82 = (zzZp8)this.zzWmO().pop();
            this.zzZp8(zzZp82.zz4S(), false);
            this.getCurrentParagraph().zzXWx(zzZp82.zzZEq());
        }
    }

    final void zzZad() {
        this.zzWTB().push(this.zzs0());
    }

    final void zzY5W() {
        zzXRs<zz3x> zzXRs2 = this.zzWTB();
        if (zzXRs2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzZp8((zz3x)documentBuilder.zzWTB().pop(), false);
        }
    }

    final void zzYPX() {
        this.zzOh().push(this.zzZmP());
    }

    final void zzZOm() {
        zzXRs<zzVVj> zzXRs2 = this.zzOh();
        if (zzXRs2.size() > 0) {
            this.getCurrentParagraph().zzZp8((zzVVj)this.zzOh().pop());
        }
    }

    final zzYIq zzZqK(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzWMs(88);
        zzYmP zzYmP2 = new zzYmP();
        zzYmP2.setTarget(string2);
        zzYmP2.setScreenTip(string3);
        if (bl) {
            zzYmP2.setSubAddress(string);
        } else {
            zzYmP2.setAddress(zz9p.zzYej(string));
            zzYmP2.setSubAddress(zz9p.zzX8Y(string));
        }
        this.zzZjb(zzYmP2.zzX7q());
        FieldSeparator fieldSeparator = this.zzZi4(88);
        return new zzYIq(fieldStart, fieldSeparator, null);
    }

    final zzYIq zzWjD(String string, String string2, String string3) {
        boolean bl = zz9p.zzPW(string);
        String string4 = bl ? zz9p.zzX8Y(string) : string;
        return this.zzZqK(string4, bl, string2, string3);
    }

    final FieldEnd zzZUK() {
        return this.zzVP8(88, true);
    }

    final zz3x zzs0() {
        zz3x zz3x2 = this.zzZl9;
        return (zz3x)zz3x2.zzYcB();
    }

    final zzVVj zzZmP() {
        zzVVj zzVVj2 = this.getCurrentParagraph().zzZkH();
        return (zzVVj)zzVVj2.zzYcB();
    }

    final zzXox zzZnj() {
        zzXox zzXox2 = this.zzXAp();
        return (zzXox)zzXox2.zzYcB();
    }

    final zzZxO zzYzM() {
        zzZxO zzZxO2 = this.zzVZP();
        return (zzZxO)zzZxO2.zzYcB();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzQn(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzQn().getNodeType() == 8;
    }

    private void zzY7o(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzXw6.zzXFK(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzXSs(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWRe) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzWCY(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzXSs(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzWGw();
        if (this.zzWOg() != null && this.zzWOg().zzWv1() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzQn().getParentNode().insertBefore(node, this.zzQn());
    }

    final void zzX4c(int n) {
        this.zzZ2J(true);
        this.zzyr(n);
    }

    private void zzyr(int n) {
        this.insertParagraph();
        zzXUj zzXUj2 = new zzXUj(this.getDocument());
        try {
            zzYhJ zzYhJ2 = this.getCurrentSection().zzWA5();
            zzYhJ zzYhJ3 = (zzYhJ)zzYhJ2.zzYcB();
            Section section = new Section(this.zzZ1n, zzYhJ3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZ1n));
            this.zzZ1n.insertAfter(section, this.getCurrentSection());
            section.getBody().zzZqK(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzXUj2.dispose();
        }
    }

    final FieldStart zzWMs(int n) {
        this.zzWGw();
        return zzxN.zzZp8(n, this.zzs0(), this.zzQn(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzZjb(String string) {
        return zzxN.zzZqK(string, this.zzs0(), this.zzQn(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzVP8(int n, boolean bl) {
        return zzxN.zzZqK(n, bl, this.zzs0(), this.zzQn(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzZi4(int n) {
        return zzxN.zzZqK(n, this.zzs0(), this.zzQn(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzZd2(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZ1n, new zzYtM(), this.zzs0());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzZ2J(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzWOg() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzWYQ(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzXSs(String string) {
        if (this.zzXVN(string)) {
            zzWf0 zzWf02 = new zzWf0(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYVG zzYVG2 : zzWf02.zzYf8(this.getParagraphFormat().getBidi())) {
                zzY7o zzY7o2 = zzY7o.zzW2F(zzYVG2.zzw5());
                zz3x zz3x2 = this.zzs0();
                zz3x2.zzWjD(265, zzY7o2);
                if (zzYVG2.zzXXQ()) {
                    zz3x2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZ1n, zzYVG2.getText(), zz3x2);
                this.insertNode(run);
            }
            return;
        }
        this.zzWCY(string);
    }

    private boolean zzXVN(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzXH6.zzXKU(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzZp8(zz3x zz3x2, boolean bl) {
        zz3x zz3x3;
        if (bl) {
            zz3x zz3x4 = zz3x2;
            zz3x3 = (zz3x)zz3x4.zzYcB();
        } else {
            zz3x3 = zz3x2;
        }
        this.zzZl9 = zz3x3;
    }

    final void zzdO() {
        this.zzZl9.clear();
    }

    final void zzXgX() {
        if (this.zzVZa() != null) {
            zzZxO zzZxO2;
            zzZxO zzZxO3 = zzZxO2 = this.zzVZa().zzVZP();
            this.zzX0e = (zzZxO)zzZxO3.zzYcB();
            zzZxO2.zzZqK(this.zzX0e);
        }
    }

    private Shape zzZp8(String string, boolean bl, boolean bl2, zzXtP zzXtP2, zzYwg zzYwg2) throws Exception {
        if (zzYwg2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzZp8(zzXtP2, bl2, zzYwg2, string);
        zzYiG zzYiG2 = zzYB5.zzZp8(string, bl, bl2, zzYwg2);
        return DocumentBuilder.zzZp8(string, bl, shape, zzYwg2.zzQa, zzYiG2);
    }

    private Shape zzZp8(String string, boolean bl, String string2, String string3, zzYwg zzYwg2) throws Exception {
        if (zzYwg2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zz7e.zzg6(string);
        }
        Shape shape = string2 != null ? this.zzWMS(string2, string3) : this.zzZp8(null, string3, zzYwg2);
        zzYiG zzYiG2 = zzYB5.zzZp8(string, bl, true, zzYwg2);
        return DocumentBuilder.zzZp8(string, bl, shape, zzYwg2.zzQa, zzYiG2);
    }

    private static Shape zzZp8(String string, boolean bl, Shape shape, String string2, zzYiG zzYiG2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzWZW(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzZqK(zzYiG2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzZp8(zzXtP zzXtP2, boolean bl, zzYwg zzYwg2, String string) throws Exception {
        if (zzYwg2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzXtP2 != null) {
            return this.zzZPt(zzXtP2);
        }
        if (!bl) {
            return this.zzXrD(zzYB5.zzYok().get("normal"));
        }
        String string2 = string != null ? zz7e.zzg6(string) : zzYB5.zzWkN(zzYwg2.zzWME);
        return this.zzZp8(zzYwg2, string2);
    }

    private Shape zzZp8(String string, String string2, zzYwg zzYwg2) throws Exception {
        if (zzYwg2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzYB5.zzWkN(zzYwg2.zzWME);
        }
        if (string != null) {
            return this.zzWMS(string, string2);
        }
        return this.zzZp8(zzYwg2, string2);
    }

    private Shape zzZp8(zzYwg zzYwg2, String string) throws Exception {
        if (zzYwg2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzYB5.zzYPv(zzYwg2.zzWME);
        zzXUY zzXUY2 = new zzXUY(byArray, null, string, this.getDocument().zzZB1());
        return this.zzXrD(zzXUY2.zzXNd());
    }

    private Shape zzWMS(String string, String string2) throws Exception {
        zzXUY zzXUY2 = new zzXUY(string, string2, this.getDocument().zzZB1());
        return this.zzXrD(zzXUY2.zzXNd());
    }

    private Shape zzZPt(zzXtP zzXtP2) throws Exception {
        byte[] byArray = zzZbv.zzZhC(zzXtP2);
        return this.zzXrD(byArray);
    }

    private Shape zzXrD(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZ1n, 1);
        shape.zzWZW(75);
        shape.zzZp8(this.zzs0());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzpq(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzZp8(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzZqK(compositeNode, n);
            return;
        }
        this.zzWxF(compositeNode, n);
    }

    private void zzZqK(CompositeNode compositeNode, int n) {
        zzY4e zzY4e2 = zzY4e.zzZS0(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzY4e2.zzZp8(null, true, true, true, false, true);
            node = zzY4e2.getNode();
            if (zzY4e2.zzWtj() && (!node.isComposite() || node.zzY63() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzX94().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzZqK(null, node);
            this.zzYHX = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzWxF(CompositeNode compositeNode, int n) {
        zzY4e zzY4e2 = zzY4e.zzW4M(compositeNode);
        while (zzY4e2.getNode() != compositeNode || !zzY4e2.zzWtj()) {
            int n2;
            Node node = zzY4e2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzX94().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzZqK(null, node);
                this.zzYHX = n;
                return;
            }
            while (zzY4e2.zzZp8(null, false, true, true, false, true) && zzY4e2.zzWtj() && zzY4e2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzWGw() {
        int n = this.zzYHX;
        if (n == 0) {
            return;
        }
        this.zzYHX = 0;
        Run run = zzZbv.zzZp8((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzZM5(n);
        }
    }

    private Run zzWCY(String string) {
        Run run = new Run(this.zzZ1n, string, this.zzs0());
        this.insertNode(run);
        return run;
    }

    final boolean zzXx2() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzY5g() {
        return this.zzWRe;
    }

    final void zzXx5(int n) {
        this.zzWRe = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzQn();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzQn();
        }
        return (Paragraph)this.zzQn().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzXMR zzWOg() {
        zzXRs<zzXMR> zzXRs2 = this.zzWM0;
        if (zzXRs2.size() > 0) {
            return (zzXMR)this.zzWM0.peek();
        }
        return null;
    }

    private Cell zzVZa() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzYk3();
    }

    private zzXRs<zz3x> zzWTB() {
        if (this.zzZvf == null) {
            this.zzZvf = new zzXRs();
        }
        return this.zzZvf;
    }

    private zzXRs<zzVVj> zzOh() {
        if (this.zzcD == null) {
            this.zzcD = new zzXRs();
        }
        return this.zzcD;
    }

    private zzXRs<zzZp8> zzWmO() {
        if (this.zzZOF == null) {
            this.zzZOF = new zzXRs();
        }
        return this.zzZOF;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZl9.zzYkE(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZgK(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZgK(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZl9.zzWjD(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWfH()) {
            this.getCurrentParagraph().zzYpi().zzWjD(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZl9.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZl9.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWfH()) {
            this.getCurrentParagraph().zzYpi().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzXAp().zzYkE(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzXAp().zzYo2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzXAp().zz3u(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzXAp().zzWjD(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzXAp().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzXAp().clear();
        zzXox.zzYNU().zzZqK(this.zzXAp());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzVZP().zzYkE(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzVZP().zzYo2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzVZP().zz3u(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZbv.zzZp8(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzVZa() != null ? this.zzVZa().getCellFormat() : this.getCellFormat();
            border.zzZp8(cellFormat);
        }
        this.zzVZP().zzWjD(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzVZP().clear();
    }

    private Node zzQn() {
        Node node = this.zzYHq != null && this.zzYHq.getParentNode() == null ? this.zzYZi : this.zzYHq;
        if (node != null && node.zzY63() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzYmh(Node node) {
        this.zzYHq = node;
        if (this.zzYHq != null) {
            this.zzYZi = this.zzYHq.getParentNode();
        }
    }

    private zzXox zzXAp() {
        if (this.zzWOg() != null && this.zzWOg().zzWv1() == 1) {
            return this.zzXx2;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzXAp();
        }
        return this.zzXx2;
    }

    private zzZxO zzVZP() {
        if (this.zzWOg() != null && this.zzWOg().zzWv1() != 3) {
            return this.zzX0e;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzYk3().zzVZP();
        }
        return this.zzX0e;
    }

    static final class zzZp8 {
        private zz3x zzZl9;
        private zz3x zzVPB;

        public zzZp8(zz3x zz3x2, zz3x zz3x3) {
            this.zzZl9 = zz3x2;
            this.zzVPB = zz3x3;
        }

        public final zz3x zz4S() {
            return this.zzZl9;
        }

        public final zz3x zzZEq() {
            return this.zzVPB;
        }
    }
}

