/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzX3d;
import com.aspose.words.internal.zzX8S;
import com.aspose.words.internal.zzXFZ;
import com.aspose.words.internal.zzXr8;
import com.aspose.words.internal.zzXtP;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXDx;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzb8 = new HashMap();
    private static HashMap<Integer, Integer> zzXxZ = new HashMap();
    private static HashMap<Integer, Integer> zz5P = new HashMap();
    private static HashMap<Integer, Integer> zz7A = new HashMap();
    private static HashMap<Integer, Integer> zzgm = new HashMap();
    private static HashMap<Integer, Integer> zzW3N = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZbv.zzZp8(fileName, "fileName");
        try (zzX3d zzX3d2 = zzZbv.zzYzS(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzVRY(zzX3d2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzVRY(zzX8S.zzZp8(stream));
    }

    static FileFormatInfo zzVRY(zzXtP zzXtP2) throws Exception {
        if (zzXtP2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzXDx zzXDx2 = new zzXDx();
            zzXtP zzXtP3 = zzXtP2;
            zzXDx zzXDx3 = zzXDx2;
            return zzXDx2.zzZqK(zzXtP3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzWxF(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzYvd(zzXr8.zzYUO(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzXw2(zzXr8.zzYUO(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzXFZ.zzWaY(string = zzXr8.zzX1Z(FileFormatUtil.zzZ(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzYvd(FileFormatUtil.zzWWz(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzXw2(FileFormatUtil.zzZ(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXr8.zzX1Z(FileFormatUtil.zzWWz(saveFormat));
        if (zzXFZ.zzWaY(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzXw2(zzXr8.zzXv0(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXr8.zzX1Z(FileFormatUtil.zzZUW(imageType));
    }

    static Exception zzWxF(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzWs3(int n) {
        return zzXr8.toString(FileFormatUtil.zzWWz(n));
    }

    static int zzXw2(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZbv.zzZp8(zzgm, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzXUI(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZbv.zzZp8(zzW3N, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzoX(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzZ(int n) {
        return zzZbv.zzZp8(zzb8, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzWWz(int n) {
        return zzZbv.zzZp8(zzXxZ, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZUW(int n) {
        return zzZbv.zzZp8(zz5P, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYvd(int n) {
        return zzZbv.zzZp8(zz7A, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zz3m(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZbv.zzZqK(zzgm, Integer.valueOf(n), Integer.valueOf(n2));
            zzZbv.zzZqK(zzXxZ, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zz7A.containsKey(n)) {
                zzZbv.zzZqK(zz7A, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZbv.zzZqK(zzb8, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZbv.zzZqK(zzW3N, Integer.valueOf(n), Integer.valueOf(n4));
            zzZbv.zzZqK(zz5P, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zz3m(11, 10, 10, 1);
        FileFormatUtil.zz3m(11, 0, 0, 1);
        FileFormatUtil.zz3m(12, 11, 11, 1);
        FileFormatUtil.zz3m(13, 20, 20, 1);
        FileFormatUtil.zz3m(13, 0, 254, 1);
        FileFormatUtil.zz3m(14, 21, 21, 1);
        FileFormatUtil.zz3m(15, 22, 22, 1);
        FileFormatUtil.zz3m(16, 23, 23, 1);
        FileFormatUtil.zz3m(18, 24, 24, 1);
        FileFormatUtil.zz3m(19, 25, 25, 1);
        FileFormatUtil.zz3m(20, 26, 26, 1);
        FileFormatUtil.zz3m(21, 27, 27, 1);
        FileFormatUtil.zz3m(24, 30, 30, 1);
        FileFormatUtil.zz3m(17, 31, 31, 1);
        FileFormatUtil.zz3m(25, 50, 50, 1);
        FileFormatUtil.zz3m(26, 45, 255, 1);
        FileFormatUtil.zz3m(27, 51, 51, 1);
        FileFormatUtil.zz3m(28, 0, 52, 1);
        FileFormatUtil.zz3m(29, 0, 53, 1);
        FileFormatUtil.zz3m(22, 60, 60, 1);
        FileFormatUtil.zz3m(23, 61, 61, 1);
        FileFormatUtil.zz3m(33, 40, 64, 1);
        FileFormatUtil.zz3m(40, 47, 255, 1);
        FileFormatUtil.zz3m(41, 48, 255, 1);
        FileFormatUtil.zz3m(34, 41, 255, 1);
        FileFormatUtil.zz3m(35, 46, 255, 1);
        FileFormatUtil.zz3m(37, 42, 255, 1);
        FileFormatUtil.zz3m(36, 44, 255, 1);
        FileFormatUtil.zz3m(30, 52, 255, 1);
        FileFormatUtil.zz3m(31, 70, 62, 1);
        FileFormatUtil.zz3m(32, 73, 63, 1);
        FileFormatUtil.zz3m(38, 71, 255, 1);
        FileFormatUtil.zz3m(8, 100, 255, 1);
        FileFormatUtil.zz3m(9, 105, 255, 1);
        FileFormatUtil.zz3m(6, 101, 255, 6);
        FileFormatUtil.zz3m(7, 102, 255, 7);
        FileFormatUtil.zz3m(5, 104, 255, 5);
        FileFormatUtil.zz3m(4, 0, 255, 4);
        FileFormatUtil.zz3m(3, 0, 255, 3);
        FileFormatUtil.zz3m(39, 72, 255, 1);
        FileFormatUtil.zz3m(2, 103, 255, 2);
    }
}

