/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzXRs;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzY4e;
import com.aspose.words.zzZ9y;
import com.aspose.words.zzZbh;
import com.aspose.words.zzne;
import com.aspose.words.zzxN;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzXh4;
    private Node zzZJx;
    private Node zzcN;
    private int zzWFS;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzWKk(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzXh4 == null) {
            return null;
        }
        if (this.zzXh4.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzXh4;
    }

    final CompositeNode zzZGL() {
        if (zzxN.zzWoH(this.getParentNode())) {
            return this.getParentNode().zzZGL();
        }
        return this.getParentNode();
    }

    final CompositeNode zzZ3u() {
        if (zzxN.zzWoH(this.getParentNode()) || zzxN.zzZ6r(this.getParentNode())) {
            return this.getParentNode().zzZ3u();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzXh4 != null) {
            return this.zzXh4.getDocument();
        }
        return null;
    }

    final Document zzYkM() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzWIR() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzhQ();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzcN;
    }

    final Node zzXUr() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzxN.zzVZq((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzZ4i() {
        Node node = zzxN.zzZhC(this.getPreviousSibling(), false);
        if (node == null && zzxN.zzWoH(this.getParentNode())) {
            node = this.getParentNode().zzZ4i();
        }
        return node;
    }

    final Node zzW7Z() {
        Node node = zzxN.zzVR4(this.getNextSibling(), false);
        if (node == null && zzxN.zzWoH(this.getParentNode())) {
            node = this.getParentNode().zzW7Z();
        }
        return node;
    }

    final CompositeNode zzXpG() {
        Node node = this;
        while ((node = node.zzZ4i()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzX0d() {
        Node node = this;
        while ((node = node.zzW7Z()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzZJx;
    }

    final Node zzom() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzxN.zzVZq((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zz4c() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXPG() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzPf() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzxN.zz7b(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzSm() {
        return this.zzZJx;
    }

    final void zzW(Node node) {
        this.zzZJx = node;
    }

    final Node zzW44() {
        return this.zzcN;
    }

    final void zzW0d(Node node) {
        this.zzcN = node;
    }

    final Node zzXIv() {
        Node node = this;
        if (node.zzZJx != null) {
            node = this;
            return node.zzZJx;
        }
        return this.getParentNode();
    }

    final int zzY63() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzxN.zzWiB(this);
        boolean bl2 = zzxN.zzYuO(this);
        boolean bl3 = zzxN.zzzz(this);
        boolean bl4 = zzxN.zzY39(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzY63() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzY63() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZp8(isCloneChildren, new zzZp8(this));
    }

    Node zzZp8(boolean bl, zzZ9y zzZ9y2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzXh4 != null) {
            node.zzXh4 = this.getDocument().zzYHd();
        }
        node.zzZJx = null;
        node.zzcN = null;
        if (zzZ9y2 != null) {
            zzZ9y2.zzWKk(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzYzS(StringBuilder stringBuilder) {
        zzZbv.zzZqK(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzWLP(Node node) {
        this.zzXh4 = node != null ? node : this.getDocument().zzYHd();
    }

    final void zzWKk(DocumentBase documentBase) {
        this.zzXh4 = documentBase != null ? documentBase.zzYHd() : null;
    }

    final boolean zzZoF(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzYLU() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzZlO(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYwl(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzYdw(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzVRR(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzne zzne2 = zzxN.zzXNq(saveFormat);
        return zzne2.zzZB4(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzne zzne2 = zzxN.zzZp8(saveOptions);
        return zzne2.zzZB4(this);
    }

    final Node zzWp3(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzxN.zzpq(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzY4e zzVH() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzY4e.zzW4M(node);
        }
        return zzY4e.zzZS0(this.getParentNode());
    }

    final zzY4e zzXUw() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzY4e.zzZS0(node);
        }
        return zzY4e.zzW4M(this.getParentNode());
    }

    final boolean zzWET(Node node) {
        return Node.zzXZP(this, node);
    }

    final boolean zzXK8() {
        return this.getAncestor(1) == null;
    }

    static Node zzZIL(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzXRs<Node> zzXRs2 = Node.zzZxw(node);
        zzXRs<Node> zzXRs3 = Node.zzZxw(node2);
        return Node.zzZp8(zzXRs2, zzXRs3);
    }

    static boolean zzXZP(Node node, Node node2) {
        zzXRs<Node> zzXRs2;
        if (node == null || node2 == null) {
            return false;
        }
        zzXRs<Node> zzXRs3 = Node.zzZxw(node);
        Node node3 = Node.zzZp8(zzXRs3, zzXRs2 = Node.zzZxw(node2));
        if (node3 == null) {
            return false;
        }
        zzXRs<Node> zzXRs4 = zzXRs3;
        if (zzXRs4.size() == 0 || (zzXRs4 = zzXRs2).size() == 0) {
            zzXRs4 = zzXRs2;
            boolean bl = zzXRs4.size() > 0;
            return bl;
        }
        Object e = zzXRs3.peek();
        Object e2 = zzXRs2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzXRs<Node> zzZxw(Node node) {
        zzXRs<Node> zzXRs2 = new zzXRs<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzXRs2.push(node2);
        }
        return zzXRs2;
    }

    private static Node zzZp8(zzXRs<Node> zzXRs2, zzXRs<Node> zzXRs3) {
        Node node = null;
        while (zzXRs2.peek() == zzXRs3.peek()) {
            node = (Node)zzXRs2.pop();
            zzXRs3.pop();
            zzXRs<Node> zzXRs4 = zzXRs2;
            if (zzXRs4.size() != 0 && (zzXRs4 = zzXRs3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzWFS;
    }

    public void setCustomNodeId(int value) {
        this.zzWFS = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzYFZ(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzXKU(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWKF(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzXKU(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzXKU(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzZp8
    implements zzZ9y {
        private Node zzXey;
        private HashMap<Integer, Integer> zzWEJ;

        zzZp8(Node node) {
            this.zzXey = node;
        }

        @Override
        public final void zzWKk(Node node, Node node2) {
            if (node == this.zzXey) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzZbh zzZbh2 = (zzZbh)((Object)node2);
            if (this.zzWEJ == null) {
                this.zzWEJ = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzZbv.zzZp8(this.zzWEJ, Integer.valueOf(zzZbh2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzWYa();
                zzZbv.zzZqK(this.zzWEJ, Integer.valueOf(zzZbh2.getIdInternal()), Integer.valueOf(n));
            }
            zzZbh2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzZbv.zzZp8(this.zzWEJ, Integer.valueOf(zzZbh2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzZbh2.setParentIdInternal(n2);
            }
        }
    }
}

