/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.zzW9O;
import com.aspose.words.zzWUT;
import com.aspose.words.zzWoS;
import com.aspose.words.zzXWG;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzW9O,
Iterable<T> {
    private Node zzYzn;
    private CompositeNode zzWZa;
    private DocumentBase zzWqd;
    private boolean zzYKm;
    private int zzYoe;
    private int zzZ20;
    private Node zzvO;
    private int zzWGl;
    private zzWoS zzWIi;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzWUT.zznX(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzWUT(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzWoS matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzWZa = container;
        this.zzWqd = container.getDocument();
        this.zzWIi = matcher;
        this.zzYKm = isDeep;
        this.zzXz8();
    }

    public Node get(int index) {
        try {
            this.zzZjG();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzZ20 == index) {
                return this.zzvO;
            }
            int n = index - this.zzZ20;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzXvz(nodeCollection.zzvO, n);
            if (node != null) {
                this.zzZ20 = index;
                this.zzvO = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzYKm) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzWZa.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzYKm) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzWZa.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzoT();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXWG(this);
    }

    final <TNode extends Node> zzXWG<TNode> zzYRj() {
        return new zzXWG(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzoT() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZbv.zzZp8(arrayList, node);
        }
        return arrayList;
    }

    private Node zzXvz(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZBF(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzWEV(curNode, true);
    }

    private Node zzWEV(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzYzn = node;
        do {
            node2 = this.zzYzn;
            Node node3 = this.zzYKm ? this.zzZp8(true, this.zzYzn) : (this.zzYzn = this.zzWIi.zzYXu() ? this.zzWxF(true, this.zzYzn) : this.zzZqK(true, this.zzYzn));
        } while (this.zzYzn != null && !this.zzWIi.zzYdw(this.zzYzn));
        return node2;
    }

    private Node zzZBF(Node node, boolean bl) throws Exception {
        while ((this.zzYKm ? this.zzZp8(bl, node) : (node = this.zzWIi.zzYXu() ? this.zzWxF(bl, node) : this.zzZqK(bl, node))) != null && !this.zzWIi.zzYdw(node)) {
        }
        return node;
    }

    private Node zzZp8(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzWZa);
        }
        return node.previousPreOrder(this.zzWZa);
    }

    private Node zzZqK(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzWZa) {
                return this.zzWZa.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzWZa) {
            return this.zzWZa.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzWxF(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzWZa ? this.zzWZa.zz0x() : node.zzW7Z();
        } else {
            Node node3 = node2 = node == this.zzWZa ? this.zzWZa.zzWhJ() : node.zzZ4i();
        }
        if (node2 == this.zzWZa.getNextSibling() || node2 == this.zzWZa.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzZjG() {
        if (this.zzYoe != this.zzW66()) {
            this.zzXz8();
        }
    }

    private void zzXz8() {
        this.zzYoe = this.zzW66();
        this.zzZ20 = -1;
        this.zzvO = this.zzWZa;
        this.zzWGl = -1;
    }

    private int zzW66() {
        if (this.zzWqd != null) {
            return this.zzWqd.zzZCK();
        }
        return 0;
    }

    public int getCount() {
        this.zzZjG();
        if (this.zzWGl == -1) {
            this.zzWGl = zzXWG.zzZp8(this);
        }
        return this.zzWGl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYzn;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzWZa;
    }
}

