/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zz7e;
import com.aspose.words.internal.zzXr8;

public abstract class SaveOptions {
    private boolean zzWkR;
    private boolean zzZ27 = true;
    private boolean zzXVG = false;
    private boolean zzZkg = true;
    private boolean zzVQD;
    private String zzkj;
    private boolean zzYIm;
    private boolean zzXMD = false;
    private boolean zzWGq = true;
    private int zzO6 = 1;
    private int zzZJw = 1;
    private int zzOl = 0;
    private String zzWkG = "";
    private boolean zzXKP = true;
    private boolean zzXb8 = true;
    private boolean zzZpa;
    private boolean zzZQq;
    private int zzYJq = 0;
    private boolean zzYyo = true;
    private boolean zzYuX = false;
    private boolean zzXlx = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzVSn() {
        return false;
    }

    boolean zzVWC() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzZkg;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzZkg = value;
    }

    public String getTempFolder() {
        return this.zzkj;
    }

    public void setTempFolder(String value) {
        this.zzkj = value;
    }

    public boolean getPrettyFormat() {
        return this.zzVQD;
    }

    public void setPrettyFormat(boolean value) {
        this.zzVQD = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYIm;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYIm = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzXMD;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzXMD = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzWGq;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzWGq = value;
    }

    public int getDmlRenderingMode() {
        return this.zzO6;
    }

    public void setDmlRenderingMode(int value) {
        this.zzO6 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzOl;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzOl = value;
    }

    public int getImlRenderingMode() {
        return this.zzZJw;
    }

    public void setImlRenderingMode(int value) {
        this.zzZJw = value;
    }

    public String getDefaultTemplate() {
        return this.zzWkG;
    }

    public void setDefaultTemplate(String value) {
        this.zzWkG = value;
    }

    public boolean getUpdateFields() {
        return this.zzXKP;
    }

    public void setUpdateFields(boolean value) {
        this.zzXKP = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzZpa;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzZpa = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZQq;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZQq = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYuX;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYuX = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXVG;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXVG = value;
    }

    final boolean zzW4P() {
        return this.zzXb8;
    }

    final boolean zzYYO() {
        return this.zzYyo;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzXw2(zzXr8.zzXv0(zz7e.zzZym(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzYJq;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzYJq = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzWkR;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzWkR = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzXlx;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzXlx = value;
    }

    final boolean zzYCX() {
        return this.zzZ27;
    }
}

