/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.zzYhJ;
import com.aspose.words.zzZ9y;
import com.aspose.words.zzcK;

public final class Section
extends CompositeNode<Node>
implements zzcK {
    private zzYhJ zzWuH;
    private PageSetup zzYP1;
    private HeaderFooterCollection zzxO;

    public Section(DocumentBase doc) {
        this(doc, new zzYhJ());
    }

    Section(DocumentBase doc, zzYhJ sectPr) {
        super(doc);
        this.zzWuH = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzxO == null) {
            this.zzxO = new HeaderFooterCollection(this);
        }
        return this.zzxO;
    }

    public final PageSetup getPageSetup() {
        if (this.zzYP1 == null) {
            Section section = this;
            this.zzYP1 = new PageSetup(section, section.getDocument().zzId(), this.getDocument().getStyles(), new zzZp8(this));
        }
        return this.zzYP1;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzWpW();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzWz(!value);
    }

    final zzYhJ zzWA5() {
        return this.zzWuH;
    }

    final void zzWxF(zzYhJ zzYhJ2) {
        this.zzWuH = zzYhJ2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZp8(boolean bl, zzZ9y zzZ9y2) {
        zzYhJ zzYhJ2;
        Section section = (Section)super.zzZp8(bl, zzZ9y2);
        zzYhJ zzYhJ3 = this.zzWuH;
        section.zzWuH = zzYhJ2 = (zzYhJ)zzYhJ3.zzYcB();
        section.zzYP1 = null;
        section.zzxO = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZp8(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzZqK(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzWKk(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzWKk(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzYGZ(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzZhC(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzYGZ(n) == null;
            }
        }
        return false;
    }

    final void zzWxF(Shape shape, boolean bl) {
        this.zzZp8(shape, 4, bl);
        this.zzZp8(shape, 0, bl);
        this.zzZp8(shape, 1, bl);
    }

    private void zzZp8(Shape shape, int n, boolean bl) {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzW5U() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzXnR()) {
                if (!shape.zzYpt()) continue;
                shape.remove();
            }
        }
    }

    private void zzWKk(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzZqK(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzWuH.zzYkE(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzId().zzYoP.zzYo2(key);
        }
        return zzYhJ.zzYAb(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzWuH.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzId().zzYoP.zzWjD(key, value);
            return;
        }
        this.zzWuH.zzWjD(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzWuH.clear();
    }

    final boolean zzZJH() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzWTq() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzZp8
    implements zzcK {
        private Section zzXFv;

        zzZp8(Section section) {
            this.zzXFv = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzWNn().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzWNn().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzWNn().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzcK zzWNn() {
            Document document = zzZbv.zzZp8((Object)this.zzXFv.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzXFv;
        }
    }
}

