/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWf0;
import com.aspose.words.internal.zzXFZ;
import com.aspose.words.internal.zzXG5;
import com.aspose.words.internal.zzXlM;
import com.aspose.words.internal.zzY8f;
import com.aspose.words.internal.zzZ7M;
import com.aspose.words.internal.zzZbv;
import com.aspose.words.zz9f;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzZ1n;
    private zz9f zzG2;

    Watermark(Document doc, zz9f watermarkProvider) {
        this.zzZ1n = doc;
        this.zzG2 = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzZ5T(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzZp8(text, textWatermarkOptions, this.zzZ1n);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZbv.zzZqK((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzZ1n, 75);
        shape.getImageData().setImage(image);
        this.zzZp8(shape, options, this.zzZ1n);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZbv.zzZqK((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzZ1n, 75);
        shape.getImageData().setImage(imagePath);
        this.zzZp8(shape, options, this.zzZ1n);
    }

    public final int getType() {
        Shape shape = this.zzG2.get();
        if (shape == null) {
            return 2;
        }
        shape.zzYpt();
        if (shape.zzYDi()) {
            return 0;
        }
        if (shape.zzXlP()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzG2.add(shape);
    }

    public final void remove() {
        this.zzG2.remove();
    }

    private static void zzZ5T(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzXFZ.zzWgz(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZbv.zzZp8(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzZp8(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzZqK(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzY98(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzZqK(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzsj() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzX20()) / d2) > (double)(f = pageSetup.zzYvP())) {
            d = (double)f / d3;
        }
        shape.zzXwt(zzZ7M.zzWxF(d2 * d, 2, zzY8f.zzYhz));
        shape.zzXzs(zzZ7M.zzWxF(d3 * d, 2, zzY8f.zzYhz));
    }

    private Shape zzZp8(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzZp8(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzY98(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzZp8(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZZX() ? 1.0f : textWatermarkOptions.getFontSize();
        zzXlM zzXlM2 = document.zzZB1().zzWxF(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzXlM2.zzVVn(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZZX()) {
            l = Watermark.zzZp8(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzXwt(zzZ7M.zzWxF(Float.intBitsToFloat(n), 2, zzY8f.zzYhz));
        shape.zzXzs(zzZ7M.zzWxF(zzWf0.zzWhn(l), 2, zzY8f.zzYhz));
    }

    private static long zzZp8(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzX20();
        float f2 = pageSetup.zzYvP();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzWf0.zzWhn(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzWf0.zzrn(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzWf0.zzWhn(l) >= Float.intBitsToFloat(n)) {
            return zzWf0.zzrn(f2 / f3, f2);
        }
        float f6 = f;
        return zzWf0.zzrn(f6, f6 * f3);
    }

    private static void zzY98(Shape shape, String string) {
        shape.setName(zzXG5.zzZqK("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

