/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzAQ;
import com.aspose.words.internal.zzWbm;
import com.aspose.words.internal.zzXLP;
import com.aspose.words.internal.zzXUx;
import com.aspose.words.internal.zzYGB;
import com.aspose.words.internal.zzYVR;
import com.aspose.words.internal.zzZla;
import com.aspose.words.internal.zzZyh;
import com.aspose.words.internal.zzZzp;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzXfW
extends CertPathBuilderSpi {
    private final zzXUx zzZzR;
    private zzYGB zzXNu;

    zzXfW(zzXUx zzXUx2) {
        this.zzZzR = zzXUx2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzWbm pkixParams;
        if (params instanceof zzWbm) {
            pkixParams = (zzWbm)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzWbm.zzZp8((PKIXBuilderParameters)params).zzZr8();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzWbm.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZla zzZla2 = pkixParams.zzXY6().zzZHq();
        try {
            collection = zzAQ.zzZp8(zzZla2, pkixParams.zzXY6().zzWTF());
            collection.addAll(zzAQ.zzZp8(zzZla2, pkixParams.zzXY6().zzap()));
        }
        catch (zzYGB zzYGB2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzYGB2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzZp8(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzXNu != null) {
            throw new CertPathBuilderException(this.zzXNu.getMessage(), this.zzXNu.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzZp8(X509Certificate x509Certificate, zzWbm zzWbm2, List list) throws CertPathBuilderException {
        zzXLP zzXLP2;
        zzZzp zzZzp2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzWbm2.zzGh().contains(x509Certificate)) {
            return null;
        }
        if (zzWbm2.zz04() != -1 && list.size() - 1 > zzWbm2.zz04()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZzp2 = new zzZzp(this.zzZzR);
            zzXLP2 = new zzXLP(this.zzZzR);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzAQ.zzZp8(x509Certificate, zzWbm2.zzXY6().zzWJb(), zzWbm2.zzXY6().zzWoO()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZzp2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzYGB("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzXLP2.engineValidate(certPath, zzWbm2);
                }
                catch (Exception exception) {
                    throw new zzYGB("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzZyh> arrayList = new ArrayList<zzZyh>();
            arrayList.addAll(zzWbm2.zzXY6().zzWTF());
            try {
                arrayList.addAll(zzAQ.zzZp8(x509Certificate.getExtensionValue(zzYVR.zzWbD.getId()), zzWbm2.zzXY6().zzYWp()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzYGB("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzAQ.zzZp8(x509Certificate, zzWbm2.zzXY6().zzap(), arrayList));
            }
            catch (zzYGB zzYGB2) {
                throw new zzYGB("Cannot find issuer certificate for certificate in certification path.", zzYGB2);
            }
            if (hashSet.isEmpty()) {
                throw new zzYGB("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzZp8(x509Certificate2, zzWbm2, list);
            }
        }
        catch (zzYGB zzYGB3) {
            this.zzXNu = zzYGB3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

