/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXG5;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzWKk;
import com.aspose.words.net.System.Data.zzXvE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzXAu;
    private final DataTable zzEF;
    private final AtomicInteger zzWZm;

    ConstraintCollection(DataTable table) {
        this.zzEF = table;
        this.zzWZm = new AtomicInteger(1);
        this.zzXAu = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zzXG5.zzvB(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzXAu) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzXAu.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzWso()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzWso()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzZp8(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            constraint.setConstraintName(this.zzWDm());
        }
        constraint.zzZp8(this);
        this.zzXAu.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzEF.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzXAu.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzXAu.contains(cc);
    }

    public int getCount() {
        return this.zzXAu.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzXAu.iterator();
    }

    final DataTable getTable() {
        return this.zzEF;
    }

    final List<ForeignKeyConstraint> zzVRu() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzXAu) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzZp8(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzXAu) {
            if (constraint instanceof UniqueConstraint) {
                this.zzZp8((UniqueConstraint)constraint, dataRow);
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzZp8((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzZp8(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzXAu) {
            if (constraint2.equals(null) || zzXG5.zzXvE(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private String zzWDm() {
        return "Constraint" + this.zzWZm.getAndIncrement();
    }

    private void zzZp8(UniqueConstraint uniqueConstraint, DataRow dataRow) throws ConstraintException {
        zzXvE zzXvE2 = this.zzEF.zzXRr().zzWKk(uniqueConstraint.getColumns());
        Map<String, Object> map = zzXvE2.zzY98(dataRow);
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringBuilder.append(zzXG5.zzZqK("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
            }
            throw new ConstraintException(stringBuilder.toString());
        }
    }

    private void zzZp8(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzEF.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzEF.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        Object object = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(((ConstraintCollection)object).zzEF.getTableName())) {
            return;
        }
        object = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(((ConstraintCollection)object).zzEF.getTableName())) {
            return;
        }
        if (!ConstraintCollection.zzZqK(foreignKeyConstraint, dataRow)) {
            DataTable dataTable = foreignKeyConstraint.getRelatedTable();
            DataRow dataRow2 = dataRow;
            DataColumn[] dataColumnArray = foreignKeyConstraint.getColumns();
            DataColumn[] dataColumnArray2 = foreignKeyConstraint.getRelatedColumns();
            object = dataTable;
            if (!zzWKk.zzZp8(dataTable, dataColumnArray2, dataColumnArray, dataRow2)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                    stringBuilder.append(zzXG5.zzZqK("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
                }
                throw new InvalidConstraintException(stringBuilder.toString());
            }
        }
    }

    private static boolean zzZqK(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) {
        boolean bl = false;
        for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
            Object object = dataRow.get(dataColumn);
            if (object == null || object == DBNull.Value) continue;
            bl = true;
            break;
        }
        return !bl;
    }
}

