/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZjP;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzVR4;
import com.aspose.words.net.System.Data.zzWxF;
import com.aspose.words.net.System.Data.zzXvE;
import com.aspose.words.net.System.Data.zzZqK;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzY7T;
    private final DataColumnCollection zzkz;
    private final ConstraintCollection zzZ3Y;
    private final zzVR4 zzWi0;
    private ResultSet zzYYp;
    private String zzYMw;
    private DataSet zzVY7;
    private String zzZo3;
    private UniqueConstraint zzZZm;
    private boolean zzyz;
    private final List<DataTableEventListener> zzYo4;
    private final Set<DataRow> zzYJS;
    private DataRelationCollection zzZGB;

    public DataTable() {
        this.zzY7T = new DataRowCollection(this);
        this.zzkz = new DataColumnCollection(this);
        this.zzZ3Y = new ConstraintCollection(this);
        this.zzWi0 = new zzVR4(this);
        this.zzZo3 = "";
        this.zzyz = true;
        this.zzYo4 = new ArrayList<DataTableEventListener>();
        this.zzYJS = new HashSet<DataRow>();
        this.zzZGB = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzY7T = new DataRowCollection(this);
        this.zzkz = new DataColumnCollection(this);
        this.zzZ3Y = new ConstraintCollection(this);
        this.zzWi0 = new zzVR4(this);
        this.zzZo3 = "";
        this.zzyz = true;
        this.zzYo4 = new ArrayList<DataTableEventListener>();
        this.zzYJS = new HashSet<DataRow>();
        this.zzZGB = new DataRelationCollection();
        this.zzYMw = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzZqK.zzZp8(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzY7T = new DataRowCollection(this);
        this.zzkz = new DataColumnCollection(this);
        this.zzZ3Y = new ConstraintCollection(this);
        this.zzWi0 = new zzVR4(this);
        this.zzZo3 = "";
        this.zzyz = true;
        this.zzYo4 = new ArrayList<DataTableEventListener>();
        this.zzYJS = new HashSet<DataRow>();
        this.zzZGB = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzYYp = resultSet;
        this.zzYMw = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzYYp != null) {
            if (this.zzYYp.getStatement() != null) {
                this.zzYYp.getStatement().getConnection().close();
            }
            this.zzYYp = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzYMw;
    }

    public void setTableName(String tableName) {
        this.zzYMw = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzkz.getCount();
    }

    public String getColumnName(int index) {
        return this.zzkz.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzYYp;
    }

    public DataSet getDataSet() {
        return this.zzVY7;
    }

    final void zzWKk(DataSet dataSet) {
        this.zzVY7 = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzVY7.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzZGB.add(dataRelation);
        }
        return this.zzZGB;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzVY7.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzY7T;
    }

    public DataColumnCollection getColumns() {
        return this.zzkz;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzZ3Y;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzZZm == null) {
            return new DataColumn[0];
        }
        return this.zzZZm.getColumns();
    }

    final void zzVR4(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzZZm != null) {
                this.zzZZm.zzZBV(false);
                this.getConstraints().remove(this.zzZZm);
                this.zzZZm = null;
            }
            return;
        }
        if (this.zzZZm != null && DataColumn.areColumnSetsTheSame(value, this.zzZZm.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZp8(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzZZm != null) {
            this.zzZZm.zzZBV(false);
            this.getConstraints().remove(this.zzZZm);
            this.zzZZm = null;
        }
        UniqueConstraint.zzZp8(this.getConstraints(), uniqueConstraint);
        this.zzZZm = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZo3;
    }

    public void setNamespace(String namespace) {
        this.zzZo3 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzyz;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzyz = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzYJS.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzZqK.zzZp8(this.getResultSet(), this);
            zzZqK.zzZqK(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzZjP.zzWKk(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzZqK.zzY98(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzYo4.contains(listener)) {
            this.zzYo4.add(listener);
        }
    }

    public void removeEventListener(zzWxF listener) {
        if (this.zzYo4.contains(listener)) {
            this.zzYo4.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzYo4.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzYJS.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYo4) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzYJS.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYo4) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzYJS.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYo4) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYo4) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYo4) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXvE zzZp8(zzZqK[] zzZqKArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzZqKArray.length];
        for (int i = 0; i < zzZqKArray.length; ++i) {
            dataColumnArray[i] = zzZqKArray[i].zzpy();
        }
        DataTable dataTable = this;
        zzXvE zzXvE2 = dataTable.zzWi0.zzWKk(dataColumnArray);
        if (zzXvE2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXvE2;
    }

    final zzVR4 zzXRr() {
        return this.zzWi0;
    }

    final Set<DataRow> zzZ7K() {
        return this.zzYJS;
    }
}

