/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzZXr;
import com.aspose.words.internal.zzm3;
import com.aspose.words.zzIx;
import com.aspose.words.zzUU;
import com.aspose.words.zzVRu;
import com.aspose.words.zzWoa;
import com.aspose.words.zzXTx;
import com.aspose.words.zzXiO;
import com.aspose.words.zzZET;
import com.aspose.words.zzZdu;
import com.aspose.words.zzo;
import com.aspose.words.zzrj;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzZdu zzWpi;

    ChartSeriesCollection(zzZdu dmlChart) {
        this.zzWpi = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWpi.zzYWz().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWpi.zzYWz().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzWpi.zzYWz().removeAt(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzWpi.zzYWz().clear();
        this.zzXb1(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzwE(seriesName, values);
        chartSeries.zzX2u().zzY97(ChartSeriesCollection.zzYjd(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzwE(seriesName, yValues);
        chartSeries.zzX2u().zzY97(ChartSeriesCollection.zzY97(xValues));
        return chartSeries;
    }

    private ChartSeries zzwE(String string, zzm3[] zzm3Array, double[] dArray) {
        if (zzm3Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzm3Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzm3Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzwE(string, dArray);
        chartSeries.zzX2u().zzY97(ChartSeriesCollection.zzwE(zzm3Array));
        if (!this.zzWpi.zzVYY()) {
            this.zzXb1(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzwE(seriesName, zzm3.zzwE(dates), values);
    }

    private void zzXb1(boolean bl) {
        zzIx zzIx2 = zzZXr.zzwE((Object)this.zzWpi, zzIx.class);
        if (zzIx2 != null && zzIx2.zzcH().zzm4()) {
            zzIx2.zzcH().zzY2D().zzYjd(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzWpi.zz4X() != 15) {
            this.zzWpi.zzXos(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzwE(seriesName, yValues);
        chartSeries.zzZGp().zzJq().zzYjd(3, this.zzWpi.zz7E());
        chartSeries.zzX2u().zzY97(ChartSeriesCollection.zzY97(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzY4Z().zzY97(ChartSeriesCollection.zzY97(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzwE(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzWpi);
        chartSeries.setName(string);
        this.zzWPK(chartSeries);
        chartSeries.zzWLQ(this.zzWpi.zzZPZ().zzwb() + 1);
        chartSeries.zzee(this.zzWpi.zzZPZ().zzvH() + 1);
        chartSeries.zzX64().zzY97(ChartSeriesCollection.zzY97(dArray));
        this.zzWpi.zzWxb().zzXPg();
        this.zzWpi.zzYWz().zzYdA(chartSeries);
        return chartSeries;
    }

    private void zzWPK(ChartSeries chartSeries) {
        chartSeries.zzZGp().zzJq().zzYjd(5, new zzUU());
        switch (this.zzWpi.zz4X()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzwE(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzwE(chartSeries, 5);
                ChartSeriesCollection.zzWCg(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzwE(chartSeries, 1);
                ChartSeriesCollection.zzWCg(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzWQE(chartSeries);
            }
        }
    }

    private static void zzWQE(ChartSeries chartSeries) {
        zzUU zzUU2 = new zzUU();
        zzUU2.setOutline(new zzZET());
        zzXiO zzXiO2 = new zzXiO();
        zzXiO2.zzoq(1);
        zzUU2.getOutline().setFill(new zzWoa(zzXiO2));
        zzUU2.getOutline().zzNb(19050.0);
        chartSeries.zzZGp().zzJq().zzYjd(5, zzUU2);
    }

    private static void zzWCg(ChartSeries chartSeries) {
        zzUU zzUU2 = new zzUU();
        zzUU2.setOutline(new zzZET());
        zzUU2.getOutline().setFill(new zzrj());
        zzUU2.getOutline().setEndCap(0);
        zzUU2.getOutline().zzNb(19050.0);
        chartSeries.zzZGp().zzJq().zzYjd(5, zzUU2);
    }

    private static void zzwE(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzX85());
        chartMarker.zzpG().zzYjd(0, n);
        chartSeries.zzZGp().zzJq().zzYjd(4, chartMarker);
    }

    private static zzo zzY97(double[] dArray) {
        int n = 0;
        zzo zzo2 = new zzo(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzo2.zzYH7(new zzVRu(n, d, "General"));
            }
            ++n;
        }
        zzo2.zzX9N(dArray.length);
        return zzo2;
    }

    private static zzo zzwE(zzm3[] zzm3Array) {
        int n = 0;
        zzo zzo2 = new zzo(2);
        zzm3[] zzm3Array2 = zzm3Array;
        int n2 = zzm3Array.length;
        for (int i = 0; i < n2; ++i) {
            zzm3 zzm32 = zzm3Array2[i];
            zzo2.zzYH7(new zzVRu(n++, zzm32.zzYDT(), "m/d/yyyy"));
        }
        zzo2.zzX9N(zzm3Array.length);
        return zzo2;
    }

    private static zzo zzYjd(String[] stringArray) {
        int n = 0;
        zzo zzo2 = new zzo(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzo2.zzYH7(new zzXTx(n++, string));
        }
        zzo2.zzX9N(stringArray.length);
        return zzo2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWpi.zzYWz().getCount();
    }
}

