/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzXo2;
import com.aspose.words.internal.zzZXr;
import com.aspose.words.internal.zzm3;
import com.aspose.words.zzXJq;
import com.aspose.words.zzXlG;
import com.aspose.words.zzYrr;
import com.aspose.words.zzZSN;
import com.aspose.words.zzZlW;
import com.aspose.words.zzep;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzYrr,
zzep {
    private int zzWM1;
    private boolean zzZF3;
    private boolean zzXSr;
    private int zzZPH;
    private int zzXBm = -1;
    private String zzOx = "";
    private String zzWUQ = "";
    private zzm3 zzYRK = zzm3.zzZHx;
    private zzm3 zzwp = zzm3.zzZHx;
    private CommentCollection zzN5;

    Comment(DocumentBase doc, zzZlW runPr) {
        super(doc, runPr);
        this.zzZPH = doc.zzY0s();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzm3.zzZHx);
    }

    private Comment(DocumentBase doc, String author, String initial, zzm3 dateTime) {
        this(doc, new zzZlW());
        this.setAuthor(author);
        this.setInitial(initial);
        zzm3 zzm32 = dateTime;
        Comment comment = this;
        this.zzYRK = zzm32;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzm3.zzwE(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzZPH;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.zzZPH;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.zzZPH = value;
        if (this.getDocument() != null) {
            this.getDocument().zzVQI();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        Comment comment = this;
        return comment.zzXBm;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.zzYTW(value);
    }

    public final String getInitial() {
        return this.zzOx;
    }

    public final void setInitial(String value) {
        zzZXr.zzX2D((Object)value, "Initial");
        this.zzOx = value;
    }

    final zzm3 zzZaw() {
        return this.zzYRK;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzm3.zzWWq(comment.zzYRK);
    }

    final void zzYlK(zzm3 zzm32) {
        this.zzYRK = zzm32;
    }

    public final void setDateTime(Date value) {
        zzm3 zzm32 = zzm3.zzwE(value);
        Comment comment = this;
        this.zzYRK = zzm32;
    }

    final zzm3 zzWBm() {
        return this.zzwp;
    }

    final void zzYys(zzm3 zzm32) {
        this.zzwp = zzm32;
    }

    public final String getAuthor() {
        return this.zzWUQ;
    }

    public final void setAuthor(String value) {
        zzZXr.zzX2D((Object)value, "Author");
        this.zzWUQ = value;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzwE(String string, String string2, zzm3 zzm32, String string3) throws Exception {
        Comment comment = this;
        if (comment.zzXBm != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment2 = new Comment(this.getDocument(), string, string2, zzm32);
        comment2.setIdInternal(zzZSN.zzwE(this.getDocument()));
        comment2.zzYTW(this.zzZPH);
        comment2.setText(string3);
        Comment comment3 = this;
        Comment comment4 = zzZXr.zzwE((Object)this.zzWil(), Comment.class);
        while (comment4 != null) {
            comment = comment4;
            if (comment.zzXBm != this.zzZPH) break;
            comment3 = comment4;
            comment4 = zzZXr.zzwE((Object)comment4.zzWil(), Comment.class);
        }
        this.getParentNode().insertAfter(comment2, comment3);
        zzXJq zzXJq2 = new zzXJq();
        if (zzXJq2.zzX2D(this.getDocument(), this.zzZPH)) {
            this.zzwE(zzXJq2.zzX45(), new CommentRangeStart(this.getDocument(), comment2.getId()));
            this.zzwE(zzXJq2.zzZJp(), new CommentRangeEnd(this.getDocument(), comment2.getId()));
        }
        return comment2;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzwE(author, initial, zzm3.zzwE(dateTime), text);
    }

    private void zzwE(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzXo2.zzwE(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeStart2, (Node)object);
    }

    private void zzwE(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzXo2.zzwE(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzZPH) break;
            object = node;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeEnd2, (Node)object);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzXJq zzXJq2 = new zzXJq();
        if (zzXJq2.zzX2D(this.getDocument(), reply.getId())) {
            zzXJq2.zzX45().remove();
            zzXJq2.zzZJp().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzZIS()) {
            this.removeReply(comment);
        }
    }

    @Override
    final int zzwE(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCommentStart(this);
    }

    @Override
    final int zzX2D(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZCL());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzZCL(), '\u0005', new zzZlW());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        Comment comment;
        block4: {
            block3: {
                if (this.getDocument() == null) break block3;
                comment = this;
                if (comment.zzXBm != -1) break block4;
            }
            return null;
        }
        for (Comment comment2 : this.getDocument().getChildNodes(19, true)) {
            comment = this;
            if (comment2.getId() != comment.zzXBm) continue;
            return comment2;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzN5 == null) {
            this.zzN5 = new CommentCollection(this.getDocument(), this);
        }
        return this.zzN5;
    }

    public final boolean getDone() {
        return this.zzXSr;
    }

    public final void setDone(boolean value) {
        this.zzXSr = value;
    }

    final int zzWm3() {
        return this.zzXBm;
    }

    final void zzYTW(int n) {
        this.zzXBm = n;
        if (this.getDocument() != null) {
            this.getDocument().zzVQI();
        }
    }

    final int zzZpN() {
        return this.zzWM1;
    }

    final void zzUU(int n) {
        this.zzWM1 = n;
    }

    final boolean zzYXQ() {
        return this.zzZF3;
    }

    final void zzX2v(boolean bl) {
        this.zzZF3 = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzXlG getMoveFromRevision() {
        return this.zz4s().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzXlG value) {
        zzXlG zzXlG2 = value;
        zzZlW zzZlW2 = this.zz4s();
        zzZlW2.zzWPK(13, zzXlG2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzXlG getMoveToRevision() {
        return this.zz4s().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzXlG value) {
        zzXlG zzXlG2 = value;
        zzZlW zzZlW2 = this.zz4s();
        zzZlW2.zzWPK(15, zzXlG2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zz4s().remove(13);
        this.zz4s().remove(15);
    }

    final String zzXGz() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXUS(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

