/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZXr;
import com.aspose.words.zzIV;
import com.aspose.words.zzTO;
import com.aspose.words.zzVU0;
import com.aspose.words.zzWF;
import com.aspose.words.zzWp2;
import com.aspose.words.zzXZo;
import com.aspose.words.zzXwq;
import com.aspose.words.zzYMU;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzTO,
Iterable<T> {
    private Node zzXur;
    private Node zzYCe;
    private Node zzCW;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzX2D((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzXYb() {
        return this.zzW35() != null;
    }

    final boolean zzZFg() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzWmX() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzVU0) {
                return true;
            }
            CompositeNode compositeNode = zzZXr.zzwE((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzWmX()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzXur;
    }

    public Node getLastChild() {
        return this.zzYCe;
    }

    final Node zzW35() {
        return zzWp2.zzWDr(this.getFirstChild(), false);
    }

    final Node zzHe() {
        return zzWp2.zzZaj(this.getLastChild(), false);
    }

    final CompositeNode zzY0z() {
        return (CompositeNode)zzWp2.zzWDr(this.getFirstChild(), true);
    }

    final CompositeNode zzJm() {
        return (CompositeNode)zzWp2.zzZaj(this.getLastChild(), true);
    }

    final Node zzWFK() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzWp2.zz6z((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzXey() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzWp2.zz6z((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzwE(boolean bl, zzWF zzWF2) {
        CompositeNode compositeNode = (CompositeNode)super.zzwE(bl, zzWF2);
        ((CompositeNode)super.zzwE(bl, zzWF2)).zzYCe = null;
        compositeNode.zzXur = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWv5(node.zzwE(true, zzWF2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXUS(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzXUS(StringBuilder stringBuilder) {
        this.zz1Q(stringBuilder);
        zzZXr.zzX2D(stringBuilder, this.zzXvL());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzX2D(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzWp2.zzY0K(nodeType);
            Node node2 = node = bl ? this.zzW35() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzWfZ() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXZo.zzgp(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXZo.zzY97(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXwq(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzwE(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzwE(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzX2D(oldChild, false);
    }

    private Node zzX2D(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzwE(node, (Node)this, null, 1);
        if (documentBase.zzXKW() && zzWp2.zzXah(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzwE(nodeChangingArgs);
        }
        if (!bl && zzWp2.zzWlE(node)) {
            zzWp2.zzWQE(node, false);
        }
        Node node2 = this.zzYlK(node);
        if (nodeChangingArgs != null) {
            documentBase.zzX2D(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzYMU.zzVZI(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWv5(Node node) {
        node.getParentNode();
        if (this.zzYCe == null) {
            node.zzXH3(null);
            node.zzWMb(null);
            this.zzXur = node;
        } else {
            node.zzXH3(this.zzYCe);
            node.zzWMb(null);
            this.zzYCe.zzWMb(node);
        }
        this.zzYCe = node;
        node.zzaM(this);
        return node;
    }

    final void zzwE(Node node, Node node2, Node node3) {
        this.zzwE(node, node2, node3, false);
    }

    final void zzwE(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzYbL(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzX2D(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzgp(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzWp2.zz6z(node3.getNodeType())) continue;
            if (zzWp2.zzXFj(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzXvL().length();
    }

    String zzXvL() {
        return "";
    }

    final String zzXMr() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zz1Q(stringBuilder);
        return stringBuilder.toString();
    }

    private void zz1Q(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzXUS(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzwE(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzX2D(visitor));
    }

    abstract int zzwE(DocumentVisitor var1) throws Exception;

    abstract int zzX2D(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzYbL(Node var1);

    final Node zzwE(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzX2v(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzYbL(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzIV(documentBase);
            try {
                compositeNode.zzX2D(node, true);
            }
            finally {
                ((zzIV)object).dispose();
            }
        }
        if ((object = documentBase.zzwE(node, null, (Node)this, 0)) != null) {
            documentBase.zzwE((NodeChangingArgs)object);
        }
        if (this.zzYCe == null) {
            node.zzXH3(null);
            node.zzWMb(null);
            this.zzXur = node;
            this.zzYCe = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzX2D(node, node2);
            } else {
                this.zzgp(node, this.zzXur);
            }
        } else if (node2 != null) {
            this.zzgp(node, node2);
        } else {
            this.zzX2D(node, this.zzYCe);
        }
        node.zzaM(this);
        if (object != null) {
            documentBase.zzX2D((NodeChangingArgs)object);
        }
        if (documentBase.zzXKW()) {
            zzWp2.zzwE(node, compositeNode, node3);
        }
        return node;
    }

    private void zzX2D(Node node, Node node2) {
        Node node3 = node2.zzYu8();
        node.zzXH3(node2);
        node.zzWMb(node3);
        node2.zzWMb(node);
        if (node3 == null) {
            this.zzYCe = node;
            return;
        }
        node3.zzXH3(node);
    }

    private void zzgp(Node node, Node node2) {
        Node node3 = node2.zzZIu();
        node.zzXH3(node3);
        node.zzWMb(node2);
        node2.zzXH3(node);
        if (node3 == null) {
            this.zzXur = node;
            return;
        }
        node3.zzWMb(node);
    }

    private Node zzYlK(Node node) {
        if (node == this.zzXur) {
            if (this.zzXur == this.zzYCe) {
                this.zzXur = null;
                this.zzYCe = null;
            } else {
                this.zzXur = node.zzYu8();
                this.zzXur.zzXH3(null);
            }
        } else {
            Node node2 = node.zzZIu();
            Node node3 = node.zzYu8();
            node2.zzWMb(node3);
            if (node3 == null) {
                this.zzYCe = node2;
            } else {
                node3.zzXH3(node2);
            }
        }
        node.zzWMb(null);
        node.zzXH3(null);
        node.zzaM(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzCW = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzCW;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

