/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzWF4;
import com.aspose.words.internal.zzWXz;
import com.aspose.words.internal.zzWc;
import com.aspose.words.internal.zzWkK;
import com.aspose.words.internal.zzWto;
import com.aspose.words.internal.zzX52;
import com.aspose.words.internal.zzXl7;
import com.aspose.words.internal.zzXsG;
import com.aspose.words.internal.zzXsl;
import com.aspose.words.internal.zzZQx;
import com.aspose.words.internal.zzZXr;
import com.aspose.words.internal.zzwV;
import com.aspose.words.zzVYp;
import com.aspose.words.zzW78;
import com.aspose.words.zzWy1;
import com.aspose.words.zzXA4;
import com.aspose.words.zzXhg;
import com.aspose.words.zzXpE;
import com.aspose.words.zzXvH;
import com.aspose.words.zzYJV;
import com.aspose.words.zzZk2;
import com.aspose.words.zzZvX;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzwE(zzWto zzWto2, zzWto zzWto3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZXr.zzX2D((Object)zzWto2, "srcStream");
        zzZXr.zzX2D((Object)zzWto3, "dstStream");
        zzZXr.zzX2D((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzX2D(zzWto2, zzWto3, certificateHolder, signOptions);
        zzWto3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzwE(zzWto.zzX2D(srcStream), (zzWto)zzWto.zzgp(dstStream), certHolder, signOptions);
    }

    private static void zzX2D(zzWto zzWto2, zzWto zzWto3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzgp(digitalSignature);
        }
        if (zzXhg.zzXVp(zzWto2)) {
            DigitalSignatureUtil.zzwE(zzWto2, zzWto3, digitalSignature, true);
            return;
        }
        zzXhg zzXhg2 = new zzXhg();
        zzWto zzWto4 = zzWto2;
        zzXhg zzXhg3 = zzXhg2;
        FileFormatInfo fileFormatInfo = zzXhg2.zzX2D(zzWto4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWF4 zzWF42 = new zzWF4(zzWto2);
                int n = fileFormatInfo.zzZFB() == 1 ? 1 : 2;
                zzWy1.zzwE(zzWF42, digitalSignature, n);
                zzWto3.zzF7(0L);
                zzWF42.zzYjd(zzWto3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzwE(fileFormatInfo.zzj6(), zzWto3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzwE(zzWto2, zzWto3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzwE(zzWto2, zzWto3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZXr.zzgp(srcFileName, "srcFileName");
        zzZXr.zzgp(dstFileName, "dstFileName");
        try (zzXsG zzXsG2 = zzZXr.zzX2D(srcFileName, 3, 1);){
            try (zzXsG zzXsG3 = zzZXr.zzX2D(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzwE((zzWto)zzXsG2, (zzWto)zzXsG3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzXl7 zzXl72 = zzWto.zzgp(dstStream);
        zzWto zzWto2 = zzWto.zzX2D(srcStream);
        DigitalSignatureUtil.zzwE(zzWto2, (zzWto)zzXl72, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzXsG zzXsG2 = zzZXr.zzX2D(srcFileName, 3, 1);){
            try (zzXsG zzXsG3 = zzZXr.zzX2D(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzY97(zzXsG2, zzXsG3);
            }
            return;
        }
    }

    private static void zzY97(zzWto zzWto2, zzWto zzWto3) throws Exception {
        zzXhg zzXhg2 = new zzXhg();
        zzWto zzWto4 = zzWto2;
        zzXhg zzXhg3 = zzXhg2;
        FileFormatInfo fileFormatInfo = zzXhg2.zzX2D(zzWto4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWF4 zzWF42 = new zzWF4(zzWto2);
                zzWF42.zzPT().zzYRK("_xmlsignatures");
                zzWF42.zzPT().zzYRK("_signatures");
                zzWto3.zzWv5(0L);
                zzWF42.zzYjd(zzWto3);
                zzWto zzWto5 = zzWto3;
                zzWto5.zzF7(zzWto5.zzYil());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzX52 zzX522 = new zzX52(zzWto2);
                zzWXz zzWXz2 = zzX522.zzwE(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzWXz2 != null) {
                    for (zzWkK zzWkK2 : zzWXz2.zz79()) {
                        String string = zzWXz2.zzwE(zzWkK2);
                        zzX522.zzZ0A().remove(string);
                    }
                    zzX522.zzZ0A().remove(zzWXz2.getName());
                    zzWkK zzWkK3 = zzX522.zz79().zzW2E("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzX522.zz79().remove(zzWkK3.getId());
                    zzX522.zzVTP();
                }
                zzWto3.zzWv5(0L);
                zzX522.zzYjd(zzWto3);
                zzWto zzWto6 = zzWto3;
                zzWto6.zzF7(zzWto6.zzYil());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzY97(zzWto.zzX2D(srcStream), zzWto.zzgp(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzXsG zzXsG2 = zzZXr.zzX2D(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzl1(zzXsG2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzl1(zzWto zzWto2) throws Exception {
        if (zzXhg.zzXVp(zzWto2)) {
            return DigitalSignatureUtil.zzYeL(zzWto2);
        }
        zzXhg zzXhg2 = new zzXhg();
        zzWto zzWto3 = zzWto2;
        zzXhg zzXhg3 = zzXhg2;
        FileFormatInfo fileFormatInfo = zzXhg2.zzX2D(zzWto3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzWto2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzl1(zzWto.zzX2D(stream));
    }

    static zzZQx zzwE(zzWF4 zzWF42, String string) throws Exception {
        zzW78 zzW782 = new zzW78(zzWF42);
        if (zzW782.zzWQM()) {
            zzZQx zzZQx2 = zzW782.zzWsn(string);
            return zzZQx2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzX52(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzWc.zzX2D("Unexpected digest algorithm: {0}.", n));
    }

    static String zzZf(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzX52(n);
    }

    private static void zzwE(zzWto zzWto2, zzWto zzWto3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzX52 zzX522 = new zzX52(zzWto2);
        zzXpE zzXpE2 = bl ? new zzZk2(zzX522) : new zzXA4(zzX522);
        zzXpE2.zzX2D(digitalSignature);
        zzWto3.zzF7(0L);
        zzX522.zzYjd(zzWto3);
    }

    private static void zzwE(zzWto zzWto2, zzWto zzWto3, DigitalSignature digitalSignature) throws Exception {
        zzVYp zzVYp2 = new zzVYp(zzWto2);
        zzZvX zzZvX2 = new zzZvX(zzVYp2);
        zzZvX2.zzX2D(digitalSignature);
        zzWto3.zzF7(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzWto zzWto4 = zzWto3;
        zzVYp zzVYp3 = zzVYp2;
        zzVYp3.zzwE(zzWto4, string, null);
    }

    private static void zzwE(zzWF4 zzWF42, zzWto zzWto2, DigitalSignature digitalSignature, String string) throws Exception {
        zzZQx zzZQx2 = DigitalSignatureUtil.zzwE(zzWF42, string);
        zzZQx zzZQx3 = new zzZQx();
        DigitalSignatureUtil.zzwE((zzWto)zzZQx2, (zzWto)zzZQx3, digitalSignature, false);
        zzWF4 zzWF43 = zzW78.zzgp(zzZQx3, string);
        zzWF43.zzYjd(zzWto2);
    }

    private static DigitalSignatureCollection zzYeL(zzWto zzWto2) throws Exception {
        zzWto2.zzWv5(0L);
        zzX52 zzX522 = new zzX52(zzWto2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzWXz zzWXz2 = zzX522.zzwE(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzWXz2 != null) {
            for (zzWkK zzWkK2 : zzWXz2.zz79()) {
                String string = zzWXz2.zzwE(zzWkK2);
                zzWXz zzWXz3 = zzX522.zzYFU(string);
                zzWXz zzWXz4 = zzX522.zzwE(zzWXz3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzXsl zzXsl2 = zzwV.zzWn9(zzWXz4.zzY5b().zzZa7());
                zzXvH.zzwE(zzWXz3.zzW1M(), zzXsl2, new zzYJV(zzX522), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

