/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz1I;
import com.aspose.words.internal.zzW3P;
import com.aspose.words.internal.zzWOX;
import com.aspose.words.internal.zzWc;
import com.aspose.words.internal.zzWto;
import com.aspose.words.internal.zzXFI;
import com.aspose.words.internal.zzY8p;
import com.aspose.words.internal.zzYCi;
import com.aspose.words.internal.zzYIX;
import com.aspose.words.internal.zzYOe;
import com.aspose.words.internal.zzYUC;
import com.aspose.words.internal.zzYW9;
import com.aspose.words.internal.zzYXY;
import com.aspose.words.internal.zzYwu;
import com.aspose.words.internal.zzZQx;
import com.aspose.words.internal.zzZXr;
import com.aspose.words.internal.zzZn0;
import com.aspose.words.internal.zzZoM;
import com.aspose.words.zz3C;
import com.aspose.words.zz4o;
import com.aspose.words.zzIV;
import com.aspose.words.zzSe;
import com.aspose.words.zzW1R;
import com.aspose.words.zzW1v;
import com.aspose.words.zzW8b;
import com.aspose.words.zzW9t;
import com.aspose.words.zzWEM;
import com.aspose.words.zzWOP;
import com.aspose.words.zzWUP;
import com.aspose.words.zzWaH;
import com.aspose.words.zzWp2;
import com.aspose.words.zzWwS;
import com.aspose.words.zzXFG;
import com.aspose.words.zzXVp;
import com.aspose.words.zzXlI;
import com.aspose.words.zzXp7;
import com.aspose.words.zzXr0;
import com.aspose.words.zzXt7;
import com.aspose.words.zzXyQ;
import com.aspose.words.zzY0C;
import com.aspose.words.zzY3e;
import com.aspose.words.zzY9C;
import com.aspose.words.zzYAA;
import com.aspose.words.zzYDO;
import com.aspose.words.zzYJM;
import com.aspose.words.zzYRc;
import com.aspose.words.zzYb5;
import com.aspose.words.zzYiC;
import com.aspose.words.zzYl6;
import com.aspose.words.zzYxK;
import com.aspose.words.zzZ3y;
import com.aspose.words.zzZ5L;
import com.aspose.words.zzZJx;
import com.aspose.words.zzZX8;
import com.aspose.words.zzZdn;
import com.aspose.words.zzZiw;
import com.aspose.words.zzZlW;
import com.aspose.words.zzZoa;
import com.aspose.words.zzZt4;
import com.aspose.words.zzZu2;
import com.aspose.words.zzZw8;
import com.aspose.words.zzun;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWOP,
zzXt7,
zzY0C,
zzun {
    private Document zzWSv;
    private Node zzko;
    private Node zzra;
    private zzZlW zzWOs;
    private Font zzdE;
    private zzXFI<zzZlW> zzYZE;
    private zzXFI<zzZ3y> zzZEh;
    private zzXFI<zzwE> zzZj7;
    private zzZoa zzX3U = zzZoa.zzXLc();
    private zzY3e zzXiD = new zzY3e();
    private zzZ3y zzYub;
    private RowFormat zzWIg;
    private CellFormat zzWix;
    private ParagraphFormat zzXlf;
    private zzXFI<zzWaH> zzVUc;
    private int zzY9j = 0;
    private int zzWR6 = -1;
    private int zzXXE;
    private boolean zzGq;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzWPK(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzWPK(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzWPK(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzwE(documentBuilder.getCurrentSection(), zzZt4.zzXUw(headerFooterType), 0, 0);
    }

    private void zzWPK(int n, int n2, int n3, int n4) {
        this.zzWSv.ensureMinimum();
        Section section = (Section)this.zzWSv.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzwE(section, 1, n3, n4);
    }

    private void zzwE(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZt4.zzZxD(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzWSv, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzWSv));
            }
        }
        this.zzwE(story, n2, n3);
    }

    private void zzwE(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzwE((CompositeNode)paragraph2, n3);
    }

    final void zzwE(Paragraph paragraph, int n) {
        this.zzwE((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzZxr().zzuK() ? zzWwS.zzYH7(this.zzWSv, fieldName) : zzWwS.zzYbL(this.zzZxr(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzwE(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzwE(field, isAfter, false);
    }

    private boolean zzwE(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZu2 zzZu22 = field.getFormat().zzYr9();
        Inline inline = zzZu22.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzwE(inline.zz4s(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzXVp.zzwE(this.zzWSv, bookmarkName) : zzXVp.zzX2D(this.zzWSv, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzW6H() == 6) {
            this.zzwE((Paragraph)node.zzYUE(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzWp2.zzz2(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzwE(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzwE(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzX2D(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzwE(structuredDocumentTag);
            return;
        }
        this.zzgp(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzWj0(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzwE(cell, characterIndex);
    }

    private void zzwE(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzW6H() == 6) {
            this.zzZJx(node);
        } else {
            Node node2 = node;
            if (zzWp2.zz6z(node2.getNodeType())) {
                Paragraph paragraph = zzWp2.zzz2(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzZJx(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzW6H() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzZJx(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzXXE = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzZt0();
            return;
        }
        if (!this.zzW3i()) {
            this.zzZt0();
        }
    }

    private boolean zzW3i() {
        Node node = this.zzZxr();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzZxr().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzwE(((StructuredDocumentTag)documentBuilder.zzZxr().getParentNode()).zzYDg(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzZxr(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzwE(inline.zz4s(), true);
            return true;
        }
        return false;
    }

    private void zzZt0() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzwE(documentBuilder.getCurrentParagraph().zzVZz(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzWj0(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzYdP() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzZxr().zzX2v(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzXcd();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzwE((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzYys(text, false);
    }

    public void writeln(String text) {
        this.zzYys(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        this.zzWk9();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzIV zzIV2 = new zzIV(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzWSv, this.zzWB9(), this.zzW18());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzX2D(this.zzZxr(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzIV2.dispose();
        }
        if (this.getDocument().zzXKW()) {
            zzWp2.zzgp((zzYl6)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzZKF());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzZBB() {
        zzZlW zzZlW2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzWk9();
        Node node = this.zzZxr();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzWaX(false);
        } else {
            run2 = run = (Run)node.zzWee(21);
        }
        if (run2 == null && zzZXr.zzXLp(node, paragraph.zzZNj())) {
            run = paragraph.zzZNj();
        }
        if (run != null) {
            cloneable = run.zz4s();
            zzZlW2 = (zzZlW)((zzZJx)cloneable).zzWVE();
        } else {
            cloneable = paragraph.zzVZz();
            zzZlW2 = (zzZlW)((zzZJx)cloneable).zzWVE();
        }
        zzZlW zzZlW3 = zzZlW2;
        Paragraph paragraph2 = new Paragraph(this.zzWSv, this.zzWB9(), zzZlW3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzIV zzIV2 = new zzIV(this.zzWSv);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzX2D(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzIV2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzWUP.zzYH7(this);
    }

    public void insertBreak(int breakType) {
        this.zzYva(breakType, true);
    }

    final void zzYva(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzW0y(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzZYO(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzWUG())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzW0y(bl)) {
                        this.zzZYO(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzW0y(bl)) {
                        this.zzVUz(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzW0y(bl)) {
                        this.zzVUz(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzW0y(bl)) {
                        this.zzVUz(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzW0y(bl)) {
                        this.zzVUz(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzW0y(bl)) {
                        this.zzVUz(4);
                    }
                    return;
                }
                case 8: {
                    this.zzZYO(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzYXY.zzVPx(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzWc.zzX2D("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzWk9();
        return zzWp2.zzwE(fieldType, updateField, this.zzW18(), this.zzXNx(), this.zzX84(), this.zzX84() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzWk9();
        return zzWp2.zzwE(fieldCode, this.zzW18(), this.zzXNx(), this.zzX84(), this.zzX84() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzWk9();
        return zzWp2.zzwE(fieldCode, fieldValue, this.zzW18(), this.zzXNx(), this.zzX84(), this.zzX84() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZXr.zzX2D((Object)displayText, "displayText");
        zzZXr.zzX2D((Object)urlOrBookmark, "hrefOrBookmark");
        zzWEM zzWEM2 = this.zzX2D(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzWEM2.zzX2D(documentBuilder.zzX8E(88, true));
        return zzWp2.zzwE(zzWEM2.getStart(), zzWEM2.getSeparator(), zzWEM2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzRk(70);
        if (zzYXY.zzVPx(name)) {
            this.startBookmark(name);
        }
        this.zz7j(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzmH(70);
        String string = zzYXY.zzVPx(fieldValue) ? fieldValue : FormField.zzXcs;
        Run run = new Run(this.zzWSv, string, this.zzW18());
        this.insertNode(run);
        Node node = this.zzX8E(70, true);
        if (zzYXY.zzVPx(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzW1R(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzwE((Paragraph)node.zzYUE(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzRk(71);
        if (zzYXY.zzVPx(name)) {
            this.startBookmark(name);
        }
        this.zz7j(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzX8E(71, false);
        if (zzYXY.zzVPx(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzW1R(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzRk(83);
        if (zzYXY.zzVPx(name)) {
            this.startBookmark(name);
        }
        this.zz7j(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzX8E(83, false);
        if (zzYXY.zzVPx(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzW1R(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzWSv, footnoteType, !zzYXY.zzVPx(referenceMark), referenceMark, this.zzW18());
        Style style = this.getDocument().getStyles().zzY8J(zzWp2.zzWpk(footnoteType));
        footnote.zz4s().set(50, style.zzXhR());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzWSv);
        Style style2 = this.getDocument().getStyles().zzY8J(zzWp2.zz4m(footnoteType));
        paragraph.zzYA1().set(1000, style2.zzXhR());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzWSv, '\u0002', new zzZlW()) : new Run(this.zzWSv, footnote.getReferenceMark(), new zzZlW());
        inline.zz4s().set(50, style.zzXhR());
        paragraph.appendChild(inline);
        if (zzYXY.zzVPx(footnoteText)) {
            Node node = this.zzZxr();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzZJx(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzX2X(zzWto zzWto2) throws Exception {
        return this.zzwE(zzWto2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzX2X(zzWto.zzX2D(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzwE(zzWto zzWto2, double d, double d2) throws Exception {
        return this.zzwE(zzWto2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzwE(zzWto.zzX2D(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzZQx zzZQx2 = new zzZQx();){
            zzYOe.zzwE(image, zzZQx2);
            Shape shape = this.zzwE(zzZQx2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZXr.zzgp(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzY8p.zzYkN(fileName);
        try {
            Shape shape = this.zzwE((zzWto)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzWto)object).close();
            }
        }
    }

    private Shape zzwE(zzWto zzWto2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzWto2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZXr.zzXFj(zzWto2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzwE(zzWto.zzX2D(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzwE(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzwE(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzYwu.zzZKk(object)) {
            object4 = new zzYOe((byte[])object);
            bl2 = true;
            ((zzZoM)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzWSv.getCompatibilityOptions().getMswVersion() > 12 || this.zzWSv.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzWSv, 0);
            object3 = new zzXlI();
            ((zzXFG)object3).zzwE(zzYiC.zzZcT("rect"));
            ((zzXlI)object3).zzwE(new zzZw8());
            ((zzXlI)object3).zzWzv().zzWDk().zzgp(this.zzWSv);
            object2 = new zz3C();
            ((zzXr0)object2).zzX2D(new zzYAA(this.zzWSv.zzW8o(), ""));
            ((zzXr0)object2).zzwE(new zzYb5());
            ((zzW9t)object3).zzwE((zzXr0)object2);
            shape.zzWK9(75);
            shape.zzXFj((zzW9t)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzWSv, 75);
        }
        if (zzYwu.zzWKZ(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzwE((byte[])object, new zzW8b(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzW8b(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzYwu.zzXah((byte[])object2));
                this.zzwE((zzXlI)shape.zzX0E(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXlI)shape.zzX0E()).zzWzv().zzWDk().zzYvs((byte[])object);
            object3 = zzYwu.zzXo2(object);
            object4 = new zzW8b(((zzYW9)object3).getWidthPoints(), ((zzYW9)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzwE(this.zzW18());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzYwu.zzl1(object)) {
            d5 = DocumentBuilder.zzwE(shape, object);
        }
        shape.zzwE(d3, d4, (zzW8b)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzwE(Shape shape, byte[] byArray) throws Exception {
        int n = zzYwu.zzWRw(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzWp2.zzW9Y(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzWp2.zzlf(n);
        return d;
    }

    private void zzwE(zzXlI zzXlI2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXlI2.zzWzv().zzWDk().getExtensions();
        try (zzZQx zzZQx2 = new zzZQx(byArray);){
            object = zzWp2.zzwE(zzZQx2, this.zzWSv);
            ((zzXyQ)object).zzZai(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzXyQ)object).zzWRC();
            byArray2 = ((zzXyQ)object).zzWLQ(true);
        }
        zzXlI2.zzWzv().zzWDk().setExtensions(new zzW3P<zzZiw>());
        object = zzZiw.zzwE(byArray2, this.zzWSv);
        zzXlI2.zzWzv().zzWDk().getExtensions().zzXDv(((zzZiw)object).getUri(), (zzZiw)object);
    }

    private Shape zzwE(zzWto zzWto2, String string, boolean bl, zzWto zzWto3) throws Exception {
        zzYRc zzYRc2 = zzYRc.zzWMl(string);
        Shape shape = this.zzwE(zzWto3, bl, zzYRc2, null);
        zzZ5L zzZ5L2 = zzW1v.zzwE(zzWto2, string, bl);
        return DocumentBuilder.zzwE(null, false, shape, zzYRc2.zzXPk, zzZ5L2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzwE(zzWto.zzX2D(stream), progId, asIcon, zzWto.zzX2D(presentation));
    }

    private Shape zzwE(String string, boolean bl, boolean bl2, zzWto zzWto2) throws Exception {
        zzYRc zzYRc2 = zzYRc.zzXm6(zzZn0.zzW5Z(string));
        return this.zzwE(string, bl, bl2, zzWto2, zzYRc2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzwE(fileName, isLinked, asIcon, zzWto.zzX2D(presentation));
    }

    private Shape zzwE(String string, String string2, boolean bl, boolean bl2, zzWto zzWto2) throws Exception {
        zzYRc zzYRc2 = zzYRc.zzWMl(string2);
        return this.zzwE(string, bl, bl2, zzWto2, zzYRc2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzwE(fileName, progId, isLinked, asIcon, zzWto.zzX2D(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYRc zzYRc2 = zzYRc.zzXm6(zzZn0.zzW5Z(fileName));
        return this.zzwE(fileName, isLinked, iconFile, iconCaption, zzYRc2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYRc zzYRc2 = zzYRc.zzWMl(progId);
        return this.zzwE(fileName, isLinked, iconFile, iconCaption, zzYRc2);
    }

    private Shape zzwE(zzWto zzWto2, String string, String string2, String string3) throws Exception {
        zzYRc zzYRc2 = zzYRc.zzWMl(string);
        Shape shape = this.zzwE(string2, string3, zzYRc2);
        zzZ5L zzZ5L2 = zzW1v.zzwE(zzWto2, string, true);
        return DocumentBuilder.zzwE(null, false, shape, zzYRc2.zzXPk, zzZ5L2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzwE(zzWto.zzX2D(stream), progId, iconFile, iconCaption);
    }

    final Shape zzwE(zzYDO zzYDO2, zzWto zzWto2) throws Exception {
        Shape shape = this.zzWK(zzWto2);
        shape.zzWK9(201);
        shape.getOleFormat().zzX2D(zzYDO2.zzWnS());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzWk9();
        if (this.zzYlt()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzZu3(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZX8 zzZX82 = zzWp2.zzwE(html, options, this);
        zzZX82.zzVWB();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzWk9();
        return zzWp2.zzwE(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzWk9();
        return zzWp2.zzwE(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzSe zzSe2 = new zzSe();
        return zzSe2.zzwE(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYJM(this).zzwE(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYJM(this).zzwE(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzWSv, 75);
        shape.zzwE(this.zzW18());
        shape.zzXcX(true);
        shape.getSignatureLine().zzwE(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzVZI(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzPG(this.zzWSv);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzYlt() {
        boolean bl = false;
        if (this.zzZxr().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzZxr().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzZu3(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzWk9();
        if (this.zzYdP() == null) {
            this.startTable();
        }
        if (this.zzYdP().zzXLT() == 1) {
            this.zzYdP().zzWr3();
        }
        if (this.zzYdP().zzXLT() == 3) {
            this.zzYdP().zzYha();
        }
        return this.zzYdP().zzZe1();
    }

    public Table startTable() {
        this.zzVUc.push(new zzWaH(this));
        return this.zzYdP().startTable();
    }

    public Table endTable() {
        if (this.zzYdP() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzYdP().endTable();
        this.zzVUc.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzYdP() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzYdP().endRow();
        if (this.zzdE != null && this.zzdE.getHidden()) {
            row.zzXJr().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWSv, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWSv, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZIn();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWSv, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzX34();
        bookmarkStart.zzZ4m(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZIn();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzX34();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWSv, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzYlX(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzWSv);
        this.zzWR6 = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzWR6 == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWSv, this.zzWR6);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWSv, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZXr.zzX2D((Object)importFormatOptions, "ImportFormatOptions");
        this.zzWk9();
        return zzY9C.zzwE(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzWSv;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzWSv) {
            return;
        }
        this.zzWSv = value;
        this.zzZJx(null);
        this.zzWOs = new zzZlW();
        this.zzYZE = null;
        this.zzZEh = null;
        this.zzdE = null;
        this.zzVUc = new zzXFI();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzdE == null) {
            DocumentBuilder documentBuilder = this;
            this.zzdE = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzdE;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzXlf == null) {
            DocumentBuilder documentBuilder = this;
            this.zzXlf = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzXlf;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzWIg == null) {
            this.zzWIg = new RowFormat(this);
        }
        return this.zzWIg;
    }

    public CellFormat getCellFormat() {
        if (this.zzWix == null) {
            this.zzWix = new CellFormat(this);
        }
        return this.zzWix;
    }

    final void zzXsa(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzZlW zzZlW2;
        if (this.getCurrentParagraph() != null) {
            zzZlW zzZlW3 = this.getCurrentParagraph().zzVZz();
            zzZlW2 = (zzZlW)zzZlW3.zzWVE();
        } else {
            zzZlW2 = this.zzW18();
        }
        zzZlW zzZlW4 = zzZlW2;
        this.zzXM6().push(new zzwE(this.zzW18(), zzZlW4));
    }

    public void popFont() {
        zzXFI<zzwE> zzXFI2 = this.zzXM6();
        if (zzXFI2.size() > 0) {
            zzwE zzwE2 = (zzwE)this.zzXM6().pop();
            this.zzwE(zzwE2.zz4s(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzZMX(zzwE2.zzY5v());
            }
        }
    }

    final void zzYHN() {
        this.zzYCs().push(this.zzW18());
    }

    final void zzW8Z() {
        zzXFI<zzZlW> zzXFI2 = this.zzYCs();
        if (zzXFI2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzwE((zzZlW)documentBuilder.zzYCs().pop(), false);
        }
    }

    final void zzm7() {
        this.zzYPS().push(this.zzWB9());
    }

    final void zzW9D() {
        zzXFI<zzZ3y> zzXFI2 = this.zzYPS();
        if (zzXFI2.size() > 0) {
            zzZ3y zzZ3y2 = (zzZ3y)this.zzYPS().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzwE(zzZ3y2);
            }
        }
    }

    final zzWEM zzX2D(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzRk(88);
        zzYxK zzYxK2 = new zzYxK();
        zzYxK2.setTarget(string2);
        zzYxK2.setScreenTip(string3);
        if (bl) {
            zzYxK2.setSubAddress(string);
        } else {
            zzYxK2.setAddress(zz1I.zzWJq(string));
            zzYxK2.setSubAddress(zz1I.zzZ9M(string));
        }
        this.zz7j(zzYxK2.zzEW());
        FieldSeparator fieldSeparator = this.zzmH(88);
        return new zzWEM(fieldStart, fieldSeparator, null);
    }

    final zzWEM zzWQE(String string, String string2, String string3) {
        boolean bl = zz1I.zzXov(string);
        String string4 = bl ? zz1I.zzZ9M(string) : string;
        return this.zzX2D(string4, bl, string2, string3);
    }

    final FieldEnd zzSi() {
        return this.zzX8E(88, true);
    }

    final zzZlW zzW18() {
        zzZlW zzZlW2 = this.zzWOs;
        return (zzZlW)zzZlW2.zzWVE();
    }

    final zzZ3y zzWB9() {
        zzZ3y zzZ3y2 = this.zzYA1();
        return (zzZ3y)zzZ3y2.zzWVE();
    }

    final zzZoa zzWaM() {
        zzZoa zzZoa2 = this.zzXJr();
        return (zzZoa)zzZoa2.zzWVE();
    }

    final zzY3e zzZaJ() {
        zzY3e zzY3e2 = this.zzYtA();
        return (zzY3e)zzY3e2.zzWVE();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzZxr(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzZxr().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzGq && this.zzZxr().getNodeType() == 28;
    }

    private void zzYys(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzZxr()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzZt4.zzX7r(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzZYy(string2.substring(n4, n4 + n2));
                }
                switch (this.zzY9j) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZYO(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzZYy(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzWk9();
        if (this.zzYdP() != null && this.zzYdP().zzXLT() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzZxr().getParentNode().insertBefore(node, this.zzZxr());
    }

    final void zzNH(int n) {
        this.zzW0y(true);
        this.zzVUz(n);
    }

    private void zzVUz(int n) {
        this.insertParagraph();
        zzIV zzIV2 = new zzIV(this.getDocument());
        try {
            zz4o zz4o2 = this.getCurrentSection().zzxY();
            zz4o zz4o3 = (zz4o)zz4o2.zzWVE();
            Section section = new Section(this.zzWSv, zz4o3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzWSv));
            this.zzWSv.insertAfter(section, this.getCurrentSection());
            section.getBody().zzX2D(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzIV2.dispose();
        }
    }

    final FieldStart zzRk(int n) {
        this.zzWk9();
        return zzWp2.zzwE(n, this.zzW18(), this.zzXNx(), this.zzX84(), this.zzX84() == null);
    }

    final Run zz7j(String string) {
        return zzWp2.zzX2D(string, this.zzW18(), this.zzXNx(), this.zzX84(), this.zzX84() == null);
    }

    final FieldEnd zzX8E(int n, boolean bl) {
        return zzWp2.zzX2D(n, bl, this.zzW18(), this.zzXNx(), this.zzX84(), this.zzX84() == null);
    }

    final FieldSeparator zzmH(int n) {
        return zzWp2.zzX2D(n, this.zzW18(), this.zzXNx(), this.zzX84(), this.zzX84() == null);
    }

    private FormField zzW1R(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzWSv, new zzZdn(), this.zzW18());
        CompositeNode compositeNode = node == null ? this.zzXNx() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzW0y(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzYdP() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzWj0(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzZYy(String string) {
        if (this.zzZFf(string)) {
            zzYCi zzYCi2 = new zzYCi(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYUC zzYUC2 : zzYCi2.zzvA(this.getParagraphFormat().getBidi())) {
                zzW1R zzW1R2 = zzW1R.zz4g(zzYUC2.zzW8y());
                zzZlW zzZlW2 = this.zzW18();
                zzZlW2.zzWPK(265, zzW1R2);
                if (zzYUC2.zzwa()) {
                    zzZlW2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzWSv, zzYUC2.getText(), zzZlW2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZYO(string);
    }

    private boolean zzZFf(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzYIX.zzXHI(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzwE(zzZlW zzZlW2, boolean bl) {
        zzZlW zzZlW3;
        if (bl) {
            zzZlW zzZlW4 = zzZlW2;
            zzZlW3 = (zzZlW)zzZlW4.zzWVE();
        } else {
            zzZlW3 = zzZlW2;
        }
        this.zzWOs = zzZlW3;
    }

    final void zzYON() {
        this.zzWOs.clear();
    }

    final void zzOu() {
        if (this.zzZIn() != null) {
            zzY3e zzY3e2;
            zzY3e zzY3e3 = zzY3e2 = this.zzZIn().zzYtA();
            this.zzXiD = (zzY3e)zzY3e3.zzWVE();
            zzY3e2.zzX2D(this.zzXiD);
        }
    }

    private Shape zzwE(String string, boolean bl, boolean bl2, zzWto zzWto2, zzYRc zzYRc2) throws Exception {
        if (zzYRc2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzwE(zzWto2, bl2, zzYRc2, string);
        zzZ5L zzZ5L2 = zzW1v.zzwE(string, bl, bl2, zzYRc2);
        return DocumentBuilder.zzwE(string, bl, shape, zzYRc2.zzXPk, zzZ5L2);
    }

    private Shape zzwE(String string, boolean bl, String string2, String string3, zzYRc zzYRc2) throws Exception {
        if (zzYRc2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzZn0.zzW4(string);
        }
        Shape shape = string2 != null ? this.zzXo2(string2, string3) : this.zzwE(null, string3, zzYRc2);
        zzZ5L zzZ5L2 = zzW1v.zzwE(string, bl, true, zzYRc2);
        return DocumentBuilder.zzwE(string, bl, shape, zzYRc2.zzXPk, zzZ5L2);
    }

    private static Shape zzwE(String string, boolean bl, Shape shape, String string2, zzZ5L zzZ5L2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzWK9(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzX2D(zzZ5L2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzwE(zzWto zzWto2, boolean bl, zzYRc zzYRc2, String string) throws Exception {
        if (zzYRc2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzWto2 != null) {
            return this.zzWK(zzWto2);
        }
        if (!bl) {
            return this.zzWOj(zzW1v.zzZhO().get("normal"));
        }
        String string2 = string != null ? zzZn0.zzW4(string) : zzW1v.zz6z(zzYRc2.zzWcc);
        return this.zzwE(zzYRc2, string2);
    }

    private Shape zzwE(String string, String string2, zzYRc zzYRc2) throws Exception {
        if (zzYRc2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzW1v.zz6z(zzYRc2.zzWcc);
        }
        if (string != null) {
            return this.zzXo2(string, string2);
        }
        return this.zzwE(zzYRc2, string2);
    }

    private Shape zzwE(zzYRc zzYRc2, String string) throws Exception {
        if (zzYRc2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzW1v.zzWyw(zzYRc2.zzWcc);
        zzWOX zzWOX2 = new zzWOX(byArray, null, string, this.getDocument().zzZzS());
        return this.zzWOj(zzWOX2.zzhC());
    }

    private Shape zzXo2(String string, String string2) throws Exception {
        zzWOX zzWOX2 = new zzWOX(string, string2, this.getDocument().zzZzS());
        return this.zzWOj(zzWOX2.zzhC());
    }

    private Shape zzWK(zzWto zzWto2) throws Exception {
        byte[] byArray = zzZXr.zzXFj(zzWto2);
        return this.zzWOj(byArray);
    }

    private Shape zzWOj(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzWSv, 1);
        shape.zzWK9(75);
        shape.zzwE(this.zzW18());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzVZI(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzwE(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzX2D(compositeNode, n);
            return;
        }
        this.zzgp(compositeNode, n);
    }

    private void zzX2D(CompositeNode compositeNode, int n) {
        zzXp7 zzXp72 = zzXp7.zzZf(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzXp72.zzwE(null, true, true, true, false, true);
            node = zzXp72.getNode();
            if (zzXp72.zzYXW() && (!node.isComposite() || node.zzW6H() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzXvL().length() : node.getTextLength();
            if (!zzXp72.zzYXW() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzXp72.zzYXW() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzwE((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzwE(null, node);
            this.zzXXE = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzwE(StructuredDocumentTag structuredDocumentTag) {
        this.zzZJx(structuredDocumentTag);
        this.zzGq = true;
        this.zzXXE = 0;
        zzZlW zzZlW2 = structuredDocumentTag.zzYDg();
        switch (structuredDocumentTag.zzW6H()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzXey(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzZlW2 = ((Inline)node).zz4s();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzZlW2 = paragraph.zzVZz();
                break;
            }
            default: {
                return;
            }
        }
        this.zzwE(zzZlW2, true);
    }

    private void zzgp(CompositeNode compositeNode, int n) {
        zzXp7 zzXp72 = zzXp7.zzZs(compositeNode);
        while (zzXp72.getNode() != compositeNode || !zzXp72.zzYXW()) {
            int n2;
            Node node = zzXp72.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzXvL().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzwE(null, node);
                this.zzXXE = n;
                return;
            }
            while (zzXp72.zzwE(null, false, true, true, false, true) && zzXp72.zzYXW() && zzXp72.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzWk9() {
        int n = this.zzXXE;
        if (n == 0) {
            return;
        }
        this.zzXXE = 0;
        Run run = zzZXr.zzwE((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzWNV(n);
        }
    }

    private Run zzZYO(String string) {
        Run run = new Run(this.zzWSv, string, this.zzW18());
        this.insertNode(run);
        return run;
    }

    final boolean zzt1() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzXu1() {
        return this.zzY9j;
    }

    final void zzaH(int n) {
        this.zzY9j = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzZxr();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzZxr();
        }
        return (Paragraph)this.zzZxr().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzZxr();
        }
        return (StructuredDocumentTag)this.zzZxr().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzZxr().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzWaH zzYdP() {
        zzXFI<zzWaH> zzXFI2 = this.zzVUc;
        if (zzXFI2.size() > 0) {
            return (zzWaH)this.zzVUc.peek();
        }
        return null;
    }

    private Cell zzZIn() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzY4B();
    }

    private CompositeNode zzXNx() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzZxr();
        }
        return this.zzZxr().getParentNode();
    }

    private Node zzX84() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzZxr();
    }

    private zzXFI<zzZlW> zzYCs() {
        if (this.zzYZE == null) {
            this.zzYZE = new zzXFI();
        }
        return this.zzYZE;
    }

    private zzXFI<zzZ3y> zzYPS() {
        if (this.zzZEh == null) {
            this.zzZEh = new zzXFI();
        }
        return this.zzZEh;
    }

    private zzXFI<zzwE> zzXM6() {
        if (this.zzZj7 == null) {
            this.zzZj7 = new zzXFI();
        }
        return this.zzZj7;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzWOs.zzf5(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZAZ(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZAZ(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzWOs.zzWPK(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzW7h()) {
            this.getCurrentParagraph().zzVZz().zzWPK(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzWOs.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzWOs.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzW7h()) {
            this.getCurrentParagraph().zzVZz().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzYA1().zzf5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzYA1().zzXJj(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzWEe(key, 0);
        }
        return this.getDocument().getStyles().zzWV6().zzcX(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzYA1().zzWPK(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzYA1().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzYA1().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzXJr().zzf5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzXJr().zzcX(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzXJr().zzmP(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzXJr().zzWPK(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzXJr().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzXJr().clear();
        zzZoa.zzXLc().zzX2D(this.zzXJr());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzYtA().zzf5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzYtA().zzcX(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzYtA().zzmP(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZXr.zzwE(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzZIn() != null ? this.zzZIn().getCellFormat() : this.getCellFormat();
            border.zzwE(cellFormat);
        }
        this.zzYtA().zzWPK(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzYtA().clear();
    }

    private Node zzZxr() {
        Node node = this.zzko != null && this.zzko.getParentNode() == null ? this.zzra : this.zzko;
        if (node != null && node.zzW6H() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzGq = this.zzGq && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzZJx(Node node) {
        this.zzko = node;
        if (this.zzko != null) {
            this.zzra = this.zzko.getParentNode();
        }
        this.zzGq = false;
    }

    private zzZ3y zzYA1() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzYA1();
        }
        if (this.zzYub == null) {
            this.zzYub = new zzZ3y();
        }
        return this.zzYub;
    }

    private zzZoa zzXJr() {
        if (this.zzYdP() != null && this.zzYdP().zzXLT() == 1) {
            return this.zzX3U;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzXJr();
        }
        return this.zzX3U;
    }

    private zzY3e zzYtA() {
        if (this.zzYdP() != null && this.zzYdP().zzXLT() != 3) {
            return this.zzXiD;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzY4B().zzYtA();
        }
        return this.zzXiD;
    }

    static final class zzwE {
        private zzZlW zzWOs;
        private zzZlW zzJO;

        public zzwE(zzZlW zzZlW2, zzZlW zzZlW3) {
            this.zzWOs = zzZlW2;
            this.zzJO = zzZlW3;
        }

        public final zzZlW zz4s() {
            return this.zzWOs;
        }

        public final zzZlW zzY5v() {
            return this.zzJO;
        }
    }
}

