/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzWto;
import com.aspose.words.internal.zzXo2;
import com.aspose.words.internal.zzXsG;
import com.aspose.words.internal.zzYXY;
import com.aspose.words.internal.zzZXr;
import com.aspose.words.internal.zzks;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXhg;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzWbe = new HashMap();
    private static HashMap<Integer, Integer> zzXkK = new HashMap();
    private static HashMap<Integer, Integer> zzVSb = new HashMap();
    private static HashMap<Integer, Integer> zzWWQ = new HashMap();
    private static HashMap<Integer, Integer> zzE8 = new HashMap();
    private static HashMap<Integer, Integer> zzXDg = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZXr.zzgp(fileName, "fileName");
        try (zzXsG zzXsG2 = zzZXr.zzZT(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzY6j(zzXsG2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzY6j(zzXo2.zzwE(stream));
    }

    static FileFormatInfo zzY6j(zzWto zzWto2) throws Exception {
        if (zzWto2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzXhg zzXhg2 = new zzXhg();
            zzWto zzWto3 = zzWto2;
            zzXhg zzXhg3 = zzXhg2;
            return zzXhg2.zzX2D(zzWto3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzgp(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zz3Y(zzks.zzZDI(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzXBy(zzks.zzZDI(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzYXY.zzVPx(string = zzks.zzXjJ(FileFormatUtil.zz5X(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zz3Y(FileFormatUtil.zzXVP(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzXBy(FileFormatUtil.zz5X(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzks.zzXjJ(FileFormatUtil.zzXVP(saveFormat));
        if (zzYXY.zzVPx(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzXBy(zzks.zzYGT(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzks.zzXjJ(FileFormatUtil.zzWp2(imageType));
    }

    static Exception zzgp(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzZfa(int n) {
        return zzks.toString(FileFormatUtil.zzXVP(n));
    }

    static int zzXBy(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZXr.zzwE(zzE8, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWRb(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZXr.zzwE(zzXDg, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzXvg(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zz5X(int n) {
        return zzZXr.zzwE(zzWbe, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzXVP(int n) {
        return zzZXr.zzwE(zzXkK, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzWp2(int n) {
        return zzZXr.zzwE(zzVSb, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zz3Y(int n) {
        return zzZXr.zzwE(zzWWQ, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzWCg(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZXr.zzX2D(zzE8, Integer.valueOf(n), Integer.valueOf(n2));
            zzZXr.zzX2D(zzXkK, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzWWQ.containsKey(n)) {
                zzZXr.zzX2D(zzWWQ, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZXr.zzX2D(zzWbe, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZXr.zzX2D(zzXDg, Integer.valueOf(n), Integer.valueOf(n4));
            zzZXr.zzX2D(zzVSb, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzWCg(11, 10, 10, 1);
        FileFormatUtil.zzWCg(11, 0, 0, 1);
        FileFormatUtil.zzWCg(12, 11, 11, 1);
        FileFormatUtil.zzWCg(13, 20, 20, 1);
        FileFormatUtil.zzWCg(13, 0, 254, 1);
        FileFormatUtil.zzWCg(14, 21, 21, 1);
        FileFormatUtil.zzWCg(15, 22, 22, 1);
        FileFormatUtil.zzWCg(16, 23, 23, 1);
        FileFormatUtil.zzWCg(18, 24, 24, 1);
        FileFormatUtil.zzWCg(19, 25, 25, 1);
        FileFormatUtil.zzWCg(20, 26, 26, 1);
        FileFormatUtil.zzWCg(21, 27, 27, 1);
        FileFormatUtil.zzWCg(24, 30, 30, 1);
        FileFormatUtil.zzWCg(17, 31, 31, 1);
        FileFormatUtil.zzWCg(25, 50, 50, 1);
        FileFormatUtil.zzWCg(26, 45, 255, 1);
        FileFormatUtil.zzWCg(27, 51, 51, 1);
        FileFormatUtil.zzWCg(28, 0, 52, 1);
        FileFormatUtil.zzWCg(29, 0, 53, 1);
        FileFormatUtil.zzWCg(31, 53, 54, 1);
        FileFormatUtil.zzWCg(22, 60, 60, 1);
        FileFormatUtil.zzWCg(23, 61, 61, 1);
        FileFormatUtil.zzWCg(34, 40, 64, 1);
        FileFormatUtil.zzWCg(41, 47, 255, 1);
        FileFormatUtil.zzWCg(42, 48, 255, 1);
        FileFormatUtil.zzWCg(35, 41, 255, 1);
        FileFormatUtil.zzWCg(36, 46, 255, 1);
        FileFormatUtil.zzWCg(38, 42, 255, 1);
        FileFormatUtil.zzWCg(37, 44, 255, 1);
        FileFormatUtil.zzWCg(30, 52, 55, 1);
        FileFormatUtil.zzWCg(32, 70, 62, 1);
        FileFormatUtil.zzWCg(33, 73, 63, 1);
        FileFormatUtil.zzWCg(39, 71, 255, 1);
        FileFormatUtil.zzWCg(8, 100, 255, 1);
        FileFormatUtil.zzWCg(9, 105, 255, 1);
        FileFormatUtil.zzWCg(6, 101, 255, 6);
        FileFormatUtil.zzWCg(7, 102, 255, 7);
        FileFormatUtil.zzWCg(5, 104, 255, 5);
        FileFormatUtil.zzWCg(4, 0, 255, 4);
        FileFormatUtil.zzWCg(3, 0, 255, 3);
        FileFormatUtil.zzWCg(40, 72, 255, 1);
        FileFormatUtil.zzWCg(2, 103, 255, 2);
    }
}

