/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzXo2;
import com.aspose.words.zzTO;
import com.aspose.words.zzXTC;
import com.aspose.words.zzXwq;
import com.aspose.words.zzfj;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzTO,
Iterable<T> {
    private Node zzCW;
    private CompositeNode zzX5f;
    private DocumentBase zzZpl;
    private boolean zzWFT;
    private int zzXhQ;
    private int zz9V;
    private Node zzkB;
    private int zzXDZ;
    private zzfj zzY0o;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzXTC.zzYDO(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzXTC(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzfj matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzX5f = container;
        this.zzZpl = container.getDocument();
        this.zzY0o = matcher;
        this.zzWFT = isDeep;
        this.zzYlD();
    }

    public Node get(int index) {
        try {
            this.zzWQH();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zz9V == index) {
                return this.zzkB;
            }
            int n = index - this.zz9V;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zz1Q(nodeCollection.zzkB, n);
            if (node != null) {
                this.zz9V = index;
                this.zzkB = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzWFT) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzX5f.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzWFT) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzX5f.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzZIS();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXwq(this);
    }

    final <TNode extends Node> zzXwq<TNode> zzYCF() {
        return new zzXwq(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzZIS() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzXo2.zzwE(arrayList, node);
        }
        return arrayList;
    }

    private Node zz1Q(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzYhV(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzZJx(curNode, true);
    }

    private Node zzZJx(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzCW = node;
        do {
            node2 = this.zzCW;
            Node node3 = this.zzWFT ? this.zzwE(true, this.zzCW) : (this.zzCW = this.zzY0o.zzZaT() ? this.zzgp(true, this.zzCW) : this.zzX2D(true, this.zzCW));
        } while (this.zzCW != null && !this.zzY0o.zz1Q(this.zzCW));
        return node2;
    }

    private Node zzYhV(Node node, boolean bl) throws Exception {
        while ((this.zzWFT ? this.zzwE(bl, node) : (node = this.zzY0o.zzZaT() ? this.zzgp(bl, node) : this.zzX2D(bl, node))) != null && !this.zzY0o.zz1Q(node)) {
        }
        return node;
    }

    private Node zzwE(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzX5f);
        }
        return node.previousPreOrder(this.zzX5f);
    }

    private Node zzX2D(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzX5f) {
                return this.zzX5f.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzX5f) {
            return this.zzX5f.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzgp(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzX5f ? this.zzX5f.zzW35() : node.zzWfZ();
        } else {
            Node node3 = node2 = node == this.zzX5f ? this.zzX5f.zzHe() : node.zzZbm();
        }
        if (node2 == this.zzX5f.getNextSibling() || node2 == this.zzX5f.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzWQH() {
        if (this.zzXhQ != this.zzYAG()) {
            this.zzYlD();
        }
    }

    private void zzYlD() {
        this.zzXhQ = this.zzYAG();
        this.zz9V = -1;
        this.zzkB = this.zzX5f;
        this.zzXDZ = -1;
    }

    private int zzYAG() {
        if (this.zzZpl != null) {
            return this.zzZpl.zzZV6();
        }
        return 0;
    }

    public int getCount() {
        this.zzWQH();
        if (this.zzXDZ == -1) {
            this.zzXDZ = zzXwq.zzwE(this);
        }
        return this.zzXDZ;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzCW;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzX5f;
    }
}

