/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzZn0;
import com.aspose.words.internal.zzks;

public abstract class SaveOptions {
    private boolean zzZMk;
    boolean zzYAu = false;
    boolean zzYYK = true;
    private IDocumentSavingCallback zzha;
    private boolean zzZdT = true;
    private boolean zzZuD = false;
    private boolean zzWWk;
    private boolean zzY8X = true;
    private boolean zzW1M;
    private String zzYCf;
    private boolean zzYL1;
    private boolean zzVUi = false;
    private int zzWdF = 1;
    private int zzYef = 1;
    private int zzZlL = 0;
    private String zzWUt = "";
    private boolean zzWYq = true;
    private boolean zzL9 = true;
    private boolean zzYKj;
    private boolean zzW9g;
    private int zzWQj = 0;
    private boolean zzVL = true;
    private boolean zzZn1 = false;

    protected SaveOptions() {
    }

    final boolean zzQY() {
        return this.zzWWk;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzFA() {
        return false;
    }

    boolean zzXjN() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzY8X;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzY8X = value;
    }

    public String getTempFolder() {
        return this.zzYCf;
    }

    public void setTempFolder(String value) {
        this.zzYCf = value;
    }

    public boolean getPrettyFormat() {
        return this.zzW1M;
    }

    public void setPrettyFormat(boolean value) {
        this.zzW1M = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYL1;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYL1 = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzVUi;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzVUi = value;
    }

    @Deprecated
    public boolean getUpdateSdtContent() {
        return this.zzYAu;
    }

    @Deprecated
    public void setUpdateSdtContent(boolean value) {
        this.zzYAu = value;
    }

    public int getDmlRenderingMode() {
        return this.zzWdF;
    }

    public void setDmlRenderingMode(int value) {
        this.zzWdF = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZlL;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZlL = value;
    }

    public int getImlRenderingMode() {
        return this.zzYef;
    }

    public void setImlRenderingMode(int value) {
        this.zzYef = value;
    }

    public String getDefaultTemplate() {
        return this.zzWUt;
    }

    public void setDefaultTemplate(String value) {
        this.zzWUt = value;
    }

    public boolean getUpdateFields() {
        return this.zzWYq;
    }

    public void setUpdateFields(boolean value) {
        this.zzWYq = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzYKj;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzYKj = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzW9g;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzW9g = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzZn1;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzZn1 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzZuD;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzZuD = value;
    }

    final boolean zzYpt() {
        return this.zzL9;
    }

    final boolean zzWmw() {
        return this.zzVL;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzXBy(zzks.zzYGT(zzZn0.zzW5Z(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzWQj;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzWQj = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzha;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzha = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZMk;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZMk = value;
    }

    final boolean zz2B() {
        return this.zzZdT;
    }
}

