/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzWc;
import com.aspose.words.internal.zzZXr;
import com.aspose.words.zz4o;
import com.aspose.words.zzVRz;
import com.aspose.words.zzWF;

public final class Section
extends CompositeNode<Node>
implements zzVRz {
    private zz4o zzWlO;
    private PageSetup zzXEw;
    private HeaderFooterCollection zzXYV;

    public Section(DocumentBase doc) {
        this(doc, new zz4o());
    }

    Section(DocumentBase doc, zz4o sectPr) {
        super(doc);
        this.zzWlO = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzXYV == null) {
            this.zzXYV = new HeaderFooterCollection(this);
        }
        return this.zzXYV;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXEw == null) {
            Section section = this;
            this.zzXEw = new PageSetup(section, section.getDocument().zzWwo(), this.getDocument().getStyles(), new zzwE(this));
        }
        return this.zzXEw;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzW9B();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzsb(!value);
    }

    final zz4o zzxY() {
        return this.zzWlO;
    }

    final void zzgp(zz4o zz4o2) {
        this.zzWlO = zz4o2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzwE(boolean bl, zzWF zzWF2) {
        zz4o zz4o2;
        Section section = (Section)super.zzwE(bl, zzWF2);
        zz4o zz4o3 = this.zzWlO;
        section.zzWlO = zz4o2 = (zz4o)zz4o3.zzWVE();
        section.zzXEw = null;
        section.zzXYV = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzwE(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzX2D(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzY97(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzY97(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzW1Z(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzYbL(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzW1Z(n) == null;
            }
        }
        return false;
    }

    final void zzgp(Shape shape, boolean bl) throws Exception {
        this.zzwE(shape, 4, bl);
        this.zzwE(shape, 0, bl);
        this.zzwE(shape, 1, bl);
    }

    private void zzwE(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzW8o());
        shape2.setName(zzWc.zzX2D("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzX07() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzYKN()) {
                if (!shape.zzWTp()) continue;
                shape.remove();
            }
        }
    }

    private void zzY97(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzX2D(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzWlO.zzf5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzWwo().zzZYf.zzcX(key);
        }
        return zz4o.zzZCy(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzWlO.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzWwo().zzZYf.zzWPK(key, value);
            return;
        }
        this.zzWlO.zzWPK(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzWlO.clear();
    }

    final boolean zzXcb() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzJH() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzwE
    implements zzVRz {
        private Section zzYM5;

        zzwE(Section section) {
            this.zzYM5 = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzXQc().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzXQc().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzXQc().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzVRz zzXQc() {
            Document document = zzZXr.zzwE((Object)this.zzYM5.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYM5;
        }
    }
}

