/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWc;
import com.aspose.words.internal.zzWq8;
import com.aspose.words.internal.zzXCi;
import com.aspose.words.internal.zzYW5;
import com.aspose.words.internal.zzYXY;
import com.aspose.words.internal.zzZXr;
import com.aspose.words.internal.zzZnL;
import com.aspose.words.zzZx;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzWSv;
    private zzZx zzYP9;

    Watermark(Document doc, zzZx watermarkProvider) {
        this.zzWSv = doc;
        this.zzYP9 = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzX9k(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzwE(text, textWatermarkOptions, this.zzWSv);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZXr.zzX2D((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzWSv, 75);
        shape.getImageData().setImage(image);
        this.zzwE(shape, options, this.zzWSv);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZXr.zzX2D((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzWSv, 75);
        shape.getImageData().setImage(imagePath);
        this.zzwE(shape, options, this.zzWSv);
    }

    public final int getType() {
        Shape shape = this.zzYP9.get();
        if (shape == null) {
            return 2;
        }
        shape.zzWTp();
        if (shape.zzWp()) {
            return 0;
        }
        if (shape.zzKe()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzYP9.add(shape);
    }

    public final void remove() {
        this.zzYP9.remove();
    }

    private static void zzX9k(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzYXY.zzWAj(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZXr.zzwE(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzwE(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzX2D(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzXDv(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzX2D(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzVPg() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzYFp()) / d2) > (double)(f = pageSetup.zzzB())) {
            d = (double)f / d3;
        }
        shape.zzXEW(zzZnL.zzgp(d2 * d, 2, zzWq8.zzHs));
        shape.zzXov(zzZnL.zzgp(d3 * d, 2, zzWq8.zzHs));
    }

    private Shape zzwE(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzwE(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzXDv(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzwE(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzXev() ? 1.0f : textWatermarkOptions.getFontSize();
        zzYW5 zzYW52 = document.zzZzS().zzgp(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzYW52.zzYRK(shape.getTextPath().getText());
        if (textWatermarkOptions.zzXev()) {
            l = Watermark.zzwE(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzXEW(zzZnL.zzgp(Float.intBitsToFloat(n), 2, zzWq8.zzHs));
        shape.zzXov(zzZnL.zzgp(zzXCi.zzZnv(l), 2, zzWq8.zzHs));
    }

    private static long zzwE(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzYFp();
        float f2 = pageSetup.zzzB();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzXCi.zzZnv(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzXCi.zzZ6H(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzXCi.zzZnv(l) >= Float.intBitsToFloat(n)) {
            return zzXCi.zzZ6H(f2 / f3, f2);
        }
        float f6 = f;
        return zzXCi.zzZ6H(f6, f6 * f3);
    }

    private static void zzXDv(Shape shape, String string) {
        shape.setName(zzWc.zzX2D("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

