/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzGI;
import com.aspose.words.internal.zzN0;
import com.aspose.words.internal.zzUX;
import com.aspose.words.internal.zzVSC;
import com.aspose.words.internal.zzW2S;
import com.aspose.words.internal.zzWIE;
import com.aspose.words.internal.zzX0w;
import com.aspose.words.internal.zzXEY;
import com.aspose.words.internal.zzXnz;
import com.aspose.words.internal.zzY3k;
import com.aspose.words.internal.zzY8v;
import com.aspose.words.internal.zzYD4;
import com.aspose.words.internal.zzYjZ;
import com.aspose.words.internal.zzYoN;
import com.aspose.words.internal.zzZD0;
import com.aspose.words.internal.zzZEr;
import com.aspose.words.internal.zzZJK;
import com.aspose.words.internal.zzZJj;
import com.aspose.words.internal.zzZX8;
import com.aspose.words.internal.zzZmS;
import com.aspose.words.internal.zzxT;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzWXN
extends X509CRL {
    private final Provider zzuw;
    private final zzXnz zzWfP;
    private final String zzX8H;
    private final byte[] zzZxl;
    private final boolean zzYEC;
    private volatile boolean zzXbf = false;
    private volatile int zzWrq;

    static boolean zzgp(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(zzYoN.zzWol.getId());
            return byArray != null && zzW2S.zzVPx(zzYjZ.zz4g(byArray).zzZQk()).zzXQF();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected zzWXN(Provider provider, zzXnz zzXnz2) throws CRLException {
        this.zzuw = provider;
        this.zzWfP = zzXnz2;
        try {
            this.zzX8H = zzVSC.zzYH7(zzXnz2.zzYQS());
            this.zzZxl = (byte[])(zzXnz2.zzYQS().zzYCy() != null ? zzXnz2.zzYQS().zzYCy().zzYVr().getEncoded("DER") : null);
            this.zzYEC = zzWXN.zzgp(this);
            return;
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(zzWIE.zzjT);
        return !set.isEmpty();
    }

    private Set zzYBG(boolean bl) {
        zzXEY zzXEY2;
        if (this.getVersion() == 2 && (zzXEY2 = this.zzWfP.zzT5().zzZOy()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = zzXEY2.zzYuC();
            while (enumeration.hasMoreElements()) {
                zzxT zzxT2 = (zzxT)enumeration.nextElement();
                zzYoN zzYoN2 = zzXEY2.zzYbL(zzxT2);
                if (bl != zzYoN2.isCritical()) continue;
                hashSet.add(zzxT2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public final Set getCriticalExtensionOIDs() {
        return this.zzYBG(true);
    }

    public final Set getNonCriticalExtensionOIDs() {
        return this.zzYBG(false);
    }

    @Override
    public final byte[] getExtensionValue(String oid) {
        zzYoN zzYoN2;
        zzXEY zzXEY2 = this.zzWfP.zzT5().zzZOy();
        if (zzXEY2 != null && (zzYoN2 = zzXEY2.zzYbL(new zzxT(oid))) != null) {
            try {
                return zzYoN2.zzXrK().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public final byte[] getEncoded() throws CRLException {
        try {
            return this.zzWfP.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.zzuw);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.zzwE(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = sigProvider != null ? Signature.getInstance(this.getSigAlgName(), sigProvider) : Signature.getInstance(this.getSigAlgName());
        this.zzwE(key, signature);
    }

    private void zzwE(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.zzWfP.zzYQS().equals(this.zzWfP.zzT5().zzWtO())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.zzZxl != null) {
            try {
                zzVSC.zzwE(signature, zzGI.zzAo(this.zzZxl));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public final int getVersion() {
        return this.zzWfP.zzZOH();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.zzWfP.zzWsG().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public final Date getThisUpdate() {
        return this.zzWfP.zzZ3s().zzXCa();
    }

    @Override
    public final Date getNextUpdate() {
        if (this.zzWfP.zzXxi() != null) {
            return this.zzWfP.zzXxi().zzXCa();
        }
        return null;
    }

    private Set zzY96() {
        HashSet<zzZEr> hashSet = new HashSet<zzZEr>();
        Enumeration enumeration = this.zzWfP.zzXe3();
        zzN0 zzN02 = null;
        while (enumeration.hasMoreElements()) {
            zzYoN zzYoN2;
            zzY3k.zzwE zzwE2 = (zzY3k.zzwE)enumeration.nextElement();
            zzZEr zzZEr2 = new zzZEr(zzwE2, this.zzYEC, zzN02);
            hashSet.add(zzZEr2);
            if (!this.zzYEC || !zzwE2.hasExtensions() || (zzYoN2 = zzwE2.zzZOy().zzYbL(zzYoN.zzWpH)) == null) continue;
            zzN02 = zzN0.zzZtY(zzY8v.zzYlG(zzYoN2.zzYvN()).zzZkG()[0].zzXmi());
        }
        return hashSet;
    }

    @Override
    public final X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        Enumeration enumeration = this.zzWfP.zzXe3();
        zzN0 zzN02 = null;
        while (enumeration.hasMoreElements()) {
            zzYoN zzYoN2;
            zzY3k.zzwE zzwE2 = (zzY3k.zzwE)enumeration.nextElement();
            if (serialNumber.equals(zzwE2.zzWSa().zzZpn())) {
                return new zzZEr(zzwE2, this.zzYEC, zzN02);
            }
            if (!this.zzYEC || !zzwE2.hasExtensions() || (zzYoN2 = zzwE2.zzZOy().zzYbL(zzYoN.zzWpH)) == null) continue;
            zzN02 = zzN0.zzZtY(zzY8v.zzYlG(zzYoN2.zzYvN()).zzZkG()[0].zzXmi());
        }
        return null;
    }

    public final Set getRevokedCertificates() {
        Set set = this.zzY96();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public final byte[] getTBSCertList() throws CRLException {
        try {
            return this.zzWfP.zzT5().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final byte[] getSignature() {
        return this.zzWfP.zzWck().zzZQk();
    }

    @Override
    public final String getSigAlgName() {
        return this.zzX8H;
    }

    @Override
    public final String getSigAlgOID() {
        return this.zzWfP.zzYQS().zzYiW().getId();
    }

    @Override
    public final byte[] getSigAlgParams() {
        if (this.zzZxl != null) {
            byte[] byArray = new byte[this.zzZxl.length];
            System.arraycopy(this.zzZxl, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    @Override
    public final String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzZJj.zzXCK();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(zzZJj.zzzh(zzX0w.zzZJm(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(zzZJj.zzzh(zzX0w.zzZJm(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(zzZJj.zzzh(zzX0w.zzZJm(byArray, i, byArray.length - i))).append(string);
        }
        zzXEY zzXEY2 = this.zzWfP.zzT5().zzZOy();
        if (zzXEY2 != null) {
            object2 = zzXEY2.zzYuC();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (zzxT)object2.nextElement();
                zzYoN zzYoN2 = zzXEY2.zzYbL((zzxT)object);
                if (zzYoN2.zzXrK() != null) {
                    byte[] byArray2 = zzYoN2.zzXrK().zzZQk();
                    stringBuffer.append("                       critical(").append(zzYoN2.isCritical()).append(") ");
                    try {
                        zzGI zzGI2 = zzGI.zzAo(byArray2);
                        if (((zzGI)object).equals(zzYoN.zzVQL)) {
                            stringBuffer.append(new zzZX8(zzZD0.zzHO(zzGI2).zzZHd())).append(string);
                            continue;
                        }
                        if (((zzGI)object).equals(zzYoN.zz4a)) {
                            stringBuffer.append("Base CRL: " + new zzZX8(zzZD0.zzHO(zzGI2).zzZHd())).append(string);
                            continue;
                        }
                        if (((zzGI)object).equals(zzYoN.zzWol)) {
                            stringBuffer.append(zzW2S.zzVPx(zzGI2)).append(string);
                            continue;
                        }
                        if (((zzGI)object).equals(zzYoN.zzZbU)) {
                            stringBuffer.append(zzUX.zzW0n(zzGI2)).append(string);
                            continue;
                        }
                        if (((zzGI)object).equals(zzYoN.zzZuf)) {
                            stringBuffer.append(zzUX.zzW0n(zzGI2)).append(string);
                            continue;
                        }
                        stringBuffer.append(((zzxT)object).getId());
                        stringBuffer.append(" value = ").append(zzYD4.zzqg(zzGI2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((zzxT)object).getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.zzWfP.zzXe3();
        zzN0 zzN02 = this.zzWfP.zzWsG();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)cert).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                zzZJK zzZJK2;
                zzY3k.zzwE zzwE2 = zzY3k.zzwE.zzYyR(enumeration.nextElement());
                if (this.zzYEC && zzwE2.hasExtensions() && (zzZJK2 = zzwE2.zzZOy().zzYbL(zzYoN.zzWpH)) != null) {
                    zzN02 = zzN0.zzZtY(zzY8v.zzYlG(zzZJK2.zzYvN()).zzZkG()[0].zzXmi());
                }
                if (!zzwE2.zzWSa().zzZpn().equals(bigInteger)) continue;
                if (cert instanceof X509Certificate) {
                    zzZJK2 = zzN0.zzZtY(((X509Certificate)cert).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        zzZJK2 = zzZmS.zzZd8(cert.getEncoded()).zzWsG();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return zzN02.equals(zzZJK2);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X509CRL)) {
            return false;
        }
        if (other instanceof zzWXN) {
            boolean bl;
            zzWXN zzWXN2 = (zzWXN)other;
            if (this.zzXbf && (bl = zzWXN2.zzXbf) && zzWXN2.zzWrq != this.zzWrq) {
                return false;
            }
            return this.zzWfP.equals(zzWXN2.zzWfP);
        }
        return super.equals(other);
    }

    @Override
    public final int hashCode() {
        if (!this.zzXbf) {
            this.zzWrq = super.hashCode();
            this.zzXbf = true;
        }
        return this.zzWrq;
    }
}

