/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzW61;
import com.aspose.words.internal.zzW8J;
import com.aspose.words.internal.zzWP7;
import com.aspose.words.internal.zzWnX;
import com.aspose.words.internal.zzXTW;
import com.aspose.words.internal.zzXWx;
import com.aspose.words.internal.zzXsx;
import com.aspose.words.internal.zzY1B;
import com.aspose.words.internal.zzYoN;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzZcE
extends CertPathBuilderSpi {
    private final zzW61 zzZj5;
    private zzXWx zzWXe;

    zzZcE(zzW61 zzW612) {
        this.zzZj5 = zzW612;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzY1B pkixParams;
        if (params instanceof zzY1B) {
            pkixParams = (zzY1B)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzY1B.zzwE((PKIXBuilderParameters)params).zzWAm();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzY1B.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzW8J zzW8J2 = pkixParams.zzXEe().zzZVe();
        try {
            collection = zzXTW.zzwE(zzW8J2, pkixParams.zzXEe().zzXwv());
            collection.addAll(zzXTW.zzwE(zzW8J2, pkixParams.zzXEe().zzYMO()));
        }
        catch (zzXWx zzXWx2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzXWx2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzwE(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzWXe != null) {
            throw new CertPathBuilderException(this.zzWXe.getMessage(), this.zzWXe.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzwE(X509Certificate x509Certificate, zzY1B zzY1B2, List list) throws CertPathBuilderException {
        zzXsx zzXsx2;
        zzWP7 zzWP72;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzY1B2.zzHu().contains(x509Certificate)) {
            return null;
        }
        if (zzY1B2.zz5J() != -1 && list.size() - 1 > zzY1B2.zz5J()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzWP72 = new zzWP7(this.zzZj5);
            zzXsx2 = new zzXsx(this.zzZj5);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzXTW.zzwE(x509Certificate, zzY1B2.zzXEe().zzWHY(), zzY1B2.zzXEe().zzXNF()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzWP72.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzXWx("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzXsx2.engineValidate(certPath, zzY1B2);
                }
                catch (Exception exception) {
                    throw new zzXWx("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzWnX> arrayList = new ArrayList<zzWnX>();
            arrayList.addAll(zzY1B2.zzXEe().zzXwv());
            try {
                arrayList.addAll(zzXTW.zzwE(x509Certificate.getExtensionValue(zzYoN.zzZo3.getId()), zzY1B2.zzXEe().zzYy()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzXWx("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzXTW.zzwE(x509Certificate, zzY1B2.zzXEe().zzYMO(), arrayList));
            }
            catch (zzXWx zzXWx2) {
                throw new zzXWx("Cannot find issuer certificate for certificate in certification path.", zzXWx2);
            }
            if (hashSet.isEmpty()) {
                throw new zzXWx("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzwE(x509Certificate2, zzY1B2, list);
            }
        }
        catch (zzXWx zzXWx3) {
            this.zzWXe = zzXWx3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

