/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXWi;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzX2D;
import com.aspose.words.net.System.Data.zzXFj;
import com.aspose.words.net.System.Data.zzXos;
import com.aspose.words.net.System.Data.zzgp;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzX8r;
    private final DataColumnCollection zzZaE;
    private final ConstraintCollection zzYF1;
    private final zzXos zzeW;
    private ResultSet zzYTB;
    private String zzW92;
    private DataSet zzIV;
    private String zzZyY;
    private UniqueConstraint zzWz8;
    private boolean zzXj1;
    private final List<DataTableEventListener> zzYmM;
    private final Set<DataRow> zzWaT;
    private DataRelationCollection zziq;

    public DataTable() {
        this.zzX8r = new DataRowCollection(this);
        this.zzZaE = new DataColumnCollection(this);
        this.zzYF1 = new ConstraintCollection(this);
        this.zzeW = new zzXos(this);
        this.zzZyY = "";
        this.zzXj1 = true;
        this.zzYmM = new ArrayList<DataTableEventListener>();
        this.zzWaT = new HashSet<DataRow>();
        this.zziq = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzX8r = new DataRowCollection(this);
        this.zzZaE = new DataColumnCollection(this);
        this.zzYF1 = new ConstraintCollection(this);
        this.zzeW = new zzXos(this);
        this.zzZyY = "";
        this.zzXj1 = true;
        this.zzYmM = new ArrayList<DataTableEventListener>();
        this.zzWaT = new HashSet<DataRow>();
        this.zziq = new DataRelationCollection();
        this.zzW92 = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzX2D.zzwE(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzX8r = new DataRowCollection(this);
        this.zzZaE = new DataColumnCollection(this);
        this.zzYF1 = new ConstraintCollection(this);
        this.zzeW = new zzXos(this);
        this.zzZyY = "";
        this.zzXj1 = true;
        this.zzYmM = new ArrayList<DataTableEventListener>();
        this.zzWaT = new HashSet<DataRow>();
        this.zziq = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzYTB = resultSet;
        this.zzW92 = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzYTB != null) {
            if (this.zzYTB.getStatement() != null) {
                this.zzYTB.getStatement().getConnection().close();
            }
            this.zzYTB = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzW92;
    }

    public void setTableName(String tableName) {
        this.zzW92 = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzZaE.getCount();
    }

    public String getColumnName(int index) {
        return this.zzZaE.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzYTB;
    }

    public DataSet getDataSet() {
        return this.zzIV;
    }

    final void zzY97(DataSet dataSet) {
        this.zzIV = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzIV.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zziq.add(dataRelation);
        }
        return this.zziq;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzIV.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzX8r;
    }

    public DataColumnCollection getColumns() {
        return this.zzZaE;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzYF1;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzWz8 == null) {
            return new DataColumn[0];
        }
        return this.zzWz8.getColumns();
    }

    final void zzXos(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzWz8 != null) {
                this.zzWz8.zz9i(false);
                this.getConstraints().remove(this.zzWz8);
                this.zzWz8 = null;
            }
            return;
        }
        if (this.zzWz8 != null && DataColumn.areColumnSetsTheSame(value, this.zzWz8.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzwE(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzWz8 != null) {
            this.zzWz8.zz9i(false);
            this.getConstraints().remove(this.zzWz8);
            this.zzWz8 = null;
        }
        UniqueConstraint.zzwE(this.getConstraints(), uniqueConstraint);
        this.zzWz8 = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZyY;
    }

    public void setNamespace(String namespace) {
        this.zzZyY = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXj1;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXj1 = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzWaT.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzX2D.zzwE(this.getResultSet(), this);
            zzX2D.zzX2D(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXWi.zzY97(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzX2D.zzXDv(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzYmM.contains(listener)) {
            this.zzYmM.add(listener);
        }
    }

    public void removeEventListener(zzgp listener) {
        if (this.zzYmM.contains(listener)) {
            this.zzYmM.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzYmM.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzWaT.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYmM) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzWaT.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYmM) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzWaT.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYmM) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYmM) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYmM) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXFj zzwE(zzX2D[] zzX2DArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzX2DArray.length];
        for (int i = 0; i < zzX2DArray.length; ++i) {
            dataColumnArray[i] = zzX2DArray[i].zzVZ7();
        }
        DataTable dataTable = this;
        zzXFj zzXFj2 = dataTable.zzeW.zzY97(dataColumnArray);
        if (zzXFj2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXFj2;
    }

    final zzXos zzb5() {
        return this.zzeW;
    }

    final Set<DataRow> zzYXF() {
        return this.zzWaT;
    }
}

