/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz4x;
import com.aspose.words.internal.zzC5;
import com.aspose.words.internal.zzEE;
import com.aspose.words.internal.zzW1I;
import com.aspose.words.internal.zzWA0;
import com.aspose.words.internal.zzX6Z;
import com.aspose.words.internal.zzXKX;
import com.aspose.words.internal.zzYkh;
import com.aspose.words.internal.zzYrx;
import com.aspose.words.internal.zzZIu;
import com.aspose.words.internal.zzZRr;
import com.aspose.words.internal.zzZqY;
import com.aspose.words.zzVXr;
import com.aspose.words.zzWTY;
import com.aspose.words.zzWVr;
import com.aspose.words.zzX0m;
import com.aspose.words.zzYD9;
import com.aspose.words.zzYGo;
import com.aspose.words.zzYk0;
import com.aspose.words.zzZ0i;
import com.aspose.words.zzZT3;
import com.aspose.words.zzqU;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzab(zzEE zzEE2, zzEE zzEE3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzYkh.zzYCO((Object)zzEE2, "srcStream");
        zzYkh.zzYCO((Object)zzEE3, "dstStream");
        zzYkh.zzYCO((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYCO(zzEE2, zzEE3, certificateHolder, signOptions);
        zzEE3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzab(zzEE.zzYCO(srcStream), (zzEE)zzEE.zzzD(dstStream), certHolder, signOptions);
    }

    private static void zzYCO(zzEE zzEE2, zzEE zzEE3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzzD(digitalSignature);
        }
        if (zzqU.zzW8L(zzEE2)) {
            DigitalSignatureUtil.zzab(zzEE2, zzEE3, digitalSignature, true);
            return;
        }
        zzqU zzqU2 = new zzqU();
        zzEE zzEE4 = zzEE2;
        zzqU zzqU3 = zzqU2;
        FileFormatInfo fileFormatInfo = zzqU2.zzYCO(zzEE4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzX6Z zzX6Z2 = new zzX6Z(zzEE2);
                int n = fileFormatInfo.zzXbS() == 1 ? 1 : 2;
                zzWTY.zzab(zzX6Z2, digitalSignature, n);
                zzEE3.zzdR(0L);
                zzX6Z2.zzWA8(zzEE3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzab(fileFormatInfo.zzWeH(), zzEE3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzab(zzEE2, zzEE3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzab(zzEE2, zzEE3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzYkh.zzzD(srcFileName, "srcFileName");
        zzYkh.zzzD(dstFileName, "dstFileName");
        zzWA0 zzWA02 = zzYkh.zzYCO(srcFileName, 3, 1);
        try {
            zzWA0 zzWA03 = zzYkh.zzYCO(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzab((zzEE)zzWA02, (zzEE)zzWA03, certHolder, signOptions);
            }
            finally {
                zzWA03.close();
            }
            return;
        }
        finally {
            zzWA02.close();
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zz4x zz4x2 = zzEE.zzzD(dstStream);
        zzEE zzEE2 = zzEE.zzYCO(srcStream);
        DigitalSignatureUtil.zzab(zzEE2, (zzEE)zz4x2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        zzWA0 zzWA02 = zzYkh.zzYCO(srcFileName, 3, 1);
        try {
            zzWA0 zzWA03 = zzYkh.zzYCO(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzWpk(zzWA02, zzWA03);
            }
            finally {
                zzWA03.close();
            }
            return;
        }
        finally {
            zzWA02.close();
        }
    }

    private static void zzWpk(zzEE zzEE2, zzEE zzEE3) throws Exception {
        zzqU zzqU2 = new zzqU();
        zzEE zzEE4 = zzEE2;
        zzqU zzqU3 = zzqU2;
        FileFormatInfo fileFormatInfo = zzqU2.zzYCO(zzEE4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzX6Z zzX6Z2 = new zzX6Z(zzEE2);
                zzX6Z2.zzWIQ().zzZ8l("_xmlsignatures");
                zzX6Z2.zzWIQ().zzZ8l("_signatures");
                zzEE3.zzW19(0L);
                zzX6Z2.zzWA8(zzEE3);
                zzEE zzEE5 = zzEE3;
                zzEE5.zzdR(zzEE5.zzYRn());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZqY zzZqY2 = new zzZqY(zzEE2);
                zzXKX zzXKX2 = zzZqY2.zzab(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXKX2 != null) {
                    for (zzYrx zzYrx2 : zzXKX2.zzWIW()) {
                        String string = zzXKX2.zzab(zzYrx2);
                        zzZqY2.zzWKH().remove(string);
                    }
                    zzZqY2.zzWKH().remove(zzXKX2.getName());
                    zzYrx zzYrx3 = zzZqY2.zzWIW().zzYez("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZqY2.zzWIW().remove(zzYrx3.getId());
                    zzZqY2.zzZwA();
                }
                zzEE3.zzW19(0L);
                zzZqY2.zzWA8(zzEE3);
                zzEE zzEE6 = zzEE3;
                zzEE6.zzdR(zzEE6.zzYRn());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzWpk(zzEE.zzYCO(srcStream), zzEE.zzzD(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        zzWA0 zzWA02 = zzYkh.zzYCO(fileName, 3, 1);
        try {
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzWpH(zzWA02);
            return digitalSignatureCollection;
        }
        finally {
            zzWA02.close();
        }
    }

    private static DigitalSignatureCollection zzWpH(zzEE zzEE2) throws Exception {
        if (zzqU.zzW8L(zzEE2)) {
            return DigitalSignatureUtil.zzxW(zzEE2);
        }
        zzqU zzqU2 = new zzqU();
        zzEE zzEE3 = zzEE2;
        zzqU zzqU3 = zzqU2;
        FileFormatInfo fileFormatInfo = zzqU2.zzYCO(zzEE3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzEE2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzWpH(zzEE.zzYCO(stream));
    }

    static zzC5 zzab(zzX6Z zzX6Z2, String string) throws Exception {
        zzWVr zzWVr2 = new zzWVr(zzX6Z2);
        if (zzWVr2.zzZhD()) {
            zzC5 zzC52 = zzWVr2.zzYr8(string);
            return zzC52;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzOR(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzW1I.zzYCO("Unexpected digest algorithm: {0}.", n));
    }

    static String zzYXJ(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzOR(n);
    }

    private static void zzab(zzEE zzEE2, zzEE zzEE3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZqY zzZqY2 = new zzZqY(zzEE2);
        zzZT3 zzZT32 = bl ? new zzYGo(zzZqY2) : new zzYD9(zzZqY2);
        zzZT32.zzYCO(digitalSignature);
        zzEE3.zzdR(0L);
        zzZqY2.zzWA8(zzEE3);
    }

    private static void zzab(zzEE zzEE2, zzEE zzEE3, DigitalSignature digitalSignature) throws Exception {
        zzX0m zzX0m2 = new zzX0m(zzEE2);
        zzVXr zzVXr2 = new zzVXr(zzX0m2);
        zzVXr2.zzYCO(digitalSignature);
        zzEE3.zzdR(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzEE zzEE4 = zzEE3;
        zzX0m zzX0m3 = zzX0m2;
        zzX0m3.zzab(zzEE4, string, null);
    }

    private static void zzab(zzX6Z zzX6Z2, zzEE zzEE2, DigitalSignature digitalSignature, String string) throws Exception {
        zzC5 zzC52 = DigitalSignatureUtil.zzab(zzX6Z2, string);
        zzC5 zzC53 = new zzC5();
        DigitalSignatureUtil.zzab((zzEE)zzC52, (zzEE)zzC53, digitalSignature, false);
        zzX6Z zzX6Z3 = zzWVr.zzzD(zzC53, string);
        zzX6Z3.zzWA8(zzEE2);
    }

    private static DigitalSignatureCollection zzxW(zzEE zzEE2) throws Exception {
        zzEE2.zzW19(0L);
        zzZqY zzZqY2 = new zzZqY(zzEE2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXKX zzXKX2 = zzZqY2.zzab(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXKX2 != null) {
            for (zzYrx zzYrx2 : zzXKX2.zzWIW()) {
                String string = zzXKX2.zzab(zzYrx2);
                zzXKX zzXKX3 = zzZqY2.zzYlW(string);
                zzXKX zzXKX4 = zzZqY2.zzab(zzXKX3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzZIu zzZIu2 = zzZRr.zzZL8(zzXKX4.zzXwm().zzX4k());
                zzZ0i.zzab(zzXKX3.zzY1N(), zzZIu2, new zzYk0(zzZqY2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

