/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzC5;
import com.aspose.words.internal.zzEE;
import com.aspose.words.internal.zzVUV;
import com.aspose.words.internal.zzW0l;
import com.aspose.words.internal.zzW1I;
import com.aspose.words.internal.zzW1P;
import com.aspose.words.internal.zzWea;
import com.aspose.words.internal.zzWmf;
import com.aspose.words.internal.zzXUv;
import com.aspose.words.internal.zzXyw;
import com.aspose.words.internal.zzY4W;
import com.aspose.words.internal.zzYFm;
import com.aspose.words.internal.zzYLT;
import com.aspose.words.internal.zzYUu;
import com.aspose.words.internal.zzYkh;
import com.aspose.words.internal.zzYn0;
import com.aspose.words.internal.zzZgP;
import com.aspose.words.internal.zzpD;
import com.aspose.words.zz94;
import com.aspose.words.zzVPF;
import com.aspose.words.zzVXz;
import com.aspose.words.zzW4C;
import com.aspose.words.zzW8d;
import com.aspose.words.zzWDf;
import com.aspose.words.zzWDu;
import com.aspose.words.zzWWQ;
import com.aspose.words.zzWX0;
import com.aspose.words.zzWZJ;
import com.aspose.words.zzWen;
import com.aspose.words.zzWoF;
import com.aspose.words.zzWpt;
import com.aspose.words.zzWrE;
import com.aspose.words.zzWxQ;
import com.aspose.words.zzX8m;
import com.aspose.words.zzXWd;
import com.aspose.words.zzXfD;
import com.aspose.words.zzXjM;
import com.aspose.words.zzXvs;
import com.aspose.words.zzY67;
import com.aspose.words.zzYI;
import com.aspose.words.zzYJa;
import com.aspose.words.zzYPz;
import com.aspose.words.zzYVl;
import com.aspose.words.zzYlK;
import com.aspose.words.zzYlf;
import com.aspose.words.zzYqK;
import com.aspose.words.zzYrE;
import com.aspose.words.zzZ5X;
import com.aspose.words.zzZB8;
import com.aspose.words.zzZMb;
import com.aspose.words.zzZTI;
import com.aspose.words.zzZTn;
import com.aspose.words.zzZek;
import com.aspose.words.zzZnd;
import com.aspose.words.zzZp4;
import com.aspose.words.zzZqx;
import com.aspose.words.zzb4;
import com.aspose.words.zzfX;
import com.aspose.words.zzoX;
import com.aspose.words.zzsB;
import com.aspose.words.zzsj;
import com.aspose.words.zzyJ;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWDf,
zzWpt,
zzXjM,
zzYlf {
    private Document zzYXQ;
    private Node zzYlj;
    private Node zzYBd;
    private zzZnd zzWXO;
    private Font zzWFM;
    private zzYLT<zzZnd> zzYSi;
    private zzYLT<zzY67> zzY0P;
    private zzYLT<zzab> zzWLz;
    private zzWxQ zzZnL = zzWxQ.zzYEk();
    private zzW4C zzYPM = new zzW4C();
    private zzY67 zzZOu;
    private RowFormat zzZQW;
    private CellFormat zzbS;
    private ParagraphFormat zzfz;
    private zzYLT<zzb4> zzy4;
    private int zzWzR = 0;
    private int zzWEu = -1;
    private int zzZbI;
    private boolean zzYID;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzWmh(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzWmh(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzWmh(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzab(documentBuilder.getCurrentSection(), zzYJa.zzX07(headerFooterType), 0, 0);
    }

    private void zzWmh(int n, int n2, int n3, int n4) {
        this.zzYXQ.ensureMinimum();
        Section section = (Section)this.zzYXQ.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzab(section, 1, n3, n4);
    }

    private void zzab(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYJa.zzZ84(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzYXQ, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzYXQ));
            }
        }
        this.zzab(story, n2, n3);
    }

    private void zzab(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzab((CompositeNode)paragraph2, n3);
    }

    final void zzab(Paragraph paragraph, int n) {
        this.zzab((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzWPv().zzYW() ? zzXWd.zztk(this.zzYXQ, fieldName) : zzXWd.zzVQt(this.zzWPv(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzab(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzab(field, isAfter, false);
    }

    private boolean zzab(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzWoF zzWoF2 = field.getFormat().zzZtc();
        Inline inline = zzWoF2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzab(inline.zzVUL(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzYqK.zzab(this.zzYXQ, bookmarkName) : zzYqK.zzYCO(this.zzYXQ, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzXFk() == 6) {
            this.zzab((Paragraph)node.zzXuR(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzZTI.zzZM9(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzab(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzab(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzYCO(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzab(structuredDocumentTag);
            return;
        }
        this.zzzD(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzZHY(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzab(cell, characterIndex);
    }

    private void zzab(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzXFk() == 6) {
            this.zzXvs(node);
        } else {
            Node node2 = node;
            if (zzZTI.zzY0J(node2.getNodeType())) {
                Paragraph paragraph = zzZTI.zzZM9(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzXvs(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzXFk() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzXvs(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzZbI = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzYMc();
            return;
        }
        if (!this.zzVOJ()) {
            this.zzYMc();
        }
    }

    private boolean zzVOJ() {
        Node node = this.zzWPv();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzWPv().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzab(((StructuredDocumentTag)documentBuilder.zzWPv().getParentNode()).zzW52(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzWPv(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzab(inline.zzVUL(), true);
            return true;
        }
        return false;
    }

    private void zzYMc() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzab(documentBuilder.getCurrentParagraph().zzXbP(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZHY(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzWP5() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzWPv().zzYVR(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZLI();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzab((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzZop(text, false);
    }

    public void writeln(String text) {
        this.zzZop(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        this.zzXMq();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzsj zzsj2 = new zzsj(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzYXQ, this.zzNl(), this.zzwM());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzYCO(this.zzWPv(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzsj2.dispose();
        }
        if (this.getDocument().zzYnM()) {
            zzZTI.zzzD((zzZ5X)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzZGr());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzZiT() {
        zzZnd zzZnd2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzXMq();
        Node node = this.zzWPv();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzW3x(false);
        } else {
            run2 = run = (Run)node.zzYWE(21);
        }
        if (run2 == null && zzYkh.zzbR(node, paragraph.zzYuY())) {
            run = paragraph.zzYuY();
        }
        if (run != null) {
            cloneable = run.zzVUL();
            zzZnd2 = (zzZnd)((zzXvs)cloneable).zzY1s();
        } else {
            cloneable = paragraph.zzXbP();
            zzZnd2 = (zzZnd)((zzXvs)cloneable).zzY1s();
        }
        zzZnd zzZnd3 = zzZnd2;
        Paragraph paragraph2 = new Paragraph(this.zzYXQ, this.zzNl(), zzZnd3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzsj zzsj2 = new zzsj(this.zzYXQ);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzYCO(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzsj2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzW8d.zztk(this);
    }

    public void insertBreak(int breakType) {
        this.zzWje(breakType, true);
    }

    final void zzWje(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzZhd(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzZCI(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzWjb())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzZhd(bl)) {
                        this.zzZCI(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzZhd(bl)) {
                        this.zzYdj(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzZhd(bl)) {
                        this.zzYdj(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzZhd(bl)) {
                        this.zzYdj(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzZhd(bl)) {
                        this.zzYdj(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzZhd(bl)) {
                        this.zzYdj(4);
                    }
                    return;
                }
                case 8: {
                    this.zzZCI(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzWmf.zzZCw(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzW1I.zzYCO("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzXMq();
        return zzZTI.zzab(fieldType, updateField, this.zzwM(), this.zzZdn(), this.zzx7(), this.zzx7() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzXMq();
        return zzZTI.zzab(fieldCode, this.zzwM(), this.zzZdn(), this.zzx7(), this.zzx7() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzXMq();
        return zzZTI.zzab(fieldCode, fieldValue, this.zzwM(), this.zzZdn(), this.zzx7(), this.zzx7() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzYkh.zzYCO((Object)displayText, "displayText");
        zzYkh.zzYCO((Object)urlOrBookmark, "hrefOrBookmark");
        zzZB8 zzZB82 = this.zzYCO(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzZB82.zzYCO(documentBuilder.zzZBk(88, true));
        return zzZTI.zzab(zzZB82.getStart(), zzZB82.getSeparator(), zzZB82.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzYRz(70);
        if (zzWmf.zzZCw(name)) {
            this.startBookmark(name);
        }
        this.zzYPK(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzYFm(70);
        String string = zzWmf.zzZCw(fieldValue) ? fieldValue : FormField.zzX4D;
        Run run = new Run(this.zzYXQ, string, this.zzwM());
        this.insertNode(run);
        Node node = this.zzZBk(70, true);
        if (zzWmf.zzZCw(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzfX(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzab((Paragraph)node.zzXuR(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzYRz(71);
        if (zzWmf.zzZCw(name)) {
            this.startBookmark(name);
        }
        this.zzYPK(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzZBk(71, false);
        if (zzWmf.zzZCw(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzfX(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzYRz(83);
        if (zzWmf.zzZCw(name)) {
            this.startBookmark(name);
        }
        this.zzYPK(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzZBk(83, false);
        if (zzWmf.zzZCw(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzfX(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzYXQ, footnoteType, !zzWmf.zzZCw(referenceMark), referenceMark, this.zzwM());
        Style style = this.getDocument().getStyles().zzXba(zzZTI.zzXRh(footnoteType));
        footnote.zzVUL().set(50, style.zzYgV());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzYXQ);
        Style style2 = this.getDocument().getStyles().zzXba(zzZTI.zzYlG(footnoteType));
        paragraph.zzZ0a().set(1000, style2.zzYgV());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzYXQ, '\u0002', new zzZnd()) : new Run(this.zzYXQ, footnote.getReferenceMark(), new zzZnd());
        inline.zzVUL().set(50, style.zzYgV());
        paragraph.appendChild(inline);
        if (zzWmf.zzZCw(footnoteText)) {
            Node node = this.zzWPv();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzXvs(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZAG(zzEE zzEE2) throws Exception {
        return this.zzab(zzEE2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZAG(zzEE.zzYCO(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzab(zzEE zzEE2, double d, double d2) throws Exception {
        return this.zzab(zzEE2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzab(zzEE.zzYCO(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zzC5 zzC52 = new zzC5();
        try {
            zzXUv.zzab(image, zzC52);
            Shape shape = this.zzab(zzC52, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zzC52.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzYkh.zzzD(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzWea.zzXhy(fileName);
        try {
            Shape shape = this.zzab((zzEE)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzEE)object).close();
            }
        }
    }

    private Shape zzab(zzEE zzEE2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzEE2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzYkh.zzYP9(zzEE2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzab(zzEE.zzYCO(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzab(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzab(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzYUu.zzY2S(object)) {
            object4 = new zzXUv((byte[])object);
            bl2 = true;
            ((zzpD)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzYXQ.getCompatibilityOptions().getMswVersion() > 12 || this.zzYXQ.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzYXQ, 0);
            object3 = new zzsB();
            ((zzYlK)object3).zzab(zzWZJ.zzev("rect"));
            ((zzsB)object3).zzab(new zzWrE());
            ((zzsB)object3).zzY7l().zzBS().zzzD(this.zzYXQ);
            object2 = new zzWX0();
            ((zzVPF)object2).zzYCO(new zzWen(this.zzYXQ.zzZNd(), ""));
            ((zzVPF)object2).zzab(new zzWWQ());
            ((zzyJ)object3).zzab((zzVPF)object2);
            shape.zzVZE(75);
            shape.zzYP9((zzyJ)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzYXQ, 75);
        }
        if (zzYUu.zzXUv(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzab((byte[])object, new zzZMb(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzZMb(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzYUu.zzYBf((byte[])object2));
                this.zzab((zzsB)shape.zzZLo(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzsB)shape.zzZLo()).zzY7l().zzBS().zzZ9N((byte[])object);
            object3 = zzYUu.zzDn(object);
            object4 = new zzZMb(((zzZgP)object3).getWidthPoints(), ((zzZgP)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzab(this.zzwM());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzYUu.zzWpH(object)) {
            d5 = DocumentBuilder.zzab(shape, object);
        }
        shape.zzab(d3, d4, (zzZMb)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzab(Shape shape, byte[] byArray) throws Exception {
        int n = zzYUu.zzYqK(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzZTI.zzXPb(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzZTI.zzZeO(n);
        return d;
    }

    private void zzab(zzsB zzsB2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzsB2.zzY7l().zzBS().getExtensions();
        zzC5 zzC52 = new zzC5(byArray);
        try {
            object = zzZTI.zzab(zzC52, this.zzYXQ);
            ((zzYVl)object).zzZ2b(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzYVl)object).zzZgJ();
            byArray2 = ((zzYVl)object).zzZjf(true);
        }
        finally {
            zzC52.close();
        }
        zzsB2.zzY7l().zzBS().setExtensions(new zzYFm<zzYrE>());
        object = zzYrE.zzab(byArray2, this.zzYXQ);
        zzsB2.zzY7l().zzBS().getExtensions().zzjS(((zzYrE)object).getUri(), (zzYrE)object);
    }

    private Shape zzab(zzEE zzEE2, String string, boolean bl, zzEE zzEE3) throws Exception {
        zzZp4 zzZp42 = zzZp4.zzXrS(string);
        Shape shape = this.zzab(zzEE3, bl, zzZp42, null);
        zzYI zzYI3 = zzVXz.zzab(zzEE2, string, bl);
        return DocumentBuilder.zzab(null, false, shape, zzZp42.zzX6Q, zzYI3);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzab(zzEE.zzYCO(stream), progId, asIcon, zzEE.zzYCO(presentation));
    }

    private Shape zzab(String string, boolean bl, boolean bl2, zzEE zzEE2) throws Exception {
        zzZp4 zzZp42 = zzZp4.zzWZy(zzXyw.zzW3(string));
        return this.zzab(string, bl, bl2, zzEE2, zzZp42);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzab(fileName, isLinked, asIcon, zzEE.zzYCO(presentation));
    }

    private Shape zzab(String string, String string2, boolean bl, boolean bl2, zzEE zzEE2) throws Exception {
        zzZp4 zzZp42 = zzZp4.zzXrS(string2);
        return this.zzab(string, bl, bl2, zzEE2, zzZp42);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzab(fileName, progId, isLinked, asIcon, zzEE.zzYCO(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZp4 zzZp42 = zzZp4.zzWZy(zzXyw.zzW3(fileName));
        return this.zzab(fileName, isLinked, iconFile, iconCaption, zzZp42);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZp4 zzZp42 = zzZp4.zzXrS(progId);
        return this.zzab(fileName, isLinked, iconFile, iconCaption, zzZp42);
    }

    private Shape zzab(zzEE zzEE2, String string, String string2, String string3) throws Exception {
        zzZp4 zzZp42 = zzZp4.zzXrS(string);
        Shape shape = this.zzab(string2, string3, zzZp42);
        zzYI zzYI3 = zzVXz.zzab(zzEE2, string, true);
        return DocumentBuilder.zzab(null, false, shape, zzZp42.zzX6Q, zzYI3);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzab(zzEE.zzYCO(stream), progId, iconFile, iconCaption);
    }

    final Shape zzab(zzX8m zzX8m2, zzEE zzEE2) throws Exception {
        Shape shape = this.zzYEc(zzEE2);
        shape.zzVZE(201);
        shape.getOleFormat().zzYCO(zzX8m2.zzZ35());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzXMq();
        if (this.zzYW4()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzYYZ(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZek zzZek2 = zzZTI.zzab(html, options, this);
        zzZek2.zzNt();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzXMq();
        return zzZTI.zzab(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzXMq();
        return zzZTI.zzab(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzoX zzoX2 = new zzoX();
        return zzoX2.zzab(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYPz(this).zzab(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYPz(this).zzab(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzYXQ, 75);
        shape.zzab(this.zzwM());
        shape.zzYGm(true);
        shape.getSignatureLine().zzab(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzVXt(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzrj(this.zzYXQ);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzYW4() {
        boolean bl = false;
        if (this.zzWPv().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzWPv().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzYYZ(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzXMq();
        if (this.zzWP5() == null) {
            this.startTable();
        }
        if (this.zzWP5().zzy9() == 1) {
            this.zzWP5().zzXpX();
        }
        if (this.zzWP5().zzy9() == 3) {
            this.zzWP5().zzX2h();
        }
        return this.zzWP5().zzZ1e();
    }

    public Table startTable() {
        this.zzy4.push(new zzb4(this));
        return this.zzWP5().startTable();
    }

    public Table endTable() {
        if (this.zzWP5() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzWP5().endTable();
        this.zzy4.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzWP5() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzWP5().endRow();
        if (this.zzWFM != null && this.zzWFM.getHidden()) {
            row.zzW26().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYXQ, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYXQ, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzW2p();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYXQ, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzXcq();
        bookmarkStart.zzWqv(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzW2p();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzXcq();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYXQ, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzZrW(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzYXQ);
        this.zzWEu = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzWEu == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYXQ, this.zzWEu);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYXQ, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzYkh.zzYCO((Object)importFormatOptions, "ImportFormatOptions");
        this.zzXMq();
        return zzZTn.zzab(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzYXQ;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzYXQ) {
            return;
        }
        this.zzYXQ = value;
        this.zzXvs(null);
        this.zzWXO = new zzZnd();
        this.zzYSi = null;
        this.zzY0P = null;
        this.zzWFM = null;
        this.zzy4 = new zzYLT();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzWFM == null) {
            DocumentBuilder documentBuilder = this;
            this.zzWFM = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzWFM;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzfz == null) {
            DocumentBuilder documentBuilder = this;
            this.zzfz = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzfz;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZQW == null) {
            this.zzZQW = new RowFormat(this);
        }
        return this.zzZQW;
    }

    public CellFormat getCellFormat() {
        if (this.zzbS == null) {
            this.zzbS = new CellFormat(this);
        }
        return this.zzbS;
    }

    final void zzXRj(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzZnd zzZnd2;
        if (this.getCurrentParagraph() != null) {
            zzZnd zzZnd3 = this.getCurrentParagraph().zzXbP();
            zzZnd2 = (zzZnd)zzZnd3.zzY1s();
        } else {
            zzZnd2 = this.zzwM();
        }
        zzZnd zzZnd4 = zzZnd2;
        this.zzWNr().push(new zzab(this.zzwM(), zzZnd4));
    }

    public void popFont() {
        zzYLT<zzab> zzYLT2 = this.zzWNr();
        if (zzYLT2.size() > 0) {
            zzab zzab2 = (zzab)this.zzWNr().pop();
            this.zzab(zzab2.zzVUL(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzWyg(zzab2.zzXBO());
            }
        }
    }

    final void zzXIb() {
        this.zzZnK().push(this.zzwM());
    }

    final void zzYyg() {
        zzYLT<zzZnd> zzYLT2 = this.zzZnK();
        if (zzYLT2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzab((zzZnd)documentBuilder.zzZnK().pop(), false);
        }
    }

    final void zzW20() {
        this.zzXhJ().push(this.zzNl());
    }

    final void zzXAR() {
        zzYLT<zzY67> zzYLT2 = this.zzXhJ();
        if (zzYLT2.size() > 0) {
            zzY67 zzY672 = (zzY67)this.zzXhJ().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzab(zzY672);
            }
        }
    }

    final zzZB8 zzYCO(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzYRz(88);
        zz94 zz942 = new zz94();
        zz942.setTarget(string2);
        zz942.setScreenTip(string3);
        if (bl) {
            zz942.setSubAddress(string);
        } else {
            zz942.setAddress(zzW0l.zzY0N(string));
            zz942.setSubAddress(zzW0l.zzXaR(string));
        }
        this.zzYPK(zz942.zzWOn());
        FieldSeparator fieldSeparator = this.zzYFm(88);
        return new zzZB8(fieldStart, fieldSeparator, null);
    }

    final zzZB8 zzXcf(String string, String string2, String string3) {
        boolean bl = zzW0l.zzRw(string);
        String string4 = bl ? zzW0l.zzXaR(string) : string;
        return this.zzYCO(string4, bl, string2, string3);
    }

    final FieldEnd zzWhN() {
        return this.zzZBk(88, true);
    }

    final zzZnd zzwM() {
        zzZnd zzZnd2 = this.zzWXO;
        return (zzZnd)zzZnd2.zzY1s();
    }

    final zzY67 zzNl() {
        zzY67 zzY672 = this.zzZ0a();
        return (zzY67)zzY672.zzY1s();
    }

    final zzWxQ zzjI() {
        zzWxQ zzWxQ2 = this.zzW26();
        return (zzWxQ)zzWxQ2.zzY1s();
    }

    final zzW4C zzWYK() {
        zzW4C zzW4C2 = this.zzY6R();
        return (zzW4C)zzW4C2.zzY1s();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzWPv(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzWPv().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzYID && this.zzWPv().getNodeType() == 28;
    }

    private void zzZop(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzWPv()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzYJa.zzYvz(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzZEA(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWzR) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZCI(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzZEA(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzXMq();
        if (this.zzWP5() != null && this.zzWP5().zzy9() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzWPv().getParentNode().insertBefore(node, this.zzWPv());
    }

    final void zzF4(int n) {
        this.zzZhd(true);
        this.zzYdj(n);
    }

    private void zzYdj(int n) {
        this.insertParagraph();
        zzsj zzsj2 = new zzsj(this.getDocument());
        try {
            zzWDu zzWDu2 = this.getCurrentSection().zzZHM();
            zzWDu zzWDu3 = (zzWDu)zzWDu2.zzY1s();
            Section section = new Section(this.zzYXQ, zzWDu3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzYXQ));
            this.zzYXQ.insertAfter(section, this.getCurrentSection());
            section.getBody().zzYCO(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzsj2.dispose();
        }
    }

    final FieldStart zzYRz(int n) {
        this.zzXMq();
        return zzZTI.zzab(n, this.zzwM(), this.zzZdn(), this.zzx7(), this.zzx7() == null);
    }

    final Run zzYPK(String string) {
        return zzZTI.zzYCO(string, this.zzwM(), this.zzZdn(), this.zzx7(), this.zzx7() == null);
    }

    final FieldEnd zzZBk(int n, boolean bl) {
        return zzZTI.zzYCO(n, bl, this.zzwM(), this.zzZdn(), this.zzx7(), this.zzx7() == null);
    }

    final FieldSeparator zzYFm(int n) {
        return zzZTI.zzYCO(n, this.zzwM(), this.zzZdn(), this.zzx7(), this.zzx7() == null);
    }

    private FormField zzfX(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzYXQ, new zzZqx(), this.zzwM());
        CompositeNode compositeNode = node == null ? this.zzZdn() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzZhd(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzWP5() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZHY(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzZEA(String string) {
        if (this.zzY00(string)) {
            zzVUV zzVUV2 = new zzVUV(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzW1P zzW1P2 : zzVUV2.zzXe9(this.getParagraphFormat().getBidi())) {
                zzfX zzfX2 = zzfX.zzWCy(zzW1P2.zzY2c());
                zzZnd zzZnd2 = this.zzwM();
                zzZnd2.zzWmh(265, zzfX2);
                if (zzW1P2.zzYF()) {
                    zzZnd2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzYXQ, zzW1P2.getText(), zzZnd2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZCI(string);
    }

    private boolean zzY00(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzYn0.zzWsb(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzab(zzZnd zzZnd2, boolean bl) {
        zzZnd zzZnd3;
        if (bl) {
            zzZnd zzZnd4 = zzZnd2;
            zzZnd3 = (zzZnd)zzZnd4.zzY1s();
        } else {
            zzZnd3 = zzZnd2;
        }
        this.zzWXO = zzZnd3;
    }

    final void zzzy() {
        this.zzWXO.clear();
    }

    final void zzYh3() {
        if (this.zzW2p() != null) {
            zzW4C zzW4C2;
            zzW4C zzW4C3 = zzW4C2 = this.zzW2p().zzY6R();
            this.zzYPM = (zzW4C)zzW4C3.zzY1s();
            zzW4C2.zzYCO(this.zzYPM);
        }
    }

    private Shape zzab(String string, boolean bl, boolean bl2, zzEE zzEE2, zzZp4 zzZp42) throws Exception {
        if (zzZp42 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzab(zzEE2, bl2, zzZp42, string);
        zzYI zzYI3 = zzVXz.zzab(string, bl, bl2, zzZp42);
        return DocumentBuilder.zzab(string, bl, shape, zzZp42.zzX6Q, zzYI3);
    }

    private Shape zzab(String string, boolean bl, String string2, String string3, zzZp4 zzZp42) throws Exception {
        if (zzZp42 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzXyw.zz2s(string);
        }
        Shape shape = string2 != null ? this.zzDn(string2, string3) : this.zzab(null, string3, zzZp42);
        zzYI zzYI3 = zzVXz.zzab(string, bl, true, zzZp42);
        return DocumentBuilder.zzab(string, bl, shape, zzZp42.zzX6Q, zzYI3);
    }

    private static Shape zzab(String string, boolean bl, Shape shape, String string2, zzYI zzYI3) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzVZE(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzYCO(zzYI3);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzab(zzEE zzEE2, boolean bl, zzZp4 zzZp42, String string) throws Exception {
        if (zzZp42 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzEE2 != null) {
            return this.zzYEc(zzEE2);
        }
        if (!bl) {
            return this.zzXWo(zzVXz.zzYEr().get("normal"));
        }
        String string2 = string != null ? zzXyw.zz2s(string) : zzVXz.zziL(zzZp42.zz7y);
        return this.zzab(zzZp42, string2);
    }

    private Shape zzab(String string, String string2, zzZp4 zzZp42) throws Exception {
        if (zzZp42 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzVXz.zziL(zzZp42.zz7y);
        }
        if (string != null) {
            return this.zzDn(string, string2);
        }
        return this.zzab(zzZp42, string2);
    }

    private Shape zzab(zzZp4 zzZp42, String string) throws Exception {
        if (zzZp42 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzVXz.zzY0J(zzZp42.zz7y);
        zzY4W zzY4W2 = new zzY4W(byArray, null, string, this.getDocument().zzXDv());
        return this.zzXWo(zzY4W2.zzXOz());
    }

    private Shape zzDn(String string, String string2) throws Exception {
        zzY4W zzY4W2 = new zzY4W(string, string2, this.getDocument().zzXDv());
        return this.zzXWo(zzY4W2.zzXOz());
    }

    private Shape zzYEc(zzEE zzEE2) throws Exception {
        byte[] byArray = zzYkh.zzYP9(zzEE2);
        return this.zzXWo(byArray);
    }

    private Shape zzXWo(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzYXQ, 1);
        shape.zzVZE(75);
        shape.zzab(this.zzwM());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzVXt(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzab(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzYCO(compositeNode, n);
            return;
        }
        this.zzzD(compositeNode, n);
    }

    private void zzYCO(CompositeNode compositeNode, int n) {
        zzXfD zzXfD2 = zzXfD.zzYXJ(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzXfD2.zzab(null, true, true, true, false, true);
            node = zzXfD2.getNode();
            if (zzXfD2.zzZhq() && (!node.isComposite() || node.zzXFk() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzYie().length() : node.getTextLength();
            if (!zzXfD2.zzZhq() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzXfD2.zzZhq() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzab((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzab(null, node);
            this.zzZbI = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzab(StructuredDocumentTag structuredDocumentTag) {
        this.zzXvs(structuredDocumentTag);
        this.zzYID = true;
        this.zzZbI = 0;
        zzZnd zzZnd2 = structuredDocumentTag.zzW52();
        switch (structuredDocumentTag.zzXFk()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzXa6(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzZnd2 = ((Inline)node).zzVUL();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzZnd2 = paragraph.zzXbP();
                break;
            }
            default: {
                return;
            }
        }
        this.zzab(zzZnd2, true);
    }

    private void zzzD(CompositeNode compositeNode, int n) {
        zzXfD zzXfD2 = zzXfD.zzZBT(compositeNode);
        while (zzXfD2.getNode() != compositeNode || !zzXfD2.zzZhq()) {
            int n2;
            Node node = zzXfD2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzYie().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzab(null, node);
                this.zzZbI = n;
                return;
            }
            while (zzXfD2.zzab(null, false, true, true, false, true) && zzXfD2.zzZhq() && zzXfD2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzXMq() {
        int n = this.zzZbI;
        if (n == 0) {
            return;
        }
        this.zzZbI = 0;
        Run run = zzYkh.zzab((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzXJ8(n);
        }
    }

    private Run zzZCI(String string) {
        Run run = new Run(this.zzYXQ, string, this.zzwM());
        this.insertNode(run);
        return run;
    }

    final boolean zzEn() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzWCu() {
        return this.zzWzR;
    }

    final void zzyc(int n) {
        this.zzWzR = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzWPv();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzWPv();
        }
        return (Paragraph)this.zzWPv().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzWPv();
        }
        return (StructuredDocumentTag)this.zzWPv().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzWPv().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzb4 zzWP5() {
        zzYLT<zzb4> zzYLT2 = this.zzy4;
        if (zzYLT2.size() > 0) {
            return (zzb4)this.zzy4.peek();
        }
        return null;
    }

    private Cell zzW2p() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzw1();
    }

    private CompositeNode zzZdn() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzWPv();
        }
        return this.zzWPv().getParentNode();
    }

    private Node zzx7() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzWPv();
    }

    private zzYLT<zzZnd> zzZnK() {
        if (this.zzYSi == null) {
            this.zzYSi = new zzYLT();
        }
        return this.zzYSi;
    }

    private zzYLT<zzY67> zzXhJ() {
        if (this.zzY0P == null) {
            this.zzY0P = new zzYLT();
        }
        return this.zzY0P;
    }

    private zzYLT<zzab> zzWNr() {
        if (this.zzWLz == null) {
            this.zzWLz = new zzYLT();
        }
        return this.zzWLz;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzWXO.zzYlJ(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZd2(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZd2(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzWXO.zzWmh(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZaM()) {
            this.getCurrentParagraph().zzXbP().zzWmh(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzWXO.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzWXO.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZaM()) {
            this.getCurrentParagraph().zzXbP().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzZ0a().zzYlJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzZ0a().zzYkh(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzYyY(key, 0);
        }
        return this.getDocument().getStyles().zzW76().zzkw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzZ0a().zzWmh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzZ0a().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzZ0a().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzW26().zzYlJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzW26().zzkw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzW26().zzXV4(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzW26().zzWmh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzW26().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzW26().clear();
        zzWxQ.zzYEk().zzYCO(this.zzW26());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzY6R().zzYlJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzY6R().zzkw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzY6R().zzXV4(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzYkh.zzab(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzW2p() != null ? this.zzW2p().getCellFormat() : this.getCellFormat();
            border.zzab(cellFormat);
        }
        this.zzY6R().zzWmh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzY6R().clear();
    }

    private Node zzWPv() {
        Node node = this.zzYlj != null && this.zzYlj.getParentNode() == null ? this.zzYBd : this.zzYlj;
        if (node != null && node.zzXFk() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzYID = this.zzYID && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzXvs(Node node) {
        this.zzYlj = node;
        if (this.zzYlj != null) {
            this.zzYBd = this.zzYlj.getParentNode();
        }
        this.zzYID = false;
    }

    private zzY67 zzZ0a() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzZ0a();
        }
        if (this.zzZOu == null) {
            this.zzZOu = new zzY67();
        }
        return this.zzZOu;
    }

    private zzWxQ zzW26() {
        if (this.zzWP5() != null && this.zzWP5().zzy9() == 1) {
            return this.zzZnL;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzW26();
        }
        return this.zzZnL;
    }

    private zzW4C zzY6R() {
        if (this.zzWP5() != null && this.zzWP5().zzy9() != 3) {
            return this.zzYPM;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzw1().zzY6R();
        }
        return this.zzYPM;
    }

    static final class zzab {
        private zzZnd zzWXO;
        private zzZnd zzWCl;

        public zzab(zzZnd zzZnd2, zzZnd zzZnd3) {
            this.zzWXO = zzZnd2;
            this.zzWCl = zzZnd3;
        }

        public final zzZnd zzVUL() {
            return this.zzWXO;
        }

        public final zzZnd zzXBO() {
            return this.zzWCl;
        }
    }
}

