/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzW1I;
import com.aspose.words.internal.zzYkh;
import com.aspose.words.zzWDu;
import com.aspose.words.zzYuX;
import com.aspose.words.zzZZr;

public final class Section
extends CompositeNode<Node>
implements zzYuX {
    private zzWDu zzZKi;
    private PageSetup zzY2o;
    private HeaderFooterCollection zzYs2;

    public Section(DocumentBase doc) {
        this(doc, new zzWDu());
    }

    Section(DocumentBase doc, zzWDu sectPr) {
        super(doc);
        this.zzZKi = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzYs2 == null) {
            this.zzYs2 = new HeaderFooterCollection(this);
        }
        return this.zzYs2;
    }

    public final PageSetup getPageSetup() {
        if (this.zzY2o == null) {
            Section section = this;
            this.zzY2o = new PageSetup(section, section.getDocument().zzWR1(), this.getDocument().getStyles(), new zzab(this));
        }
        return this.zzY2o;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzYlO();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzXJD(!value);
    }

    final zzWDu zzZHM() {
        return this.zzZKi;
    }

    final void zzzD(zzWDu zzWDu2) {
        this.zzZKi = zzWDu2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzab(boolean bl, zzZZr zzZZr2) {
        zzWDu zzWDu2;
        Section section = (Section)super.zzab(bl, zzZZr2);
        zzWDu zzWDu3 = this.zzZKi;
        section.zzZKi = zzWDu2 = (zzWDu)zzWDu3.zzY1s();
        section.zzY2o = null;
        section.zzYs2 = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzab(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzYCO(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzWpk(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzWpk(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzNg(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzVQt(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzNg(n) == null;
            }
        }
        return false;
    }

    final void zzzD(Shape shape, boolean bl) throws Exception {
        this.zzab(shape, 4, bl);
        this.zzab(shape, 0, bl);
        this.zzab(shape, 1, bl);
    }

    private void zzab(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzZNd());
        shape2.setName(zzW1I.zzYCO("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzZUS() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZGD()) {
                if (!shape.zzZ3Z()) continue;
                shape.remove();
            }
        }
    }

    private void zzWpk(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzYCO(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzZKi.zzYlJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzWR1().zzWoB.zzkw(key);
        }
        return zzWDu.zzYtM(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzZKi.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzWR1().zzWoB.zzWmh(key, value);
            return;
        }
        this.zzZKi.zzWmh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzZKi.clear();
    }

    final boolean zzXgm() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZyv() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzab
    implements zzYuX {
        private Section zzZF5;

        zzab(Section section) {
            this.zzZF5 = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzFT().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzFT().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzFT().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzYuX zzFT() {
            Document document = zzYkh.zzab((Object)this.zzZF5.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzZF5;
        }
    }
}

