/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWIW;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzWYa;
import com.aspose.words.net.System.Data.zzYCO;
import com.aspose.words.net.System.Data.zzYP9;
import com.aspose.words.net.System.Data.zzzD;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzIP;
    private final DataColumnCollection zzXXb;
    private final ConstraintCollection zzYqV;
    private final zzWYa zz02;
    private ResultSet zzYLO;
    private String zzWls;
    private DataSet zzWYi;
    private String zzWIl;
    private UniqueConstraint zzYQA;
    private boolean zzZH0;
    private final List<DataTableEventListener> zzpQ;
    private final Set<DataRow> zzXfs;
    private DataRelationCollection zzdw;

    public DataTable() {
        this.zzIP = new DataRowCollection(this);
        this.zzXXb = new DataColumnCollection(this);
        this.zzYqV = new ConstraintCollection(this);
        this.zz02 = new zzWYa(this);
        this.zzWIl = "";
        this.zzZH0 = true;
        this.zzpQ = new ArrayList<DataTableEventListener>();
        this.zzXfs = new HashSet<DataRow>();
        this.zzdw = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzIP = new DataRowCollection(this);
        this.zzXXb = new DataColumnCollection(this);
        this.zzYqV = new ConstraintCollection(this);
        this.zz02 = new zzWYa(this);
        this.zzWIl = "";
        this.zzZH0 = true;
        this.zzpQ = new ArrayList<DataTableEventListener>();
        this.zzXfs = new HashSet<DataRow>();
        this.zzdw = new DataRelationCollection();
        this.zzWls = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYCO.zzab(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzIP = new DataRowCollection(this);
        this.zzXXb = new DataColumnCollection(this);
        this.zzYqV = new ConstraintCollection(this);
        this.zz02 = new zzWYa(this);
        this.zzWIl = "";
        this.zzZH0 = true;
        this.zzpQ = new ArrayList<DataTableEventListener>();
        this.zzXfs = new HashSet<DataRow>();
        this.zzdw = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzYLO = resultSet;
        this.zzWls = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzYLO != null) {
            if (this.zzYLO.getStatement() != null) {
                this.zzYLO.getStatement().getConnection().close();
            }
            this.zzYLO = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzWls;
    }

    public void setTableName(String tableName) {
        this.zzWls = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXXb.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXXb.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzYLO;
    }

    public DataSet getDataSet() {
        return this.zzWYi;
    }

    final void zzWpk(DataSet dataSet) {
        this.zzWYi = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzWYi.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzdw.add(dataRelation);
        }
        return this.zzdw;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzWYi.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzIP;
    }

    public DataColumnCollection getColumns() {
        return this.zzXXb;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzYqV;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYQA == null) {
            return new DataColumn[0];
        }
        return this.zzYQA.getColumns();
    }

    final void zzWYa(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYQA != null) {
                this.zzYQA.zzYzn(false);
                this.getConstraints().remove(this.zzYQA);
                this.zzYQA = null;
            }
            return;
        }
        if (this.zzYQA != null && DataColumn.areColumnSetsTheSame(value, this.zzYQA.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzab(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYQA != null) {
            this.zzYQA.zzYzn(false);
            this.getConstraints().remove(this.zzYQA);
            this.zzYQA = null;
        }
        UniqueConstraint.zzab(this.getConstraints(), uniqueConstraint);
        this.zzYQA = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzWIl;
    }

    public void setNamespace(String namespace) {
        this.zzWIl = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZH0;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZH0 = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXfs.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYCO.zzab(this.getResultSet(), this);
            zzYCO.zzYCO(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzWIW.zzWpk(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYCO.zzjS(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzpQ.contains(listener)) {
            this.zzpQ.add(listener);
        }
    }

    public void removeEventListener(zzzD listener) {
        if (this.zzpQ.contains(listener)) {
            this.zzpQ.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzpQ.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXfs.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzpQ) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXfs.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzpQ) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXfs.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzpQ) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzpQ) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzpQ) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzYP9 zzab(zzYCO[] zzYCOArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzYCOArray.length];
        for (int i = 0; i < zzYCOArray.length; ++i) {
            dataColumnArray[i] = zzYCOArray[i].zzZUk();
        }
        DataTable dataTable = this;
        zzYP9 zzYP92 = dataTable.zz02.zzWpk(dataColumnArray);
        if (zzYP92 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzYP92;
    }

    final zzWYa zzX5r() {
        return this.zz02;
    }

    final Set<DataRow> zzXwg() {
        return this.zzXfs;
    }
}

