/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzXFP;
import com.aspose.words.zz2H;
import com.aspose.words.zz3W;
import com.aspose.words.zz8Y;
import com.aspose.words.zzB4;
import com.aspose.words.zzOl;
import com.aspose.words.zzX3J;
import com.aspose.words.zzXQk;
import com.aspose.words.zzXmV;
import com.aspose.words.zzZmm;
import com.aspose.words.zzlz;

public class Cell
extends CompositeNode<Node>
implements zz3W,
zzB4 {
    private zz8Y zzWAs;
    private CellFormat zzYWB;
    private ParagraphCollection zzWoc;
    private TableCollection zzZjN;

    public Cell(DocumentBase doc) {
        this(doc, new zz8Y());
    }

    Cell(DocumentBase doc, zz8Y cellPr) {
        super(doc);
        this.zzWAs = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzWb0() {
        return (Cell)this.zzVTv();
    }

    public Row getParentRow() {
        return (Row)this.zzXFz();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzYsg() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzYZ8(this, true);
        }
        return -1;
    }

    final int zzWyb() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzWyb();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzYWB == null) {
            this.zzYWB = new CellFormat(this);
        }
        return this.zzYWB;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzWoc == null) {
            this.zzWoc = new ParagraphCollection(this);
        }
        return this.zzWoc;
    }

    public TableCollection getTables() {
        if (this.zzZjN == null) {
            this.zzZjN = new TableCollection(this);
        }
        return this.zzZjN;
    }

    final zz8Y zzZm3() {
        return this.zzWAs;
    }

    final void zzXQW(zz8Y zz8Y2) {
        this.zzWAs = zz8Y2;
    }

    @Override
    final Node zzXQW(boolean bl, zzOl zzOl2) {
        zz8Y zz8Y2;
        Cell cell = (Cell)super.zzXQW(bl, zzOl2);
        zz8Y zz8Y3 = this.zzWAs;
        cell.zzWAs = zz8Y2 = (zz8Y)zz8Y3.zzX81();
        cell.zzYWB = null;
        cell.zzWoc = null;
        cell.zzZjN = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXQW(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzO1(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzXQk.zzXab(this);
    }

    @Override
    final boolean zzXI1(Node node) {
        return zzZmm.zzYSv(node);
    }

    final int zzbA() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzVTv();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWAs.zzVZH(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzWAs.zzVZH(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzX3J zzX3J2 = zzXFP.zzXQW(object, zzX3J.class);
        if (zzX3J2 != null && zzX3J2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZT4(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zz8Y.zzZBU(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzWAs.zzZXO(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWAs.clear();
    }

    private Object zzZT4(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzXFP.zzXQW((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzXQW(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXmV getInsertRevision() {
        Cell cell = this;
        return cell.zzWAs.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXmV value) {
        Cloneable cloneable = this;
        zzXmV zzXmV2 = value;
        cloneable = cloneable.zzWAs;
        ((zzlz)cloneable).zzZXO(14, zzXmV2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXmV getDeleteRevision() {
        Cell cell = this;
        return cell.zzWAs.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXmV value) {
        Cloneable cloneable = this;
        zzXmV zzXmV2 = value;
        cloneable = cloneable.zzWAs;
        ((zzlz)cloneable).zzZXO(12, zzXmV2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz2H getMoveFromRevision() {
        Cell cell = this;
        return cell.zzWAs.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zz2H value) {
        Cloneable cloneable = this;
        zz2H zz2H2 = value;
        cloneable = cloneable.zzWAs;
        ((zzlz)cloneable).zzZXO(13, zz2H2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz2H getMoveToRevision() {
        Cell cell = this;
        return cell.zzWAs.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zz2H value) {
        Cloneable cloneable = this;
        zz2H zz2H2 = value;
        cloneable = cloneable.zzWAs;
        ((zzlz)cloneable).zzZXO(15, zz2H2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzWAs.remove(13);
        cell = this;
        cell.zzWAs.remove(15);
    }

    final zz8Y zzZYA(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zz8Y zz8Y2 = new zz8Y();
        this.zzXQW(3120, zz8Y2);
        this.zzXQW(3140, zz8Y2);
        this.zzXQW(3110, zz8Y2);
        this.zzXQW(3130, zz8Y2);
        this.zzXQW(3090, zz8Y2);
        this.zzXQW(3100, zz8Y2);
        this.zzXQW(3070, zz8Y2);
        this.zzXQW(3080, zz8Y2);
        if (bl && (tableStyle = zzXFP.zzXQW((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzO1(this, zz8Y2);
        }
        this.zzWAs.zzO1((zzlz)zz8Y2);
        return zz8Y2;
    }

    private void zzXQW(int n, zz8Y zz8Y2) {
        zz8Y2.zzZXO(n, this.fetchInheritedCellAttr(n));
    }
}

