/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzWD7;
import com.aspose.words.zzWcY;
import com.aspose.words.zzXDH;
import com.aspose.words.zzXsQ;
import com.aspose.words.zzYCw;
import com.aspose.words.zzYVH;
import com.aspose.words.zzYwi;
import com.aspose.words.zzZAb;
import com.aspose.words.zzZgM;
import com.aspose.words.zzoI;
import com.aspose.words.zzsV;
import com.aspose.words.zzu6;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzsV zzVTp;

    ChartSeriesCollection(zzsV chartSpace) {
        this.zzVTp = chartSpace;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYyP().zzYDL().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYyP().zzYDL().iterator();
    }

    public void removeAt(int index) {
        this.zzYyP().zzZlm(index);
    }

    public void clear() {
        this.zzYyP().zzZwq();
        for (zzYVH zzYVH2 : this.zzVTp.zzcE()) {
            zzYVH2.zzZBr(false);
        }
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXQW(chartSeriesCollection.zzYyP().zzZSS(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXQW(chartSeriesCollection.zzYyP().zzZSS(), seriesName, xValues, yValues);
    }

    private ChartSeries zzXQW(String string, zzWD7[] zzWD7Array, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXQW(chartSeriesCollection.zzYyP().zzZSS(), string, zzWD7Array, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXQW(seriesName, zzWD7.zzXQW(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXQW(chartSeriesCollection.zzYyP().zzZSS(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzXQW(zzYVH zzYVH2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXQW(zzYVH2, string, dArray);
        chartSeries.zz24().zz5u(ChartSeriesCollection.zzYtH(stringArray));
        return chartSeries;
    }

    final ChartSeries zzXQW(zzYVH zzYVH2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXQW(zzYVH2, string, dArray2);
        chartSeries.zz24().zz5u(ChartSeriesCollection.zzZzF(dArray));
        return chartSeries;
    }

    private ChartSeries zzXQW(zzYVH zzYVH2, String string, zzWD7[] zzWD7Array, double[] dArray) {
        if (zzWD7Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzWD7Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzWD7Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXQW(zzYVH2, string, dArray);
        chartSeries.zz24().zz5u(ChartSeriesCollection.zzXQW(zzWD7Array));
        if (!zzYVH2.zzYYp()) {
            zzYVH2.zzZBr(true);
        }
        return chartSeries;
    }

    final ChartSeries zzXQW(zzYVH zzYVH2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzYVH2.zzX0J() != 15) {
            zzYVH2.zzZFG(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXQW(zzYVH2, string, dArray2);
        chartSeries.zzX4Q().zzY14().zzYtH(3, chartSeries.zzWNb().zzhU());
        chartSeries.zz24().zz5u(ChartSeriesCollection.zzZzF(dArray));
        if (dArray3 != null) {
            chartSeries.zzY07().zz5u(ChartSeriesCollection.zzZzF(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzXQW(zzYVH zzYVH2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzYVH2);
        chartSeries.setName(string);
        ChartSeriesCollection.zzZXO(chartSeries);
        chartSeries.zzY3S().zz5u(ChartSeriesCollection.zzZzF(dArray));
        this.zzVTp.zzYG4();
        this.zzYyP().zzZO1(chartSeries);
        return chartSeries;
    }

    private static void zzZXO(ChartSeries chartSeries) {
        chartSeries.zzX4Q().zzY14().zzYtH(5, new zzWcY());
        switch (chartSeries.zzWNb().zzX0J()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXQW(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXQW(chartSeries, 5);
                ChartSeriesCollection.zzW90(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXQW(chartSeries, 1);
                ChartSeriesCollection.zzW90(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzEs(chartSeries);
            }
        }
    }

    private static void zzEs(ChartSeries chartSeries) {
        zzWcY zzWcY2 = new zzWcY();
        zzWcY2.setOutline(new zzu6());
        zzYwi zzYwi2 = new zzYwi();
        zzYwi2.zzX7F(1);
        zzWcY2.getOutline().setFill(new zzXsQ(zzYwi2));
        zzWcY2.getOutline().zzZli(19050.0);
        chartSeries.zzX4Q().zzY14().zzYtH(5, zzWcY2);
    }

    private static void zzW90(ChartSeries chartSeries) {
        zzWcY zzWcY2 = new zzWcY();
        zzWcY2.setOutline(new zzu6());
        zzWcY2.getOutline().setFill(new zzYCw());
        zzWcY2.getOutline().setEndCap(0);
        zzWcY2.getOutline().zzZli(19050.0);
        chartSeries.zzX4Q().zzY14().zzYtH(5, zzWcY2);
    }

    private static void zzXQW(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzWNb());
        chartMarker.zzWlJ().zzYtH(0, n);
        chartSeries.zzX4Q().zzY14().zzYtH(4, chartMarker);
    }

    private static zzoI zzZzF(double[] dArray) {
        int n = 0;
        zzoI zzoI2 = new zzoI(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzoI2.zzWQI(new zzXDH(n, d, "General"));
            }
            ++n;
        }
        zzoI2.zzrW(dArray.length);
        return zzoI2;
    }

    private static zzoI zzXQW(zzWD7[] zzWD7Array) {
        int n = 0;
        zzoI zzoI2 = new zzoI(2);
        zzWD7[] zzWD7Array2 = zzWD7Array;
        int n2 = zzWD7Array.length;
        for (int i = 0; i < n2; ++i) {
            zzWD7 zzWD72 = zzWD7Array2[i];
            zzoI2.zzWQI(new zzXDH(n++, zzWD72.zzYbK(), "m/d/yyyy"));
        }
        zzoI2.zzrW(zzWD7Array.length);
        return zzoI2;
    }

    private static zzoI zzYtH(String[] stringArray) {
        int n = 0;
        zzoI zzoI2 = new zzoI(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzoI2.zzWQI(new zzZAb(n++, string));
        }
        zzoI2.zzrW(stringArray.length);
        return zzoI2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYyP().zzYDL().size();
    }

    private zzZgM zzYyP() {
        return this.zzVTp.zzYDZ().zzYyP();
    }
}

