/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzXFP;
import com.aspose.words.zzOl;
import com.aspose.words.zzPl;
import com.aspose.words.zzVYC;
import com.aspose.words.zzWwt;
import com.aspose.words.zzX21;
import com.aspose.words.zzXNG;
import com.aspose.words.zzYI0;
import com.aspose.words.zzZkc;
import com.aspose.words.zzZmm;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZkc,
Iterable<T> {
    private Node zzKj;
    private Node zzWFt;
    private Node zzZsC;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzX21 zzX212 = new zzX21(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzO1((Node)this, true);
            return;
        }
        finally {
            zzX212.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzIB() {
        return this.zzpo() != null;
    }

    final boolean zzie() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzYvf() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzVYC) {
                return true;
            }
            CompositeNode compositeNode = zzXFP.zzXQW((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzYvf()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzKj;
    }

    public Node getLastChild() {
        return this.zzWFt;
    }

    final Node zzpo() {
        return zzZmm.zzZFa(this.getFirstChild(), false);
    }

    final Node zzVTO() {
        return zzZmm.zzXju(this.getLastChild(), false);
    }

    final CompositeNode zzYzG() {
        return (CompositeNode)zzZmm.zzZFa(this.getFirstChild(), true);
    }

    final CompositeNode zzYfl() {
        return (CompositeNode)zzZmm.zzXju(this.getLastChild(), true);
    }

    final Node zzWAh() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzZmm.zzWC0((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzYtd() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzZmm.zzWC0((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXQW(boolean bl, zzOl zzOl2) {
        CompositeNode compositeNode = (CompositeNode)super.zzXQW(bl, zzOl2);
        ((CompositeNode)super.zzXQW(bl, zzOl2)).zzWFt = null;
        compositeNode.zzKj = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzYFL(node.zzXQW(true, zzOl2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYHW(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzYHW(StringBuilder stringBuilder) {
        this.zzZO1(stringBuilder);
        zzXFP.zzO1(stringBuilder, this.zzZ7Y());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzO1(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzZmm.zzY1m(nodeType);
            Node node2 = node = bl ? this.zzpo() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zznO() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzPl.zzYZ8(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzPl.zz5u(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXNG(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzXQW(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzXQW(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzO1(oldChild, false);
    }

    private Node zzO1(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzXQW(node, (Node)this, null, 1);
        if (documentBase.zzW7w() && zzZmm.zzW5P(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzXQW(nodeChangingArgs);
        }
        if (!bl && zzZmm.zzZCL(node)) {
            zzZmm.zzEs(node, false);
        }
        Node node2 = this.zz49(node);
        if (nodeChangingArgs != null) {
            documentBase.zzO1(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzWwt.zzZ4H(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzYFL(Node node) {
        node.getParentNode();
        if (this.zzWFt == null) {
            node.zzYnl(null);
            node.zzg6(null);
            this.zzKj = node;
        } else {
            node.zzYnl(this.zzWFt);
            node.zzg6(null);
            this.zzWFt.zzg6(node);
        }
        this.zzWFt = node;
        node.zzXxn(this);
        return node;
    }

    final void zzXQW(Node node, Node node2, Node node3) {
        this.zzXQW(node, node2, node3, false);
    }

    final void zzXQW(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzXI1(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzO1(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzYZ8(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzZmm.zzWC0(node3.getNodeType())) continue;
            if (zzZmm.zzZzF(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZ7Y().length();
    }

    String zzZ7Y() {
        return "";
    }

    final String zzX9j() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZO1(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzZO1(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzYHW(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzXQW(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzO1(visitor));
    }

    abstract int zzXQW(DocumentVisitor var1) throws Exception;

    abstract int zzO1(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzXI1(Node var1);

    final Node zzXQW(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZTz(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzXI1(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzYI0(documentBase);
            try {
                compositeNode.zzO1(node, true);
            }
            finally {
                ((zzYI0)object).dispose();
            }
        }
        if ((object = documentBase.zzXQW(node, null, (Node)this, 0)) != null) {
            documentBase.zzXQW((NodeChangingArgs)object);
        }
        if (this.zzWFt == null) {
            node.zzYnl(null);
            node.zzg6(null);
            this.zzKj = node;
            this.zzWFt = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzO1(node, node2);
            } else {
                this.zzYZ8(node, this.zzKj);
            }
        } else if (node2 != null) {
            this.zzYZ8(node, node2);
        } else {
            this.zzO1(node, this.zzWFt);
        }
        node.zzXxn(this);
        if (object != null) {
            documentBase.zzO1((NodeChangingArgs)object);
        }
        if (documentBase.zzW7w()) {
            zzZmm.zzXQW(node, compositeNode, node3);
        }
        return node;
    }

    private void zzO1(Node node, Node node2) {
        Node node3 = node2.zzZCz();
        node.zzYnl(node2);
        node.zzg6(node3);
        node2.zzg6(node);
        if (node3 == null) {
            this.zzWFt = node;
            return;
        }
        node3.zzYnl(node);
    }

    private void zzYZ8(Node node, Node node2) {
        Node node3 = node2.zzfS();
        node.zzYnl(node3);
        node.zzg6(node2);
        node2.zzYnl(node);
        if (node3 == null) {
            this.zzKj = node;
            return;
        }
        node3.zzg6(node);
    }

    private Node zz49(Node node) {
        if (node == this.zzKj) {
            if (this.zzKj == this.zzWFt) {
                this.zzKj = null;
                this.zzWFt = null;
            } else {
                this.zzKj = node.zzZCz();
                this.zzKj.zzYnl(null);
            }
        } else {
            Node node2 = node.zzfS();
            Node node3 = node.zzZCz();
            node2.zzg6(node3);
            if (node3 == null) {
                this.zzWFt = node2;
            } else {
                node3.zzYnl(node2);
            }
        }
        node.zzg6(null);
        node.zzYnl(null);
        node.zzXxn(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzZsC = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZsC;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

