/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzB1;
import com.aspose.words.internal.zzWpF;
import com.aspose.words.internal.zzXFP;
import com.aspose.words.internal.zzXgq;
import com.aspose.words.internal.zzXr9;
import com.aspose.words.internal.zzY4o;
import com.aspose.words.internal.zzY7Z;
import com.aspose.words.internal.zzY99;
import com.aspose.words.internal.zzYzE;
import com.aspose.words.internal.zzZ92;
import com.aspose.words.internal.zzZvl;
import com.aspose.words.internal.zzeP;
import com.aspose.words.zz9u;
import com.aspose.words.zzNR;
import com.aspose.words.zzVPF;
import com.aspose.words.zzXBg;
import com.aspose.words.zzXg5;
import com.aspose.words.zzXy8;
import com.aspose.words.zzY6N;
import com.aspose.words.zzYOA;
import com.aspose.words.zzZ7i;
import com.aspose.words.zzzz;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXQW(zzZvl zzZvl2, zzZvl zzZvl3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzXFP.zzO1((Object)zzZvl2, "srcStream");
        zzXFP.zzO1((Object)zzZvl3, "dstStream");
        zzXFP.zzO1((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzO1(zzZvl2, zzZvl3, certificateHolder, signOptions);
        zzZvl3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXQW(zzZvl.zzO1(srcStream), (zzZvl)zzZvl.zzYZ8(dstStream), certHolder, signOptions);
    }

    private static void zzO1(zzZvl zzZvl2, zzZvl zzZvl3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzYZ8(digitalSignature);
        }
        if (zzXy8.zzZu9(zzZvl2)) {
            DigitalSignatureUtil.zzXQW(zzZvl2, zzZvl3, digitalSignature, true);
            return;
        }
        zzXy8 zzXy82 = new zzXy8();
        zzZvl zzZvl4 = zzZvl2;
        zzXy8 zzXy83 = zzXy82;
        FileFormatInfo fileFormatInfo = zzXy82.zzO1(zzZvl4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXr9 zzXr92 = new zzXr9(zzZvl2);
                int n = fileFormatInfo.zzW0J() == 1 ? 1 : 2;
                zzVPF.zzXQW(zzXr92, digitalSignature, n);
                zzZvl3.zz2O(0L);
                zzXr92.zzdG(zzZvl3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXQW(fileFormatInfo.zzYIR(), zzZvl3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXQW(zzZvl2, zzZvl3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzXQW(zzZvl2, zzZvl3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzXFP.zzYZ8(srcFileName, "srcFileName");
        zzXFP.zzYZ8(dstFileName, "dstFileName");
        try (zzYzE zzYzE2 = zzXFP.zzO1(srcFileName, 3, 1);){
            try (zzYzE zzYzE3 = zzXFP.zzO1(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXQW((zzZvl)zzYzE2, (zzZvl)zzYzE3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzZ92 zzZ922 = zzZvl.zzYZ8(dstStream);
        zzZvl zzZvl2 = zzZvl.zzO1(srcStream);
        DigitalSignatureUtil.zzXQW(zzZvl2, (zzZvl)zzZ922, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzYzE zzYzE2 = zzXFP.zzO1(srcFileName, 3, 1);){
            try (zzYzE zzYzE3 = zzXFP.zzO1(dstFileName, 4, 2);){
                DigitalSignatureUtil.zz5u(zzYzE2, zzYzE3);
            }
            return;
        }
    }

    private static void zz5u(zzZvl zzZvl2, zzZvl zzZvl3) throws Exception {
        zzXy8 zzXy82 = new zzXy8();
        zzZvl zzZvl4 = zzZvl2;
        zzXy8 zzXy83 = zzXy82;
        FileFormatInfo fileFormatInfo = zzXy82.zzO1(zzZvl4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXr9 zzXr92 = new zzXr9(zzZvl2);
                zzXr92.zzZT8().zzYlo("_xmlsignatures");
                zzXr92.zzZT8().zzYlo("_signatures");
                zzZvl3.zz31(0L);
                zzXr92.zzdG(zzZvl3);
                zzZvl zzZvl5 = zzZvl3;
                zzZvl5.zz2O(zzZvl5.zzZXR());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzXgq zzXgq2 = new zzXgq(zzZvl2);
                zzeP zzeP2 = zzXgq2.zzXQW(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzeP2 != null) {
                    for (zzY7Z zzY7Z2 : zzeP2.zzWVF()) {
                        String string = zzeP2.zzXQW(zzY7Z2);
                        zzXgq2.zzY53().remove(string);
                    }
                    zzXgq2.zzY53().remove(zzeP2.getName());
                    zzY7Z zzY7Z3 = zzXgq2.zzWVF().zzYX("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzXgq2.zzWVF().remove(zzY7Z3.getId());
                    zzXgq2.zzPK();
                }
                zzZvl3.zz31(0L);
                zzXgq2.zzdG(zzZvl3);
                zzZvl zzZvl6 = zzZvl3;
                zzZvl6.zz2O(zzZvl6.zzZXR());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zz5u(zzZvl.zzO1(srcStream), zzZvl.zzYZ8(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzYzE zzYzE2 = zzXFP.zzO1(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzWeo(zzYzE2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzWeo(zzZvl zzZvl2) throws Exception {
        if (zzXy8.zzZu9(zzZvl2)) {
            return DigitalSignatureUtil.zzXdd(zzZvl2);
        }
        zzXy8 zzXy82 = new zzXy8();
        zzZvl zzZvl3 = zzZvl2;
        zzXy8 zzXy83 = zzXy82;
        FileFormatInfo fileFormatInfo = zzXy82.zzO1(zzZvl3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzZvl2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzWeo(zzZvl.zzO1(stream));
    }

    static zzY99 zzXQW(zzXr9 zzXr92, String string) throws Exception {
        zzYOA zzYOA2 = new zzYOA(zzXr92);
        if (zzYOA2.zzYdo()) {
            zzY99 zzY992 = zzYOA2.zzX2V(string);
            return zzY992;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzmb(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzB1.zzO1("Unexpected digest algorithm: {0}.", n));
    }

    static String zzXPN(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzmb(n);
    }

    private static void zzXQW(zzZvl zzZvl2, zzZvl zzZvl3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzXgq zzXgq2 = new zzXgq(zzZvl2);
        zzXg5 zzXg52 = bl ? new zzZ7i(zzXgq2) : new zzzz(zzXgq2);
        zzXg52.zzO1(digitalSignature);
        zzZvl3.zz2O(0L);
        zzXgq2.zzdG(zzZvl3);
    }

    private static void zzXQW(zzZvl zzZvl2, zzZvl zzZvl3, DigitalSignature digitalSignature) throws Exception {
        zzY6N zzY6N2 = new zzY6N(zzZvl2);
        zzXBg zzXBg2 = new zzXBg(zzY6N2);
        zzXBg2.zzO1(digitalSignature);
        zzZvl3.zz2O(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzZvl zzZvl4 = zzZvl3;
        zzY6N zzY6N3 = zzY6N2;
        zzY6N3.zzXQW(zzZvl4, string, null);
    }

    private static void zzXQW(zzXr9 zzXr92, zzZvl zzZvl2, DigitalSignature digitalSignature, String string) throws Exception {
        zzY99 zzY992 = DigitalSignatureUtil.zzXQW(zzXr92, string);
        zzY99 zzY993 = new zzY99();
        DigitalSignatureUtil.zzXQW((zzZvl)zzY992, (zzZvl)zzY993, digitalSignature, false);
        zzXr9 zzXr93 = zzYOA.zzYZ8(zzY993, string);
        zzXr93.zzdG(zzZvl2);
    }

    private static DigitalSignatureCollection zzXdd(zzZvl zzZvl2) throws Exception {
        zzZvl2.zz31(0L);
        zzXgq zzXgq2 = new zzXgq(zzZvl2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzeP zzeP2 = zzXgq2.zzXQW(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzeP2 != null) {
            for (zzY7Z zzY7Z2 : zzeP2.zzWVF()) {
                String string = zzeP2.zzXQW(zzY7Z2);
                zzeP zzeP3 = zzXgq2.zzYoT(string);
                zzeP zzeP4 = zzXgq2.zzXQW(zzeP3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzWpF zzWpF2 = zzY4o.zzX6l(zzeP4.zzXT7().zzYaj());
                zz9u.zzXQW(zzeP3.zzXIE(), zzWpF2, new zzNR(zzXgq2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

