/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzB1;
import com.aspose.words.internal.zzL3;
import com.aspose.words.internal.zzLX;
import com.aspose.words.internal.zzVSH;
import com.aspose.words.internal.zzWwf;
import com.aspose.words.internal.zzWxh;
import com.aspose.words.internal.zzX4Z;
import com.aspose.words.internal.zzXFP;
import com.aspose.words.internal.zzXIr;
import com.aspose.words.internal.zzXK7;
import com.aspose.words.internal.zzXes;
import com.aspose.words.internal.zzY99;
import com.aspose.words.internal.zzYHD;
import com.aspose.words.internal.zzYqe;
import com.aspose.words.internal.zzZSI;
import com.aspose.words.internal.zzZkP;
import com.aspose.words.internal.zzZvl;
import com.aspose.words.internal.zzv0;
import com.aspose.words.zz3W;
import com.aspose.words.zz8Y;
import com.aspose.words.zzB4;
import com.aspose.words.zzJV;
import com.aspose.words.zzVTM;
import com.aspose.words.zzWBm;
import com.aspose.words.zzWO3;
import com.aspose.words.zzWSP;
import com.aspose.words.zzWZo;
import com.aspose.words.zzWss;
import com.aspose.words.zzWth;
import com.aspose.words.zzWzY;
import com.aspose.words.zzX1r;
import com.aspose.words.zzX4x;
import com.aspose.words.zzXBf;
import com.aspose.words.zzXFt;
import com.aspose.words.zzXQk;
import com.aspose.words.zzXR1;
import com.aspose.words.zzXRM;
import com.aspose.words.zzXZ6;
import com.aspose.words.zzXZO;
import com.aspose.words.zzXwT;
import com.aspose.words.zzY0l;
import com.aspose.words.zzY28;
import com.aspose.words.zzY2y;
import com.aspose.words.zzYH9;
import com.aspose.words.zzYI0;
import com.aspose.words.zzYKp;
import com.aspose.words.zzYhL;
import com.aspose.words.zzYhR;
import com.aspose.words.zzYj1;
import com.aspose.words.zzYnO;
import com.aspose.words.zzYtz;
import com.aspose.words.zzYyH;
import com.aspose.words.zzZ1K;
import com.aspose.words.zzZdD;
import com.aspose.words.zzZln;
import com.aspose.words.zzZmm;
import com.aspose.words.zzZs8;
import com.aspose.words.zzeP;
import com.aspose.words.zzh2;
import com.aspose.words.zzio;
import com.aspose.words.zzlz;
import com.aspose.words.zzyG;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zz3W,
zzXBf,
zzYhL,
zzYtz {
    private Document zzNO;
    private Node zzYYD;
    private Node zzWAK;
    private zzVTM zzZBx;
    private Font zzZJd;
    private zzZSI<zzVTM> zzf0;
    private zzZSI<zzY0l> zzZEA;
    private zzZSI<zzXQW> zzZZI;
    private zzWzY zzCn = zzWzY.zzWlE();
    private zz8Y zzWAs = new zz8Y();
    private zzY0l zzWqj;
    private RowFormat zzWK5;
    private CellFormat zzYWB;
    private ParagraphFormat zzX3S;
    private zzZSI<zzY28> zzZkX;
    private int zzWvA = 0;
    private int zzFa = -1;
    private int zzZjH;
    private boolean zzWoA;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzEs(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzEs(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzEs(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXQW(documentBuilder.getCurrentSection(), zzXQk.zz8d(headerFooterType), 0, 0);
    }

    private void zzEs(int n, int n2, int n3, int n4) {
        this.zzNO.ensureMinimum();
        Section section = (Section)this.zzNO.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXQW(section, 1, n3, n4);
    }

    private void zzXQW(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzXQk.zzAE(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzNO, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzNO));
            }
        }
        this.zzXQW(story, n2, n3);
    }

    private void zzXQW(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXQW((CompositeNode)paragraph2, n3);
    }

    final void zzXQW(Paragraph paragraph, int n) {
        this.zzXQW((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzYqf().zzZ72() ? zzY2y.zzWQI(this.zzNO, fieldName) : zzY2y.zzXI1(this.zzYqf(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXQW(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXQW(field, isAfter, false);
    }

    private boolean zzXQW(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzXFt zzXFt2 = field.getFormat().zzZ1A();
        Inline inline = zzXFt2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXQW(inline.zzWYc(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzWSP.zzXQW(this.zzNO, bookmarkName) : zzWSP.zzO1(this.zzNO, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzXfN() == 6) {
            this.zzXQW((Paragraph)node.zzXFz(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzZmm.zzZBB(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXQW(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXQW(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzO1(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzXQW(structuredDocumentTag);
            return;
        }
        this.zzYZ8(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzIH(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzXQW(cell, characterIndex);
    }

    private void zzXQW(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzXfN() == 6) {
            this.zzlz(node);
        } else {
            Node node2 = node;
            if (zzZmm.zzWC0(node2.getNodeType())) {
                Paragraph paragraph = zzZmm.zzZBB(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzlz(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzXfN() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzlz(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzZjH = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzXc8();
            return;
        }
        if (!this.zzY()) {
            this.zzXc8();
        }
    }

    private boolean zzY() {
        Node node = this.zzYqf();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzYqf().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXQW(((StructuredDocumentTag)documentBuilder.zzYqf().getParentNode()).zzZmy(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzYqf(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXQW(inline.zzWYc(), true);
            return true;
        }
        return false;
    }

    private void zzXc8() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXQW(documentBuilder.getCurrentParagraph().zzZub(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzIH(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzXXS() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzYqf().zzZTz(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzVTv();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXQW((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zz49(text, false);
    }

    public void writeln(String text) {
        this.zz49(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        this.zzXyU();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzYI0 zzYI02 = new zzYI0(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzNO, this.zzWRE(), this.zzVWG());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzO1(this.zzYqf(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzYI02.dispose();
        }
        if (this.getDocument().zzW7w()) {
            zzZmm.zzYZ8((zzB4)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzXIV());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzZIG() {
        zzVTM zzVTM2;
        Run run;
        Run run2;
        zzYhL zzYhL2;
        this.zzXyU();
        Node node = this.zzYqf();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            zzYhL2 = paragraph;
            run2 = zzYhL2.zzWJn(false);
        } else {
            run2 = run = (Run)node.zzYZA(21);
        }
        if (run2 == null && zzXFP.zzdG(node, paragraph.zzYbN())) {
            run = paragraph.zzYbN();
        }
        if (run != null) {
            zzYhL2 = run.zzWYc();
            zzVTM2 = (zzVTM)((zzlz)((Object)zzYhL2)).zzX81();
        } else {
            zzYhL2 = paragraph.zzZub();
            zzVTM2 = (zzVTM)((zzlz)((Object)zzYhL2)).zzX81();
        }
        zzVTM zzVTM3 = zzVTM2;
        Paragraph paragraph2 = new Paragraph(this.zzNO, this.zzWRE(), zzVTM3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzYI0 zzYI02 = new zzYI0(this.zzNO);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzO1(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzYI02.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXZO.zzWQI(this);
    }

    public void insertBreak(int breakType) {
        this.zzXyu(breakType, true);
    }

    final void zzXyu(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzVYJ(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzWk4(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzYi6())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzVYJ(bl)) {
                        this.zzWk4(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzVYJ(bl)) {
                        this.zzXvg(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzVYJ(bl)) {
                        this.zzXvg(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzVYJ(bl)) {
                        this.zzXvg(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzVYJ(bl)) {
                        this.zzXvg(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzVYJ(bl)) {
                        this.zzXvg(4);
                    }
                    return;
                }
                case 8: {
                    this.zzWk4(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzXes.zzyA(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzB1.zzO1("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzXyU();
        return zzZmm.zzXQW(fieldType, updateField, this.zzVWG(), this.zzyE(), this.zzXT9(), this.zzXT9() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzXyU();
        return zzZmm.zzXQW(fieldCode, this.zzVWG(), this.zzyE(), this.zzXT9(), this.zzXT9() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzXyU();
        return zzZmm.zzXQW(fieldCode, fieldValue, this.zzVWG(), this.zzyE(), this.zzXT9(), this.zzXT9() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzXFP.zzO1((Object)displayText, "displayText");
        zzXFP.zzO1((Object)urlOrBookmark, "hrefOrBookmark");
        zzWBm zzWBm2 = this.zzO1(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzWBm2.zzYZ8(documentBuilder.zzXCD(88, true));
        return zzZmm.zzXQW(zzWBm2.getStart(), zzWBm2.getSeparator(), zzWBm2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzWem(70);
        if (zzXes.zzyA(name)) {
            this.startBookmark(name);
        }
        this.zzZxC(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzZGo(70);
        String string = zzXes.zzyA(fieldValue) ? fieldValue : FormField.zzXfN;
        Run run = new Run(this.zzNO, string, this.zzVWG());
        this.insertNode(run);
        Node node = this.zzXCD(70, true);
        if (zzXes.zzyA(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzYH9(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzXQW((Paragraph)node.zzXFz(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzWem(71);
        if (zzXes.zzyA(name)) {
            this.startBookmark(name);
        }
        this.zzZxC(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzXCD(71, false);
        if (zzXes.zzyA(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzYH9(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzWem(83);
        if (zzXes.zzyA(name)) {
            this.startBookmark(name);
        }
        this.zzZxC(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzXCD(83, false);
        if (zzXes.zzyA(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzYH9(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzNO, footnoteType, !zzXes.zzyA(referenceMark), referenceMark, this.zzVWG());
        Style style = this.getDocument().getStyles().zzWUJ(zzZmm.zzYGN(footnoteType));
        footnote.zzWYc().set(50, style.zzYA3());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzNO);
        Style style2 = this.getDocument().getStyles().zzWUJ(zzZmm.zzXjn(footnoteType));
        paragraph.zzWWM().set(1000, style2.zzYA3());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzNO, '\u0002', new zzVTM()) : new Run(this.zzNO, footnote.getReferenceMark(), new zzVTM());
        inline.zzWYc().set(50, style.zzYA3());
        paragraph.appendChild(inline);
        if (zzXes.zzyA(footnoteText)) {
            Node node = this.zzYqf();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzlz(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzYQx(zzZvl zzZvl2) throws Exception {
        return this.zzXQW(zzZvl2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzYQx(zzZvl.zzO1(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXQW(zzZvl zzZvl2, double d, double d2) throws Exception {
        return this.zzXQW(zzZvl2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXQW(zzZvl.zzO1(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzY99 zzY992 = new zzY99();){
            zzWxh.zzXQW(image, zzY992);
            Shape shape = this.zzXQW(zzY992, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzXFP.zzYZ8(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzVSH.zzXpa(fileName);
        try {
            Shape shape = this.zzXQW((zzZvl)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzZvl)object).close();
            }
        }
    }

    private Shape zzXQW(zzZvl zzZvl2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzZvl2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzXFP.zzZzF(zzZvl2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXQW(zzZvl.zzO1(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXQW(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzXQW(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzXK7.zzXdd(object)) {
            object4 = new zzWxh((byte[])object);
            bl2 = true;
            ((zzXIr)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzNO.getCompatibilityOptions().getMswVersion() > 12 || this.zzNO.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzNO, 0);
            object3 = new zzYhR();
            ((zzWth)object3).zzXQW(zzeP.zzZb7("rect"));
            ((zzYhR)object3).zzXQW(new zzXwT());
            ((zzYhR)object3).zzZsW().zz5o().zzYZ8(this.zzNO);
            object2 = new zzYj1();
            ((zzJV)object2).zzO1(new zzWZo(this.zzNO.zzYqM(), ""));
            ((zzJV)object2).zzXQW(new zzZ1K());
            ((zzXZ6)object3).zzXQW((zzJV)object2);
            shape.zzWXJ(75);
            shape.zzZzF((zzXZ6)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzNO, 75);
        }
        if (zzXK7.zzWxh(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzXQW((byte[])object, new zzZs8(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzZs8(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzXK7.zzJD((byte[])object2));
                this.zzXQW((zzYhR)shape.zzXfu(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzYhR)shape.zzXfu()).zzZsW().zz5o().zzYf1((byte[])object);
            object3 = zzXK7.zzZrb(object);
            object4 = new zzZs8(((zzv0)object3).getWidthPoints(), ((zzv0)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzXQW(this.zzVWG());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzXK7.zzZIJ(object)) {
            d5 = DocumentBuilder.zzXQW(shape, object);
        }
        shape.zzXQW(d3, d4, (zzZs8)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzXQW(Shape shape, byte[] byArray) throws Exception {
        int n = zzXK7.zzWu1(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzZmm.zzY3U(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzZmm.zzXEe(n);
        return d;
    }

    private void zzXQW(zzYhR zzYhR2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzYhR2.zzZsW().zz5o().getExtensions();
        try (zzY99 zzY992 = new zzY99(byArray);){
            object = zzZmm.zzXQW(zzY992, this.zzNO);
            ((zzZln)object).zzZ4H(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzZln)object).zzXJB();
            byArray2 = ((zzZln)object).zzBz(true);
        }
        zzYhR2.zzZsW().zz5o().setExtensions(new zzL3<zzWO3>());
        object = zzWO3.zzXQW(byArray2, this.zzNO);
        zzYhR2.zzZsW().zz5o().getExtensions().zzwK(((zzWO3)object).getUri(), (zzWO3)object);
    }

    private Shape zzXQW(zzZvl zzZvl2, String string, boolean bl, zzZvl zzZvl3) throws Exception {
        zzyG zzyG2 = zzyG.zzXUr(string);
        Shape shape = this.zzXQW(zzZvl3, bl, zzyG2, null);
        zzXR1 zzXR12 = zzio.zzXQW(zzZvl2, string, bl);
        return DocumentBuilder.zzXQW(null, false, shape, zzyG2.zzZoc, zzXR12);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXQW(zzZvl.zzO1(stream), progId, asIcon, zzZvl.zzO1(presentation));
    }

    private Shape zzXQW(String string, boolean bl, boolean bl2, zzZvl zzZvl2) throws Exception {
        zzyG zzyG2 = zzyG.zzVT4(zzLX.zzXqg(string));
        return this.zzXQW(string, bl, bl2, zzZvl2, zzyG2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXQW(fileName, isLinked, asIcon, zzZvl.zzO1(presentation));
    }

    private Shape zzXQW(String string, String string2, boolean bl, boolean bl2, zzZvl zzZvl2) throws Exception {
        zzyG zzyG2 = zzyG.zzXUr(string2);
        return this.zzXQW(string, bl, bl2, zzZvl2, zzyG2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXQW(fileName, progId, isLinked, asIcon, zzZvl.zzO1(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzyG zzyG2 = zzyG.zzVT4(zzLX.zzXqg(fileName));
        return this.zzXQW(fileName, isLinked, iconFile, iconCaption, zzyG2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzyG zzyG2 = zzyG.zzXUr(progId);
        return this.zzXQW(fileName, isLinked, iconFile, iconCaption, zzyG2);
    }

    private Shape zzXQW(zzZvl zzZvl2, String string, String string2, String string3) throws Exception {
        zzyG zzyG2 = zzyG.zzXUr(string);
        Shape shape = this.zzXQW(string2, string3, zzyG2);
        zzXR1 zzXR12 = zzio.zzXQW(zzZvl2, string, true);
        return DocumentBuilder.zzXQW(null, false, shape, zzyG2.zzZoc, zzXR12);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzXQW(zzZvl.zzO1(stream), progId, iconFile, iconCaption);
    }

    final Shape zzXQW(zzX4x zzX4x2, zzZvl zzZvl2) throws Exception {
        Shape shape = this.zzXT3(zzZvl2);
        shape.zzWXJ(201);
        shape.setShapeAttr(4112, zzX4x2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzXyU();
        if (this.zzOd()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzYFN(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzX1r zzX1r2 = zzZmm.zzXQW(html, options, this);
        zzX1r2.zzYSr();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzXyU();
        return zzZmm.zzXQW(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzXyU();
        return zzZmm.zzXQW(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzYyH zzYyH2 = new zzYyH();
        return zzYyH2.zzXQW(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYKp(this).zzXQW(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYKp(this).zzXQW(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzNO, 75);
        shape.zzXQW(this.zzVWG());
        shape.zzZK0(true);
        shape.getSignatureLine().zzXQW(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZEG(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzWrK(this.zzNO);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzOd() {
        boolean bl = false;
        if (this.zzYqf().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzYqf().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzYFN(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzXyU();
        if (this.zzXXS() == null) {
            this.startTable();
        }
        if (this.zzXXS().zzWa2() == 1) {
            this.zzXXS().zzZNO();
        }
        if (this.zzXXS().zzWa2() == 3) {
            this.zzXXS().zzXCa();
        }
        return this.zzXXS().zzX4C();
    }

    public Table startTable() {
        this.zzZkX.push(new zzY28(this));
        return this.zzXXS().startTable();
    }

    public Table endTable() {
        if (this.zzXXS() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzXXS().endTable();
        this.zzZkX.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzXXS() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzXXS().endRow();
        if (this.zzZJd != null && this.zzZJd.getHidden()) {
            row.zzWAl().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzNO, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzNO, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYy1();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzNO, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzbA();
        bookmarkStart.zzWO5(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYy1();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzbA();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzNO, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzVQl(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzNO);
        this.zzFa = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzFa == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzNO, this.zzFa);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzNO, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzXFP.zzO1((Object)importFormatOptions, "ImportFormatOptions");
        this.zzXyU();
        return zzZdD.zzXQW(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzNO;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzNO) {
            return;
        }
        this.zzNO = value;
        this.zzlz(null);
        this.zzZBx = new zzVTM();
        this.zzf0 = null;
        this.zzZEA = null;
        this.zzZJd = null;
        this.zzZkX = new zzZSI();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZJd == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZJd = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzZJd;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzX3S == null) {
            DocumentBuilder documentBuilder = this;
            this.zzX3S = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzX3S;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzWK5 == null) {
            this.zzWK5 = new RowFormat(this);
        }
        return this.zzWK5;
    }

    public CellFormat getCellFormat() {
        if (this.zzYWB == null) {
            this.zzYWB = new CellFormat(this);
        }
        return this.zzYWB;
    }

    final void zzZaH(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzVTM zzVTM2;
        if (this.getCurrentParagraph() != null) {
            zzVTM zzVTM3 = this.getCurrentParagraph().zzZub();
            zzVTM2 = (zzVTM)zzVTM3.zzX81();
        } else {
            zzVTM2 = this.zzVWG();
        }
        zzVTM zzVTM4 = zzVTM2;
        this.zzYdD().push(new zzXQW(this.zzVWG(), zzVTM4));
    }

    public void popFont() {
        zzZSI<zzXQW> zzZSI2 = this.zzYdD();
        if (zzZSI2.size() > 0) {
            zzXQW zzXQW2 = (zzXQW)this.zzYdD().pop();
            this.zzXQW(zzXQW2.zzWYc(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zz2O(zzXQW2.zzXbK());
            }
        }
    }

    final void zzWE3() {
        this.zzYDI().push(this.zzVWG());
    }

    final void zzZYs() {
        zzZSI<zzVTM> zzZSI2 = this.zzYDI();
        if (zzZSI2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXQW((zzVTM)documentBuilder.zzYDI().pop(), false);
        }
    }

    final void zzY2s() {
        this.zzZsD().push(this.zzWRE());
    }

    final void zz8a() {
        zzZSI<zzY0l> zzZSI2 = this.zzZsD();
        if (zzZSI2.size() > 0) {
            zzY0l zzY0l2 = (zzY0l)this.zzZsD().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXQW(zzY0l2);
            }
        }
    }

    private zzWBm zzO1(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzWem(88);
        zzWss zzWss2 = new zzWss();
        zzWss2.setTarget(string2);
        zzWss2.setScreenTip(string3);
        if (bl) {
            zzWss2.setSubAddress(string);
        } else {
            zzWss2.setAddress(zzWwf.zzZbZ(string));
            zzWss2.setSubAddress(zzWwf.zzYJj(string));
        }
        this.zzZxC(zzWss2.zz9z());
        FieldSeparator fieldSeparator = this.zzZGo(88);
        return new zzWBm(fieldStart, fieldSeparator, null);
    }

    final zzWBm zzEs(String string, String string2, String string3) {
        boolean bl = zzWwf.zz9K(string);
        String string4 = bl ? zzWwf.zzYJj(string) : string;
        return this.zzO1(string4, bl, string2, string3);
    }

    final zzWBm zzXQW(zzWss zzWss2) {
        FieldStart fieldStart = this.zzWem(88);
        this.zzZxC(zzWss2.zz9z());
        FieldSeparator fieldSeparator = this.zzZGo(88);
        return new zzWBm(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzZRF() {
        return this.zzXCD(88, true);
    }

    final zzVTM zzVWG() {
        zzVTM zzVTM2 = this.zzZBx;
        return (zzVTM)zzVTM2.zzX81();
    }

    final zzY0l zzWRE() {
        zzY0l zzY0l2 = this.zzWWM();
        return (zzY0l)zzY0l2.zzX81();
    }

    final zzWzY zzXzz() {
        zzWzY zzWzY2 = this.zzWAl();
        return (zzWzY)zzWzY2.zzX81();
    }

    final zz8Y zzWlg() {
        zz8Y zz8Y2 = this.zzZm3();
        return (zz8Y)zz8Y2.zzX81();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzYqf(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzYqf().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzWoA && this.zzYqf().getNodeType() == 28;
    }

    private void zz49(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzYqf()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzXQk.zzXi1(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzYMh(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWvA) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzWk4(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzYMh(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzXyU();
        if (this.zzXXS() != null && this.zzXXS().zzWa2() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzYqf().getParentNode().insertBefore(node, this.zzYqf());
    }

    final void zzWED(int n) {
        this.zzVYJ(true);
        this.zzXvg(n);
    }

    private void zzXvg(int n) {
        this.insertParagraph();
        zzYI0 zzYI02 = new zzYI0(this.getDocument());
        try {
            zzXRM zzXRM2 = this.getCurrentSection().zzZqO();
            zzXRM zzXRM3 = (zzXRM)zzXRM2.zzX81();
            Section section = new Section(this.zzNO, zzXRM3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzNO));
            this.zzNO.insertAfter(section, this.getCurrentSection());
            section.getBody().zzO1(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYI02.dispose();
        }
    }

    final FieldStart zzWem(int n) {
        this.zzXyU();
        return zzZmm.zzXQW(n, this.zzVWG(), this.zzyE(), this.zzXT9(), this.zzXT9() == null);
    }

    final Run zzZxC(String string) {
        return zzZmm.zzO1(string, this.zzVWG(), this.zzyE(), this.zzXT9(), this.zzXT9() == null);
    }

    final FieldEnd zzXCD(int n, boolean bl) {
        return zzZmm.zzO1(n, bl, this.zzVWG(), this.zzyE(), this.zzXT9(), this.zzXT9() == null);
    }

    final FieldSeparator zzZGo(int n) {
        return zzZmm.zzO1(n, this.zzVWG(), this.zzyE(), this.zzXT9(), this.zzXT9() == null);
    }

    private FormField zzYH9(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzNO, new zzh2(), this.zzVWG());
        CompositeNode compositeNode = node == null ? this.zzyE() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzVYJ(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzXXS() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzIH(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzYMh(String string) {
        if (this.zzSG(string)) {
            zzZkP zzZkP2 = new zzZkP(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzX4Z zzX4Z2 : zzZkP2.zzWlh(this.getParagraphFormat().getBidi())) {
                zzYH9 zzYH92 = zzYH9.zzYf1(zzX4Z2.zz76());
                zzVTM zzVTM2 = this.zzVWG();
                zzVTM2.zzZXO(265, zzYH92);
                if (zzX4Z2.zzmS()) {
                    zzVTM2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzNO, zzX4Z2.getText(), zzVTM2);
                this.insertNode(run);
            }
            return;
        }
        this.zzWk4(string);
    }

    private boolean zzSG(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzYHD.zzWDG(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXQW(zzVTM zzVTM2, boolean bl) {
        zzVTM zzVTM3;
        if (bl) {
            zzVTM zzVTM4 = zzVTM2;
            zzVTM3 = (zzVTM)zzVTM4.zzX81();
        } else {
            zzVTM3 = zzVTM2;
        }
        this.zzZBx = zzVTM3;
    }

    final void zzVSU() {
        this.zzZBx.clear();
    }

    final void zzXcs() {
        if (this.zzYy1() != null) {
            zz8Y zz8Y2;
            zz8Y zz8Y3 = zz8Y2 = this.zzYy1().zzZm3();
            this.zzWAs = (zz8Y)zz8Y3.zzX81();
            zz8Y2.zzO1(this.zzWAs);
        }
    }

    private Shape zzXQW(String string, boolean bl, boolean bl2, zzZvl zzZvl2, zzyG zzyG2) throws Exception {
        if (zzyG2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzXQW(zzZvl2, bl2, zzyG2, string);
        zzXR1 zzXR12 = zzio.zzXQW(string, bl, bl2, zzyG2);
        return DocumentBuilder.zzXQW(string, bl, shape, zzyG2.zzZoc, zzXR12);
    }

    private Shape zzXQW(String string, boolean bl, String string2, String string3, zzyG zzyG2) throws Exception {
        if (zzyG2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzLX.zzZ9X(string);
        }
        Shape shape = string2 != null ? this.zzZrb(string2, string3) : this.zzXQW(null, string3, zzyG2);
        zzXR1 zzXR12 = zzio.zzXQW(string, bl, true, zzyG2);
        return DocumentBuilder.zzXQW(string, bl, shape, zzyG2.zzZoc, zzXR12);
    }

    private static Shape zzXQW(String string, boolean bl, Shape shape, String string2, zzXR1 zzXR12) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzWXJ(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzO1(zzXR12);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzXQW(zzZvl zzZvl2, boolean bl, zzyG zzyG2, String string) throws Exception {
        if (zzyG2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzZvl2 != null) {
            return this.zzXT3(zzZvl2);
        }
        if (!bl) {
            return this.zzZpe(zzio.zzYHB().get("normal"));
        }
        String string2 = string != null ? zzLX.zzZ9X(string) : zzio.zzxP(zzyG2.zzWj5);
        return this.zzXQW(zzyG2, string2);
    }

    private Shape zzXQW(String string, String string2, zzyG zzyG2) throws Exception {
        if (zzyG2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzio.zzxP(zzyG2.zzWj5);
        }
        if (string != null) {
            return this.zzZrb(string, string2);
        }
        return this.zzXQW(zzyG2, string2);
    }

    private Shape zzXQW(zzyG zzyG2, String string) throws Exception {
        if (zzyG2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzio.zzTR(zzyG2.zzWj5);
        zzYqe zzYqe2 = new zzYqe(byArray, null, string, this.getDocument().zzYvs());
        return this.zzZpe(zzYqe2.zzW1G());
    }

    private Shape zzZrb(String string, String string2) throws Exception {
        zzYqe zzYqe2 = new zzYqe(string, string2, this.getDocument().zzYvs());
        return this.zzZpe(zzYqe2.zzW1G());
    }

    private Shape zzXT3(zzZvl zzZvl2) throws Exception {
        byte[] byArray = zzXFP.zzZzF(zzZvl2);
        return this.zzZpe(byArray);
    }

    private Shape zzZpe(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzNO, 1);
        shape.zzWXJ(75);
        shape.zzXQW(this.zzVWG());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZEG(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzXQW(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzO1(compositeNode, n);
            return;
        }
        this.zzYZ8(compositeNode, n);
    }

    private void zzO1(CompositeNode compositeNode, int n) {
        zzYnO zzYnO2 = zzYnO.zzZwa(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzYnO2.zzXQW(null, true, true, true, false, true);
            node = zzYnO2.getNode();
            if (zzYnO2.zzWpG() && (!node.isComposite() || node.zzXfN() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzZ7Y().length() : node.getTextLength();
            if (!zzYnO2.zzWpG() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzYnO2.zzWpG() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzXQW((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzXQW(null, node);
            this.zzZjH = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzXQW(StructuredDocumentTag structuredDocumentTag) {
        this.zzlz(structuredDocumentTag);
        this.zzWoA = true;
        this.zzZjH = 0;
        zzVTM zzVTM2 = structuredDocumentTag.zzZmy();
        switch (structuredDocumentTag.zzXfN()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzYtd(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzVTM2 = ((Inline)node).zzWYc();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzVTM2 = paragraph.zzZub();
                break;
            }
            default: {
                return;
            }
        }
        this.zzXQW(zzVTM2, true);
    }

    private void zzYZ8(CompositeNode compositeNode, int n) {
        zzYnO zzYnO2 = zzYnO.zzwr(compositeNode);
        while (zzYnO2.getNode() != compositeNode || !zzYnO2.zzWpG()) {
            int n2;
            Node node = zzYnO2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZ7Y().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzXQW(null, node);
                this.zzZjH = n;
                return;
            }
            while (zzYnO2.zzXQW(null, false, true, true, false, true) && zzYnO2.zzWpG() && zzYnO2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzXyU() {
        int n = this.zzZjH;
        if (n == 0) {
            return;
        }
        this.zzZjH = 0;
        Run run = zzXFP.zzXQW((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzYHL(n);
        }
    }

    private Run zzWk4(String string) {
        Run run = new Run(this.zzNO, string, this.zzVWG());
        this.insertNode(run);
        return run;
    }

    final boolean zzZkA() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzW4() {
        return this.zzWvA;
    }

    final void zzX5T(int n) {
        this.zzWvA = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzYqf();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzYqf();
        }
        return (Paragraph)this.zzYqf().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzYqf();
        }
        return (StructuredDocumentTag)this.zzYqf().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzYqf().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzY28 zzXXS() {
        zzZSI<zzY28> zzZSI2 = this.zzZkX;
        if (zzZSI2.size() > 0) {
            return (zzY28)this.zzZkX.peek();
        }
        return null;
    }

    private Cell zzYy1() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzWvK();
    }

    private CompositeNode zzyE() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzYqf();
        }
        return this.zzYqf().getParentNode();
    }

    private Node zzXT9() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzYqf();
    }

    private zzZSI<zzVTM> zzYDI() {
        if (this.zzf0 == null) {
            this.zzf0 = new zzZSI();
        }
        return this.zzf0;
    }

    private zzZSI<zzY0l> zzZsD() {
        if (this.zzZEA == null) {
            this.zzZEA = new zzZSI();
        }
        return this.zzZEA;
    }

    private zzZSI<zzXQW> zzYdD() {
        if (this.zzZZI == null) {
            this.zzZZI = new zzZSI();
        }
        return this.zzZZI;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZBx.zzVZH(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzZBx.zzW8y(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzYFl(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzYFl(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZBx.zzZXO(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWGX()) {
            this.getCurrentParagraph().zzZub().zzZXO(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZBx.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZBx.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWGX()) {
            this.getCurrentParagraph().zzZub().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzWWM().zzVZH(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzWWM().zzW8y(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzY4o(key, 0);
        }
        return this.getDocument().getStyles().zzYwt().zzW1C(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzWWM().zzZXO(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzWWM().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzWWM().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWAl().zzVZH(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWAl().zzW1C(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWAl().zzuE(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWAl().zzZXO(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWAl().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWAl().clear();
        zzWzY.zzWlE().zzO1(this.zzWAl());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZm3().zzVZH(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZm3().zzW1C(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZm3().zzuE(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzXFP.zzXQW(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzYy1() != null ? this.zzYy1().getCellFormat() : this.getCellFormat();
            border.zzXQW(cellFormat);
        }
        this.zzZm3().zzZXO(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZm3().clear();
    }

    private Node zzYqf() {
        Node node = this.zzYYD != null && this.zzYYD.getParentNode() == null ? this.zzWAK : this.zzYYD;
        if (node != null && node.zzXfN() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzWoA = this.zzWoA && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzlz(Node node) {
        this.zzYYD = node;
        if (this.zzYYD != null) {
            this.zzWAK = this.zzYYD.getParentNode();
        }
        this.zzWoA = false;
    }

    private zzY0l zzWWM() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzWWM();
        }
        if (this.zzWqj == null) {
            this.zzWqj = new zzY0l();
        }
        return this.zzWqj;
    }

    private zzWzY zzWAl() {
        if (this.zzXXS() != null && this.zzXXS().zzWa2() == 1) {
            return this.zzCn;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWAl();
        }
        return this.zzCn;
    }

    private zz8Y zzZm3() {
        if (this.zzXXS() != null && this.zzXXS().zzWa2() != 3) {
            return this.zzWAs;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzWvK().zzZm3();
        }
        return this.zzWAs;
    }

    static final class zzXQW {
        private zzVTM zzZBx;
        private zzVTM zzYac;

        public zzXQW(zzVTM zzVTM2, zzVTM zzVTM3) {
            this.zzZBx = zzVTM2;
            this.zzYac = zzVTM3;
        }

        public final zzVTM zzWYc() {
            return this.zzZBx;
        }

        public final zzVTM zzXbK() {
            return this.zzYac;
        }
    }
}

