/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzWu1;
import com.aspose.words.internal.zzXFP;
import com.aspose.words.internal.zzXMU;
import com.aspose.words.internal.zzXes;
import com.aspose.words.internal.zzYzE;
import com.aspose.words.internal.zzZvl;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXy8;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzXWQ = new HashMap();
    private static HashMap<Integer, Integer> zzFi = new HashMap();
    private static HashMap<Integer, Integer> zz42 = new HashMap();
    private static HashMap<Integer, Integer> zzXMg = new HashMap();
    private static HashMap<Integer, Integer> zzWn7 = new HashMap();
    private static HashMap<Integer, Integer> zzd0 = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzXFP.zzYZ8(fileName, "fileName");
        try (zzYzE zzYzE2 = zzXFP.zz58(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzWcK(zzYzE2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzWcK(zzWu1.zzXQW(stream));
    }

    static FileFormatInfo zzWcK(zzZvl zzZvl2) throws Exception {
        if (zzZvl2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzXy8 zzXy82 = new zzXy8();
            zzZvl zzZvl3 = zzZvl2;
            zzXy8 zzXy83 = zzXy82;
            return zzXy82.zzO1(zzZvl3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzYZ8(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzXXJ(zzXMU.zzZBB(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzXk8(zzXMU.zzZBB(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzXes.zzyA(string = zzXMU.zzXo4(FileFormatUtil.zzZGc(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzXXJ(FileFormatUtil.zzZXH(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzXk8(FileFormatUtil.zzZGc(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXMU.zzXo4(FileFormatUtil.zzZXH(saveFormat));
        if (zzXes.zzyA(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzXk8(zzXMU.zzWTj(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXMU.zzXo4(FileFormatUtil.zzPj(imageType));
    }

    static Exception zzYZ8(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzWkh(int n) {
        return zzXMU.toString(FileFormatUtil.zzZXH(n));
    }

    static int zzXk8(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXFP.zzXQW(zzWn7, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzD4(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXFP.zzXQW(zzd0, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzXXt(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzZGc(int n) {
        return zzXFP.zzXQW(zzXWQ, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzZXH(int n) {
        return zzXFP.zzXQW(zzFi, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzPj(int n) {
        return zzXFP.zzXQW(zz42, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXXJ(int n) {
        return zzXFP.zzXQW(zzXMg, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzW4w(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzXFP.zzO1(zzWn7, Integer.valueOf(n), Integer.valueOf(n2));
            zzXFP.zzO1(zzFi, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzXMg.containsKey(n)) {
                zzXFP.zzO1(zzXMg, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzXFP.zzO1(zzXWQ, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzXFP.zzO1(zzd0, Integer.valueOf(n), Integer.valueOf(n4));
            zzXFP.zzO1(zz42, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzW4w(11, 10, 10, 1);
        FileFormatUtil.zzW4w(11, 0, 0, 1);
        FileFormatUtil.zzW4w(12, 11, 11, 1);
        FileFormatUtil.zzW4w(13, 20, 20, 1);
        FileFormatUtil.zzW4w(13, 0, 254, 1);
        FileFormatUtil.zzW4w(14, 21, 21, 1);
        FileFormatUtil.zzW4w(15, 22, 22, 1);
        FileFormatUtil.zzW4w(16, 23, 23, 1);
        FileFormatUtil.zzW4w(18, 24, 24, 1);
        FileFormatUtil.zzW4w(19, 25, 25, 1);
        FileFormatUtil.zzW4w(20, 26, 26, 1);
        FileFormatUtil.zzW4w(21, 27, 27, 1);
        FileFormatUtil.zzW4w(24, 30, 30, 1);
        FileFormatUtil.zzW4w(17, 31, 31, 1);
        FileFormatUtil.zzW4w(25, 50, 50, 1);
        FileFormatUtil.zzW4w(26, 45, 255, 1);
        FileFormatUtil.zzW4w(27, 51, 51, 1);
        FileFormatUtil.zzW4w(28, 54, 52, 1);
        FileFormatUtil.zzW4w(29, 0, 53, 1);
        FileFormatUtil.zzW4w(31, 53, 54, 1);
        FileFormatUtil.zzW4w(22, 60, 60, 1);
        FileFormatUtil.zzW4w(23, 61, 61, 1);
        FileFormatUtil.zzW4w(34, 40, 64, 1);
        FileFormatUtil.zzW4w(41, 47, 255, 1);
        FileFormatUtil.zzW4w(42, 48, 255, 1);
        FileFormatUtil.zzW4w(35, 41, 255, 1);
        FileFormatUtil.zzW4w(36, 46, 255, 1);
        FileFormatUtil.zzW4w(38, 42, 255, 1);
        FileFormatUtil.zzW4w(37, 44, 255, 1);
        FileFormatUtil.zzW4w(30, 52, 55, 1);
        FileFormatUtil.zzW4w(32, 70, 62, 1);
        FileFormatUtil.zzW4w(33, 73, 63, 1);
        FileFormatUtil.zzW4w(39, 71, 255, 1);
        FileFormatUtil.zzW4w(8, 100, 255, 1);
        FileFormatUtil.zzW4w(9, 105, 255, 1);
        FileFormatUtil.zzW4w(6, 101, 255, 6);
        FileFormatUtil.zzW4w(7, 102, 255, 7);
        FileFormatUtil.zzW4w(5, 104, 255, 5);
        FileFormatUtil.zzW4w(4, 0, 255, 4);
        FileFormatUtil.zzW4w(3, 0, 255, 3);
        FileFormatUtil.zzW4w(40, 72, 255, 1);
        FileFormatUtil.zzW4w(2, 103, 255, 2);
    }
}

