/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzWu1;
import com.aspose.words.zz2q;
import com.aspose.words.zzXNG;
import com.aspose.words.zzYoQ;
import com.aspose.words.zzZkc;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZkc,
Iterable<T> {
    private Node zzZsC;
    private CompositeNode zzMC;
    private DocumentBase zzXfq;
    private boolean zzWxC;
    private int zzYEw;
    private int zzYxf;
    private Node zzB;
    private int zzZhS;
    private zzYoQ zzW4A;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zz2q.zzYrX(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zz2q(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzYoQ matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzMC = container;
        this.zzXfq = container.getDocument();
        this.zzW4A = matcher;
        this.zzWxC = isDeep;
        this.zzGK();
    }

    public Node get(int index) {
        try {
            this.zzY6k();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYxf == index) {
                return this.zzB;
            }
            int n = index - this.zzYxf;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzZO1(nodeCollection.zzB, n);
            if (node != null) {
                this.zzYxf = index;
                this.zzB = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzWxC) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzMC.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzWxC) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzMC.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzYuu();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXNG(this);
    }

    final <TNode extends Node> zzXNG<TNode> zzWay() {
        return new zzXNG(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzYuu() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzWu1.zzXQW(arrayList, node);
        }
        return arrayList;
    }

    private Node zzZO1(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzYxD(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzlz(curNode, true);
    }

    private Node zzlz(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzZsC = node;
        do {
            node2 = this.zzZsC;
            Node node3 = this.zzWxC ? this.zzXQW(true, this.zzZsC) : (this.zzZsC = this.zzW4A.zzWGd() ? this.zzYZ8(true, this.zzZsC) : this.zzO1(true, this.zzZsC));
        } while (this.zzZsC != null && !this.zzW4A.zzZO1(this.zzZsC));
        return node2;
    }

    private Node zzYxD(Node node, boolean bl) throws Exception {
        while ((this.zzWxC ? this.zzXQW(bl, node) : (node = this.zzW4A.zzWGd() ? this.zzYZ8(bl, node) : this.zzO1(bl, node))) != null && !this.zzW4A.zzZO1(node)) {
        }
        return node;
    }

    private Node zzXQW(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzMC);
        }
        return node.previousPreOrder(this.zzMC);
    }

    private Node zzO1(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzMC) {
                return this.zzMC.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzMC) {
            return this.zzMC.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzYZ8(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzMC ? this.zzMC.zzpo() : node.zznO();
        } else {
            Node node3 = node2 = node == this.zzMC ? this.zzMC.zzVTO() : node.zzdQ();
        }
        if (node2 == this.zzMC.getNextSibling() || node2 == this.zzMC.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzY6k() {
        if (this.zzYEw != this.zzXI7()) {
            this.zzGK();
        }
    }

    private void zzGK() {
        this.zzYEw = this.zzXI7();
        this.zzYxf = -1;
        this.zzB = this.zzMC;
        this.zzZhS = -1;
    }

    private int zzXI7() {
        if (this.zzXfq != null) {
            return this.zzXfq.zzYOP();
        }
        return 0;
    }

    public int getCount() {
        this.zzY6k();
        if (this.zzZhS == -1) {
            this.zzZhS = zzXNG.zzXQW(this);
        }
        return this.zzZhS;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZsC;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzMC;
    }
}

